/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public abstract class WSDDDeployableItem
extends WSDDElement {
    public static final int SCOPE_PER_ACCESS = 0;
    public static final int SCOPE_PER_REQUEST = 1;
    public static final int SCOPE_SINGLETON = 2;
    public static String[] scopeStrings = new String[]{"per-access", "per-request", "singleton"};
    protected static Log log = LogFactory.getLog(WSDDDeployableItem.class.getName());
    protected LockableHashtable parameters;
    protected QName qname;
    protected QName type;
    protected int scope = 2;
    protected Handler singletonInstance = null;

    public WSDDDeployableItem() {
    }

    public WSDDDeployableItem(Element element) throws WSDDException {
        super(element);
        String string;
        String string2;
        String string3 = element.getAttribute("name");
        if (string3 != null && !string3.equals("")) {
            this.qname = new QName("", string3);
        }
        if ((string2 = element.getAttribute("type")) != null && !string2.equals("")) {
            this.type = XMLUtils.getQNameFromString(string2, element);
        }
        if ((string = element.getAttribute("scope")) != null) {
            for (int i = 0; i < scopeStrings.length; ++i) {
                if (!string.equals(scopeStrings[i])) continue;
                this.scope = i;
                break;
            }
        }
        this.parameters = new LockableHashtable();
        Element[] elementArray = this.getChildElements(element, "parameter");
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string4 = element2.getAttribute("name");
            String string5 = element2.getAttribute("value");
            String string6 = element2.getAttribute("locked");
            this.parameters.put(string4, string5, JavaUtils.isTrueExplicitly(string6));
        }
    }

    public void setName(String string) {
        this.qname = new QName(null, string);
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName qName) {
        this.type = qName;
    }

    public void setParameter(String string, String string2) {
        if (this.parameters == null) {
            this.parameters = new LockableHashtable();
        }
        this.parameters.put(string, string2);
    }

    public String getParameter(String string) {
        if (string == null || this.parameters == null) {
            return null;
        }
        return (String)this.parameters.get(string);
    }

    public LockableHashtable getParametersTable() {
        return this.parameters;
    }

    public void setOptionsHashtable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.parameters = new LockableHashtable((Map)hashtable);
    }

    public void writeParamsToContext(SerializationContext serializationContext) throws IOException {
        if (this.parameters == null) {
            return;
        }
        Set set = this.parameters.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "name", "name", "CDATA", string);
            attributesImpl.addAttribute("", "value", "value", "CDATA", entry.getValue().toString());
            if (this.parameters.isKeyLocked(string)) {
                attributesImpl.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            serializationContext.startElement(QNAME_PARAM, attributesImpl);
            serializationContext.endElement();
        }
    }

    public void removeParameter(String string) {
        if (this.parameters != null) {
            this.parameters.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Handler getInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        if (this.scope == 2) {
            WSDDDeployableItem wSDDDeployableItem = this;
            synchronized (wSDDDeployableItem) {
                if (this.singletonInstance == null) {
                    this.singletonInstance = this.getNewInstance(engineConfiguration);
                }
            }
            return this.singletonInstance;
        }
        return this.getNewInstance(engineConfiguration);
    }

    private Handler getNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        QName qName = this.getType();
        if (qName == null || "http://xml.apache.org/axis/wsdd/providers/java".equals(qName.getNamespaceURI())) {
            return this.makeNewInstance(engineConfiguration);
        }
        return engineConfiguration.getHandler(qName);
    }

    protected Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        Class clazz = null;
        Handler handler = null;
        try {
            clazz = this.getJavaClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException(classNotFoundException);
        }
        if (clazz != null) {
            try {
                handler = (Handler)this.createInstance(clazz);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
            if (handler != null) {
                if (this.qname != null) {
                    handler.setName(this.qname.getLocalPart());
                }
                handler.setOptions(this.getParametersTable());
                try {
                    handler.init();
                }
                catch (Exception exception) {
                    String string = exception + JavaUtils.LS + JavaUtils.stackToString(exception);
                    log.debug(string);
                    throw new ConfigurationException(exception);
                }
                catch (Error error) {
                    String string = error + JavaUtils.LS + JavaUtils.stackToString(error);
                    log.debug(string);
                    throw new ConfigurationException(string);
                }
            }
        } else {
            handler = engineConfiguration.getHandler(this.getType());
        }
        return handler;
    }

    Object createInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public Class getJavaClass() throws ClassNotFoundException {
        QName qName = this.getType();
        if (qName != null && "http://xml.apache.org/axis/wsdd/providers/java".equals(qName.getNamespaceURI())) {
            return ClassUtils.forName(qName.getLocalPart());
        }
        return null;
    }
}

