/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDArrayMapping;
import org.apache.axis.deployment.wsdd.WSDDBeanMapping;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDNonFatalException;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.WSDDTransport;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class WSDDDeployment
extends WSDDElement
implements WSDDTypeMappingContainer,
WSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog(WSDDDeployment.class.getName());
    private HashMap handlers = new HashMap();
    private HashMap services = new HashMap();
    private HashMap transports = new HashMap();
    private HashMap typeMappings = new HashMap();
    private WSDDGlobalConfiguration globalConfig = null;
    private HashMap namespaceToServices = new HashMap();
    private AxisEngine engine;
    TypeMappingRegistry tmr = new TypeMappingRegistryImpl();
    private boolean tmrDeployed = false;

    protected void addHandler(WSDDHandler wSDDHandler) {
        this.handlers.put(wSDDHandler.getQName(), wSDDHandler);
    }

    protected void addService(WSDDService wSDDService) {
        WSDDService wSDDService2 = (WSDDService)this.services.get(wSDDService.getQName());
        if (wSDDService2 != null) {
            wSDDService2.removeNamespaceMappings(this);
        }
        this.services.put(wSDDService.getQName(), wSDDService);
    }

    protected void addTransport(WSDDTransport wSDDTransport) {
        this.transports.put(wSDDTransport.getQName(), wSDDTransport);
    }

    public void deployHandler(WSDDHandler wSDDHandler) {
        wSDDHandler.deployToRegistry(this);
    }

    public void deployTransport(WSDDTransport wSDDTransport) {
        wSDDTransport.deployToRegistry(this);
    }

    public void deployService(WSDDService wSDDService) {
        wSDDService.deployToRegistry(this);
    }

    public void undeployHandler(QName qName) {
        this.handlers.remove(qName);
    }

    public void undeployService(QName qName) {
        WSDDService wSDDService = (WSDDService)this.services.get(qName);
        if (wSDDService != null) {
            wSDDService.removeNamespaceMappings(this);
            this.services.remove(qName);
        }
    }

    public void undeployTransport(QName qName) {
        this.transports.remove(qName);
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        QName qName = wSDDTypeMapping.getQName();
        String string = wSDDTypeMapping.getEncodingStyle();
        this.typeMappings.put(qName + string, wSDDTypeMapping);
        if (this.tmrDeployed) {
            this.deployMapping(wSDDTypeMapping);
        }
    }

    public WSDDDeployment() {
    }

    public WSDDDeployment(Element element) throws WSDDException {
        super(element);
        Object object;
        int n;
        Element[] elementArray = this.getChildElements(element, "handler");
        for (n = 0; n < elementArray.length; ++n) {
            object = new WSDDHandler(elementArray[n]);
            this.deployHandler((WSDDHandler)object);
        }
        elementArray = this.getChildElements(element, "chain");
        for (n = 0; n < elementArray.length; ++n) {
            object = new WSDDChain(elementArray[n]);
            this.deployHandler((WSDDHandler)object);
        }
        elementArray = this.getChildElements(element, "transport");
        for (n = 0; n < elementArray.length; ++n) {
            object = new WSDDTransport(elementArray[n]);
            this.deployTransport((WSDDTransport)object);
        }
        elementArray = this.getChildElements(element, "service");
        for (n = 0; n < elementArray.length; ++n) {
            try {
                object = new WSDDService(elementArray[n]);
                this.deployService((WSDDService)object);
                continue;
            }
            catch (WSDDNonFatalException wSDDNonFatalException) {
                log.info(Messages.getMessage("ignoringNonFatalException00"), wSDDNonFatalException);
                continue;
            }
            catch (WSDDException wSDDException) {
                throw wSDDException;
            }
        }
        elementArray = this.getChildElements(element, "typeMapping");
        for (n = 0; n < elementArray.length; ++n) {
            try {
                object = new WSDDTypeMapping(elementArray[n]);
                this.deployTypeMapping((WSDDTypeMapping)object);
                continue;
            }
            catch (WSDDNonFatalException wSDDNonFatalException) {
                log.info(Messages.getMessage("ignoringNonFatalException00"), wSDDNonFatalException);
                continue;
            }
            catch (WSDDException wSDDException) {
                throw wSDDException;
            }
        }
        elementArray = this.getChildElements(element, "beanMapping");
        for (n = 0; n < elementArray.length; ++n) {
            object = new WSDDBeanMapping(elementArray[n]);
            this.deployTypeMapping((WSDDTypeMapping)object);
        }
        elementArray = this.getChildElements(element, "arrayMapping");
        for (n = 0; n < elementArray.length; ++n) {
            object = new WSDDArrayMapping(elementArray[n]);
            this.deployTypeMapping((WSDDTypeMapping)object);
        }
        object = this.getChildElement(element, "globalConfiguration");
        if (object != null) {
            this.globalConfig = new WSDDGlobalConfiguration((Element)object);
        }
    }

    protected QName getElementName() {
        return QNAME_DEPLOY;
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) throws ConfigurationException {
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.getGlobalConfiguration();
        if (wSDDGlobalConfiguration != null) {
            wSDDDeployment.setGlobalConfiguration(wSDDGlobalConfiguration);
        }
        for (WSDDElement wSDDElement : this.handlers.values()) {
            wSDDDeployment.deployHandler((WSDDHandler)wSDDElement);
        }
        for (WSDDElement wSDDElement : this.transports.values()) {
            wSDDDeployment.deployTransport((WSDDTransport)wSDDElement);
        }
        for (WSDDElement wSDDElement : this.services.values()) {
            ((WSDDService)wSDDElement).deployToRegistry(wSDDDeployment);
        }
        for (WSDDElement wSDDElement : this.typeMappings.values()) {
            wSDDDeployment.deployTypeMapping((WSDDTypeMapping)wSDDElement);
        }
    }

    private void deployMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        try {
            String string = wSDDTypeMapping.getEncodingStyle();
            if (string == null) {
                string = Constants.URI_DEFAULT_SOAP_ENC;
            }
            TypeMapping typeMapping = this.tmr.getOrMakeTypeMapping(string);
            SerializerFactory serializerFactory = null;
            DeserializerFactory deserializerFactory = null;
            if (wSDDTypeMapping.getSerializerName() != null && !wSDDTypeMapping.getSerializerName().equals("")) {
                serializerFactory = BaseSerializerFactory.createFactory(wSDDTypeMapping.getSerializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            if (wSDDTypeMapping instanceof WSDDArrayMapping && serializerFactory instanceof ArraySerializerFactory) {
                WSDDArrayMapping wSDDArrayMapping = (WSDDArrayMapping)wSDDTypeMapping;
                ArraySerializerFactory arraySerializerFactory = (ArraySerializerFactory)serializerFactory;
                arraySerializerFactory.setComponentType(wSDDArrayMapping.getInnerType());
            }
            if (wSDDTypeMapping.getDeserializerName() != null && !wSDDTypeMapping.getDeserializerName().equals("")) {
                deserializerFactory = BaseDeserializerFactory.createFactory(wSDDTypeMapping.getDeserializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            typeMapping.register(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), serializerFactory, deserializerFactory);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error(Messages.getMessage("unabletoDeployTypemapping00", wSDDTypeMapping.getQName().toString()), classNotFoundException);
            throw new WSDDNonFatalException(classNotFoundException);
        }
        catch (Exception exception) {
            throw new WSDDException(exception);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        serializationContext.registerPrefixForURI("", "http://xml.apache.org/axis/wsdd/");
        serializationContext.registerPrefixForURI("java", "http://xml.apache.org/axis/wsdd/providers/java");
        serializationContext.startElement(QNAME_DEPLOY, null);
        if (this.globalConfig != null) {
            this.globalConfig.writeToContext(serializationContext);
        }
        for (WSDDElement wSDDElement : this.handlers.values()) {
            ((WSDDHandler)wSDDElement).writeToContext(serializationContext);
        }
        for (WSDDElement wSDDElement : this.services.values()) {
            ((WSDDService)wSDDElement).writeToContext(serializationContext);
        }
        for (WSDDElement wSDDElement : this.transports.values()) {
            ((WSDDTransport)wSDDElement).writeToContext(serializationContext);
        }
        for (WSDDElement wSDDElement : this.typeMappings.values()) {
            ((WSDDTypeMapping)wSDDElement).writeToContext(serializationContext);
        }
        serializationContext.endElement();
    }

    public WSDDGlobalConfiguration getGlobalConfiguration() {
        return this.globalConfig;
    }

    public void setGlobalConfiguration(WSDDGlobalConfiguration wSDDGlobalConfiguration) {
        this.globalConfig = wSDDGlobalConfiguration;
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] wSDDTypeMappingArray = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.values().toArray(wSDDTypeMappingArray);
        return wSDDTypeMappingArray;
    }

    public WSDDService[] getServices() {
        WSDDService[] wSDDServiceArray = new WSDDService[this.services.size()];
        this.services.values().toArray(wSDDServiceArray);
        return wSDDServiceArray;
    }

    public WSDDService getWSDDService(QName qName) {
        return (WSDDService)this.services.get(qName);
    }

    public Handler getHandler(QName qName) throws ConfigurationException {
        WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(qName);
        if (wSDDHandler != null) {
            return wSDDHandler.getInstance(this);
        }
        return null;
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        WSDDTransport wSDDTransport = (WSDDTransport)this.transports.get(qName);
        if (wSDDTransport != null) {
            return wSDDTransport.getInstance(this);
        }
        return null;
    }

    public SOAPService getService(QName qName) throws ConfigurationException {
        WSDDService wSDDService = (WSDDService)this.services.get(qName);
        if (wSDDService != null) {
            return (SOAPService)wSDDService.getInstance(this);
        }
        return null;
    }

    public SOAPService getServiceByNamespaceURI(String string) throws ConfigurationException {
        WSDDService wSDDService = (WSDDService)this.namespaceToServices.get(string);
        if (wSDDService != null) {
            return (SOAPService)wSDDService.getInstance(this);
        }
        return null;
    }

    public void configureEngine(AxisEngine axisEngine) throws ConfigurationException {
        this.engine = axisEngine;
    }

    public void writeEngineConfig(AxisEngine axisEngine) throws ConfigurationException {
    }

    public TypeMapping getTypeMapping(String string) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(string);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (!this.tmrDeployed) {
            for (WSDDTypeMapping wSDDTypeMapping : this.typeMappings.values()) {
                this.deployMapping(wSDDTypeMapping);
            }
            this.tmrDeployed = true;
        }
        return this.tmr;
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        WSDDRequestFlow wSDDRequestFlow;
        if (this.globalConfig != null && (wSDDRequestFlow = this.globalConfig.getRequestFlow()) != null) {
            return wSDDRequestFlow.getInstance(this);
        }
        return null;
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        WSDDResponseFlow wSDDResponseFlow;
        if (this.globalConfig != null && (wSDDResponseFlow = this.globalConfig.getResponseFlow()) != null) {
            return wSDDResponseFlow.getInstance(this);
        }
        return null;
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        return this.globalConfig.getParametersTable();
    }

    public List getRoles() {
        return this.globalConfig == null ? new ArrayList() : this.globalConfig.getRoles();
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        ArrayList<ServiceDesc> arrayList = new ArrayList<ServiceDesc>();
        for (WSDDService wSDDService : this.services.values()) {
            try {
                wSDDService.makeNewInstance(this);
                arrayList.add(wSDDService.getServiceDesc());
            }
            catch (WSDDNonFatalException wSDDNonFatalException) {
                log.info(Messages.getMessage("ignoringNonFatalException00"), wSDDNonFatalException);
            }
        }
        return arrayList.iterator();
    }

    public void registerNamespaceForService(String string, WSDDService wSDDService) {
        this.namespaceToServices.put(string, wSDDService);
    }

    public void removeNamespaceMapping(String string) {
        this.namespaceToServices.remove(string);
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public WSDDDeployment getDeployment() {
        return this;
    }

    public WSDDHandler[] getHandlers() {
        WSDDHandler[] wSDDHandlerArray = new WSDDHandler[this.handlers.size()];
        this.handlers.values().toArray(wSDDHandlerArray);
        return wSDDHandlerArray;
    }

    public WSDDHandler getWSDDHandler(QName qName) {
        return (WSDDHandler)this.handlers.get(qName);
    }

    public WSDDTransport[] getTransports() {
        WSDDTransport[] wSDDTransportArray = new WSDDTransport[this.transports.size()];
        this.transports.values().toArray(wSDDTransportArray);
        return wSDDTransportArray;
    }

    public WSDDTransport getWSDDTransport(QName qName) {
        return (WSDDTransport)this.transports.get(qName);
    }
}

