/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.Part;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Callback;
import org.apache.axis.encoding.CallbackTarget;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Target;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeserializerImpl
extends SOAPHandler
implements javax.xml.rpc.encoding.Deserializer,
Deserializer,
Callback {
    protected static Log log = LogFactory.getLog(DeserializerImpl.class.getName());
    protected Object value = null;
    private final boolean debugEnabled = log.isDebugEnabled();
    protected boolean isEnded = false;
    protected Vector targets = null;
    protected QName defaultType = null;
    protected boolean componentsReadyFlag = false;
    private HashSet activeDeserializers = new HashSet();
    protected boolean isHref = false;
    protected boolean isNil = false;
    protected String id = null;

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getValue(Object object) {
        return null;
    }

    public void setChildValue(Object object, Object object2) throws SAXException {
    }

    public void setValue(Object object, Object object2) throws SAXException {
        if (object2 instanceof Deserializer) {
            this.activeDeserializers.remove(object2);
            if (this.componentsReady()) {
                this.valueComplete();
            }
        }
    }

    public void setDefaultType(QName qName) {
        this.defaultType = qName;
    }

    public QName getDefaultType() {
        return this.defaultType;
    }

    public void registerValueTarget(Target target) {
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addElement(target);
    }

    public Vector getValueTargets() {
        return this.targets;
    }

    public void removeValueTargets() {
        if (this.targets != null) {
            this.targets = null;
        }
    }

    public void moveValueTargets(Deserializer deserializer) {
        if (deserializer == null || deserializer.getValueTargets() == null) {
            return;
        }
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addAll(deserializer.getValueTargets());
        deserializer.removeValueTargets();
    }

    public boolean componentsReady() {
        return this.componentsReadyFlag || !this.isHref && this.isEnded && this.activeDeserializers.isEmpty();
    }

    public void valueComplete() throws SAXException {
        if (this.componentsReady() && this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                Target target = (Target)this.targets.get(i);
                target.set(this.value);
                if (!this.debugEnabled) continue;
                log.debug(Messages.getMessage("setValueInTarget00", "" + this.value, "" + target));
            }
            this.removeValueTargets();
        }
    }

    public void addChildDeserializer(Deserializer deserializer) {
        if (this.activeDeserializers != null) {
            this.activeDeserializers.add(deserializer);
        }
        deserializer.registerValueTarget(new CallbackTarget(this, deserializer));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        String string4;
        super.startElement(string, string2, string3, attributes, deserializationContext);
        if (deserializationContext.isNil(attributes)) {
            this.value = null;
            this.isNil = true;
            return;
        }
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        this.id = attributes.getValue("id");
        if (this.id != null) {
            deserializationContext.addObjectById(this.id, this.value);
            if (this.debugEnabled) {
                log.debug(Messages.getMessage("deserInitPutValueDebug00", "" + this.value, this.id));
            }
            deserializationContext.registerFixup("#" + this.id, this);
        }
        if ((string4 = attributes.getValue(sOAPConstants.getAttrHref())) != null) {
            this.isHref = true;
            Object object = deserializationContext.getObjectByRef(string4);
            if (this.debugEnabled) {
                log.debug(Messages.getMessage("gotForID00", new String[]{"" + object, string4, object == null ? "*null*" : object.getClass().toString()}));
            }
            if (object == null) {
                deserializationContext.registerFixup(string4, this);
                return;
            }
            if (object instanceof MessageElement) {
                deserializationContext.replaceElementHandler(new EnvelopeHandler(this));
                SAX2EventRecorder sAX2EventRecorder = deserializationContext.getRecorder();
                deserializationContext.setRecorder(null);
                ((MessageElement)object).publishToHandler(deserializationContext);
                deserializationContext.setRecorder(sAX2EventRecorder);
            } else {
                Deserializer deserializer;
                if (!string4.startsWith("#") && this.defaultType != null && object instanceof Part && null != (deserializer = deserializationContext.getDeserializerForType(this.defaultType))) {
                    deserializer.startElement(string, string2, string3, attributes, deserializationContext);
                    object = deserializer.getValue();
                }
                this.value = object;
                this.componentsReadyFlag = true;
                this.valueComplete();
            }
        } else {
            this.isHref = false;
            this.onStartElement(string, string2, string3, attributes, deserializationContext);
        }
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (this.getClass().equals(DeserializerImpl.class)) {
            QName qName = deserializationContext.getTypeFromAttributes(string, string2, attributes);
            if (qName == null && (qName = this.defaultType) == null) {
                qName = Constants.XSD_STRING;
            }
            if (this.debugEnabled) {
                log.debug(Messages.getMessage("gotType00", "Deser", "" + qName));
            }
            if (qName != null) {
                Deserializer deserializer = deserializationContext.getDeserializerForType(qName);
                if (deserializer == null) {
                    deserializer = deserializationContext.getDeserializerForClass(null);
                }
                if (deserializer != null) {
                    deserializer.moveValueTargets(this);
                    deserializationContext.replaceElementHandler((SOAPHandler)((Object)deserializer));
                    boolean bl = deserializationContext.isProcessingRef();
                    deserializationContext.setProcessingRef(true);
                    deserializer.startElement(string, string2, string3, attributes, deserializationContext);
                    deserializationContext.setProcessingRef(bl);
                } else {
                    throw new SAXException(Messages.getMessage("noDeser00", "" + qName));
                }
            }
        }
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        return null;
    }

    public final void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        super.endElement(string, string2, deserializationContext);
        this.isEnded = true;
        if (!this.isHref) {
            this.onEndElement(string, string2, deserializationContext);
        }
        if (this.componentsReady()) {
            this.valueComplete();
        }
        if (this.id != null) {
            deserializationContext.addObjectById(this.id, this.value);
            if (this.debugEnabled) {
                log.debug(Messages.getMessage("deserPutValueDebug00", "" + this.value, this.id));
            }
        }
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.getClass().equals(DeserializerImpl.class) && this.targets != null && !this.targets.isEmpty()) {
            StringWriter stringWriter = new StringWriter();
            SerializationContext serializationContext = new SerializationContext(stringWriter, deserializationContext.getMessageContext());
            serializationContext.setSendDecl(false);
            SAXOutputter sAXOutputter = null;
            sAXOutputter = new SAXOutputter(serializationContext);
            deserializationContext.getCurElement().publishContents(sAXOutputter);
            if (!this.isNil) {
                this.value = stringWriter.getBuffer().toString();
            }
        }
    }
}

