/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class Base64Serializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;

    public Base64Serializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.startElement(qName, attributes);
        serializationContext.writeString(this.getValueAsString(object, serializationContext));
        serializationContext.endElement();
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        byte[] byArray = null;
        if (this.javaType == byte[].class) {
            byArray = (byte[])object;
        } else {
            byArray = new byte[((Byte[])object).length];
            for (int i = 0; i < byArray.length; ++i) {
                Byte by = ((Byte[])object)[i];
                if (by == null) continue;
                byArray[i] = by;
            }
        }
        return Base64.encode(byArray, 0, byArray.length);
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        return null;
    }
}

