/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.utils.Messages;

public class CalendarDeserializer
extends SimpleDeserializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public CalendarDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeValue(String string) {
        int n;
        int n2;
        Date date;
        Calendar calendar = Calendar.getInstance();
        boolean bl = false;
        if (string == null || string.length() == 0) {
            throw new NumberFormatException(Messages.getMessage("badDateTime00"));
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if (string.charAt(0) == '-') {
            string = string.substring(1);
            bl = true;
        }
        if (string.length() < 19) {
            throw new NumberFormatException(Messages.getMessage("badDateTime00"));
        }
        if (string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != 'T') {
            throw new NumberFormatException(Messages.getMessage("badDate00"));
        }
        if (string.charAt(13) != ':' || string.charAt(16) != ':') {
            throw new NumberFormatException(Messages.getMessage("badTime00"));
        }
        try {
            SimpleDateFormat simpleDateFormat = zulu;
            synchronized (simpleDateFormat) {
                date = zulu.parse(string.substring(0, 19) + ".000Z");
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException(exception.toString());
        }
        int n3 = 19;
        if (n3 < string.length() && string.charAt(n3) == '.') {
            n2 = 0;
            n = ++n3;
            while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                ++n3;
            }
            String string2 = string.substring(n, n3);
            if (string2.length() == 3) {
                n2 = Integer.parseInt(string2);
            } else if (string2.length() < 3) {
                n2 = Integer.parseInt((string2 + "000").substring(0, 3));
            } else {
                n2 = Integer.parseInt(string2.substring(0, 3));
                if (string2.charAt(3) >= '5') {
                    ++n2;
                }
            }
            date.setTime(date.getTime() + (long)n2);
        }
        if (n3 + 5 < string.length() && (string.charAt(n3) == '+' || string.charAt(n3) == '-')) {
            if (!(Character.isDigit(string.charAt(n3 + 1)) && Character.isDigit(string.charAt(n3 + 2)) && string.charAt(n3 + 3) == ':' && Character.isDigit(string.charAt(n3 + 4)) && Character.isDigit(string.charAt(n3 + 5)))) {
                throw new NumberFormatException(Messages.getMessage("badTimezone00"));
            }
            n2 = (string.charAt(n3 + 1) - 48) * 10 + string.charAt(n3 + 2) - 48;
            n = (string.charAt(n3 + 4) - 48) * 10 + string.charAt(n3 + 5) - 48;
            int n4 = (n2 * 60 + n) * 60 * 1000;
            if (string.charAt(n3) == '+') {
                n4 = -n4;
            }
            date.setTime(date.getTime() + (long)n4);
            n3 += 6;
        }
        if (n3 < string.length() && string.charAt(n3) == 'Z') {
            ++n3;
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        if (n3 < string.length()) {
            throw new NumberFormatException(Messages.getMessage("badChars00"));
        }
        calendar.setTime(date);
        if (bl) {
            calendar.set(0, 0);
        }
        if (this.javaType == Date.class) {
            return date;
        }
        return calendar;
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

