/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.types.HexBinary;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class HexSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;

    public HexSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.startElement(qName, attributes);
        serializationContext.writeString(this.getValueAsString(object, serializationContext));
        serializationContext.endElement();
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        object = JavaUtils.convert(object, this.javaType);
        if (this.javaType == HexBinary.class) {
            return object.toString();
        }
        return HexBinary.encode((byte[])object);
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        return null;
    }
}

