/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MapDeserializer
extends DeserializerImpl {
    protected static Log log = LogFactory.getLog(MapDeserializer.class.getName());
    public static final Object KEYHINT = new Object();
    public static final Object VALHINT = new Object();
    public static final Object NILHINT = new Object();

    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter MapDeserializer::startElement()");
        }
        if (deserializationContext.isNil(attributes)) {
            return;
        }
        this.setValue(new HashMap());
        if (log.isDebugEnabled()) {
            log.debug("Exit: MapDeserializer::startElement()");
        }
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MapDeserializer::onStartChild()");
        }
        if (string2.equals("item")) {
            ItemHandler itemHandler = new ItemHandler(this);
            this.addChildDeserializer(itemHandler);
            if (log.isDebugEnabled()) {
                log.debug("Exit: MapDeserializer::onStartChild()");
            }
            return itemHandler;
        }
        return this;
    }

    public void setChildValue(Object object, Object object2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotValue00", "MapDeserializer", "" + object));
        }
        ((Map)this.value).put(object2, object);
    }

    class ItemHandler
    extends DeserializerImpl {
        Object key;
        Object myValue;
        int numSet = 0;
        MapDeserializer md = null;

        ItemHandler(MapDeserializer mapDeserializer2) {
            this.md = mapDeserializer2;
        }

        public void setChildValue(Object object, Object object2) throws SAXException {
            if (object2 == KEYHINT) {
                this.key = object;
            } else if (object2 == VALHINT) {
                this.myValue = object;
            } else if (object2 != NILHINT) {
                return;
            }
            ++this.numSet;
            if (this.numSet == 2) {
                this.md.setChildValue(this.myValue, this.key);
            }
        }

        public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
            QName qName = deserializationContext.getTypeFromAttributes(string, string2, attributes);
            Deserializer deserializer = deserializationContext.getDeserializerForType(qName);
            if (deserializer == null) {
                deserializer = new DeserializerImpl();
            }
            DeserializerTarget deserializerTarget = null;
            if (deserializationContext.isNil(attributes)) {
                deserializerTarget = new DeserializerTarget(this, NILHINT);
            } else if (string2.equals("key")) {
                deserializerTarget = new DeserializerTarget(this, KEYHINT);
            } else if (string2.equals("value")) {
                deserializerTarget = new DeserializerTarget(this, VALHINT);
            }
            if (deserializerTarget != null) {
                deserializer.registerValueTarget(deserializerTarget);
            }
            this.addChildDeserializer(deserializer);
            return (SOAPHandler)((Object)deserializer);
        }
    }
}

