/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class MapSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(MapSerializer.class.getName());
    private static final QName QNAME_KEY = new QName("", "key");
    private static final QName QNAME_ITEM = new QName("", "item");
    private static final QName QNAME_VALUE = new QName("", "value");
    private static final QName QNAME_ITEMTYPE = new QName("http://xml.apache.org/xml-soap", "item");

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        if (!(object instanceof Map)) {
            throw new IOException(Messages.getMessage("noMap00", "MapSerializer", object.getClass().getName()));
        }
        Map map = (Map)object;
        serializationContext.startElement(qName, attributes);
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = serializationContext.getMessageContext().getEncodingStyle();
        String string2 = serializationContext.getPrefixForURI(string);
        String string3 = serializationContext.getPrefixForURI(Constants.SOAP_MAP.getNamespaceURI());
        attributesImpl.addAttribute(string, "type", string2 + ":type", "CDATA", string2 + ":Array");
        attributesImpl.addAttribute(string, "arrayType", string2 + ":arrayType", "CDATA", string3 + ":item[" + map.size() + "]");
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            serializationContext.startElement(QNAME_ITEM, null);
            serializationContext.serialize(QNAME_KEY, null, k, null, null, Boolean.TRUE);
            serializationContext.serialize(QNAME_VALUE, null, v, null, null, Boolean.TRUE);
            serializationContext.endElement();
        }
        serializationContext.endElement();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        Element element = types.createElement("complexType");
        element.setAttribute("name", "Map");
        Element element2 = types.createElement("sequence");
        element.appendChild(element2);
        Element element3 = types.createElement("element");
        element3.setAttribute("name", "item");
        element3.setAttribute("minOccurs", "0");
        element3.setAttribute("maxOccurs", "unbounded");
        element3.setAttribute("type", types.getQNameString(new QName("http://xml.apache.org/xml-soap", "mapItem")));
        element2.appendChild(element3);
        Element element4 = types.createElement("complexType");
        element4.setAttribute("name", "mapItem");
        Element element5 = types.createElement("sequence");
        element4.appendChild(element5);
        Element element6 = types.createElement("element");
        element6.setAttribute("name", "key");
        element6.setAttribute("nillable", "true");
        element6.setAttribute("type", "xsd:anyType");
        element5.appendChild(element6);
        Element element7 = types.createElement("element");
        element7.setAttribute("name", "value");
        element7.setAttribute("nillable", "true");
        element7.setAttribute("type", "xsd:anyType");
        element5.appendChild(element7);
        types.writeSchemaTypeDecl(QNAME_ITEMTYPE, element4);
        return element;
    }
}

