/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Deserializer;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;

public class SimpleDeserializerFactory
extends BaseDeserializerFactory {
    private static final Class[] STRING_STRING_CLASS = new Class[]{String.class, String.class};
    private static final Class[] STRING_CLASS = new Class[]{String.class};
    private transient Constructor constructor = null;
    private boolean isBasicType = false;

    public SimpleDeserializerFactory(Class clazz, QName qName) {
        super(SimpleDeserializer.class, qName, clazz);
        this.isBasicType = JavaUtils.isBasic(clazz);
        this.initConstructor(clazz);
    }

    private void initConstructor(Class clazz) {
        if (!this.isBasicType) {
            try {
                this.constructor = QName.class.isAssignableFrom(clazz) ? clazz.getDeclaredConstructor(STRING_STRING_CLASS) : clazz.getDeclaredConstructor(STRING_CLASS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    this.constructor = clazz.getDeclaredConstructor(new Class[0]);
                    BeanPropertyDescriptor[] beanPropertyDescriptorArray = BeanUtils.getPd(clazz);
                    if (beanPropertyDescriptorArray != null && BeanUtils.getSpecificPD(beanPropertyDescriptorArray, "_value") != null) {
                        return;
                    }
                    throw new IllegalArgumentException(noSuchMethodException.toString());
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new IllegalArgumentException(noSuchMethodException2.toString());
                }
            }
        }
    }

    public Deserializer getDeserializerAs(String string) throws JAXRPCException {
        if (this.javaType == Object.class) {
            return null;
        }
        if (this.isBasicType) {
            return new SimpleDeserializer(this.javaType, this.xmlType);
        }
        SimpleDeserializer simpleDeserializer = (SimpleDeserializer)super.getDeserializerAs(string);
        if (simpleDeserializer != null) {
            simpleDeserializer.setConstructor(this.constructor);
        }
        return simpleDeserializer;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initConstructor(this.javaType);
    }
}

