/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class HandlerChainImpl
extends ArrayList
implements HandlerChain {
    protected static Log log = LogFactory.getLog(HandlerChainImpl.class.getName());
    public static final String JAXRPC_METHOD_INFO = "jaxrpc.method.info";
    private String[] _roles;
    private int falseIndex = -1;
    protected List handlerInfos = new ArrayList();

    public String[] getRoles() {
        return this._roles;
    }

    public void setRoles(String[] stringArray) {
        if (stringArray != null) {
            this._roles = (String[])stringArray.clone();
        }
    }

    public void init(Map map) {
    }

    public HandlerChainImpl() {
    }

    public HandlerChainImpl(List list) {
        this.handlerInfos = list;
        for (int i = 0; i < list.size(); ++i) {
            this.add(this.newHandler(this.getHandlerInfo(i)));
        }
    }

    public void addNewHandler(String string, Map map) {
        try {
            HandlerInfo handlerInfo = new HandlerInfo(ClassUtils.forName(string), map, null);
            this.handlerInfos.add(handlerInfo);
            this.add(this.newHandler(handlerInfo));
        }
        catch (Exception exception) {
            String string2 = Messages.getMessage("NoJAXRPCHandler00", string);
            throw new JAXRPCException(string2, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFault(javax.xml.rpc.handler.MessageContext messageContext) {
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        this.preInvoke(sOAPMessageContext);
        try {
            int n;
            int n2 = this.size() - 1;
            if (this.falseIndex != -1) {
                n2 = this.falseIndex;
            }
            for (n = n2; n >= 0; --n) {
                if (this.getHandlerInstance(n).handleFault(sOAPMessageContext)) continue;
                boolean bl = false;
                return bl;
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.postInvoke(sOAPMessageContext);
        }
    }

    public ArrayList getMessageInfo(SOAPMessage sOAPMessage) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (sOAPMessage == null || sOAPMessage.getSOAPPart() == null) {
                return arrayList;
            }
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            Iterator iterator = sOAPBody.getChildElements();
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            arrayList.add(sOAPElement.getElementName().toString());
            Iterator iterator2 = sOAPElement.getChildElements();
            while (iterator2.hasNext()) {
                SOAPElement sOAPElement2 = (SOAPElement)iterator2.next();
                arrayList.add(sOAPElement2.getElementName().toString());
            }
        }
        catch (Exception exception) {
            log.debug("Exception in getMessageInfo : ", exception);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(javax.xml.rpc.handler.MessageContext messageContext) {
        MessageContext messageContext2 = (MessageContext)messageContext;
        messageContext2.setRoles(this.getRoles());
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        this.preInvoke(sOAPMessageContext);
        try {
            int n;
            for (n = 0; n < this.size(); ++n) {
                Handler handler = this.getHandlerInstance(n);
                try {
                    if (handler.handleRequest(sOAPMessageContext)) continue;
                    this.falseIndex = n;
                    boolean bl = false;
                    return bl;
                }
                catch (SOAPFaultException sOAPFaultException) {
                    this.falseIndex = n;
                    throw sOAPFaultException;
                }
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.postInvoke(sOAPMessageContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResponse(javax.xml.rpc.handler.MessageContext messageContext) {
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        this.preInvoke(sOAPMessageContext);
        try {
            int n;
            int n2 = this.size() - 1;
            if (this.falseIndex != -1) {
                n2 = this.falseIndex;
            }
            for (n = n2; n >= 0; --n) {
                if (this.getHandlerInstance(n).handleResponse(messageContext)) continue;
                boolean bl = false;
                return bl;
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.postInvoke(sOAPMessageContext);
        }
    }

    private void preInvoke(SOAPMessageContext sOAPMessageContext) {
        try {
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            if (sOAPMessage != null && sOAPMessage.getSOAPPart() != null) {
                sOAPMessage.getSOAPPart().getEnvelope();
            }
            sOAPMessageContext.setProperty("axis.form.optimization", Boolean.FALSE);
            sOAPMessageContext.setProperty(JAXRPC_METHOD_INFO, this.getMessageInfo(sOAPMessage));
        }
        catch (Exception exception) {
            log.debug("Exception in preInvoke : ", exception);
            throw new RuntimeException("Exception in preInvoke : " + exception.toString());
        }
    }

    private void postInvoke(SOAPMessageContext sOAPMessageContext) {
        Boolean bl = (Boolean)sOAPMessageContext.getProperty("axis.form.optimization");
        if (bl != null && !bl.booleanValue()) {
            sOAPMessageContext.setProperty("axis.form.optimization", Boolean.TRUE);
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            ArrayList arrayList = (ArrayList)sOAPMessageContext.getProperty(JAXRPC_METHOD_INFO);
            if (arrayList != null && !Arrays.equals(arrayList.toArray(), this.getMessageInfo(sOAPMessage).toArray())) {
                throw new RuntimeException(Messages.getMessage("invocationArgumentsModified00"));
            }
            try {
                if (sOAPMessage != null) {
                    sOAPMessage.saveChanges();
                }
            }
            catch (SOAPException sOAPException) {
                log.debug("Exception in postInvoke : ", sOAPException);
                throw new RuntimeException("Exception in postInvoke : " + sOAPException.toString());
            }
        }
    }

    public void destroy() {
        int n = this.size() - 1;
        if (this.falseIndex != -1) {
            n = this.falseIndex;
        }
        for (int i = n; i >= 0; --i) {
            this.getHandlerInstance(i).destroy();
        }
        this.falseIndex = -1;
        this.clear();
    }

    private Handler getHandlerInstance(int n) {
        return (Handler)this.get(n);
    }

    private HandlerInfo getHandlerInfo(int n) {
        return (HandlerInfo)this.handlerInfos.get(n);
    }

    private Handler newHandler(HandlerInfo handlerInfo) {
        try {
            Handler handler = (Handler)handlerInfo.getHandlerClass().newInstance();
            handler.init(handlerInfo);
            return handler;
        }
        catch (Exception exception) {
            String string = Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString());
            throw new JAXRPCException(string, exception);
        }
    }
}

