/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.components.compiler.Compiler;
import org.apache.axis.components.compiler.CompilerError;
import org.apache.axis.components.compiler.CompilerFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Scope;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.ClasspathUtils;
import org.apache.axis.utils.JWSClassLoader;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JWSHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(JWSHandler.class.getName());
    public final String OPTION_JWS_FILE_EXTENSION = "extension";
    public final String DEFAULT_JWS_FILE_EXTENSION = ".jws";
    protected static HashMap soapServices = new HashMap();

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JWSHandler::invoke");
        }
        try {
            this.setupService(messageContext);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            throw AxisFault.makeFault(exception);
        }
    }

    protected void setupService(MessageContext messageContext) throws Exception {
        String string = messageContext.getStrProp("realpath");
        String string2 = (String)this.getOption("extension");
        if (string2 == null) {
            string2 = ".jws";
        }
        if (string != null && string.endsWith(string2)) {
            Object object;
            Object object2;
            Object object3;
            File file;
            String string3 = string;
            String string4 = messageContext.getStrProp("path");
            File file2 = new File(string3);
            if (!file2.exists()) {
                throw new FileNotFoundException(string4);
            }
            if (string4.charAt(0) == '/') {
                string4 = string4.substring(1);
            }
            int n = string4.lastIndexOf(47);
            String string5 = null;
            if (n > 0) {
                string5 = string4.substring(0, n);
            }
            String string6 = string4.substring(n + 1);
            String string7 = messageContext.getStrProp("jws.classDir");
            if (string7 == null) {
                string7 = ".";
            }
            if (string5 != null) {
                string7 = string7 + File.separator + string5;
            }
            if (!(file = new File(string7)).exists()) {
                file.mkdirs();
            }
            if (log.isDebugEnabled()) {
                log.debug("jwsFile: " + string3);
            }
            String string8 = string7 + File.separator + string6.substring(0, string6.length() - string2.length() + 1) + "java";
            String string9 = string7 + File.separator + string6.substring(0, string6.length() - string2.length() + 1) + "class";
            if (log.isDebugEnabled()) {
                log.debug("jFile: " + string8);
                log.debug("cFile: " + string9);
                log.debug("outdir: " + string7);
            }
            File file3 = new File(string9);
            String string10 = null;
            if (string10 == null) {
                string10 = file2.getName();
            }
            if (string10 != null && string10.charAt(0) == '/') {
                string10 = string10.substring(1);
            }
            string10 = string10.substring(0, string10.length() - string2.length());
            string10 = string10.replace('/', '.');
            if (log.isDebugEnabled()) {
                log.debug("ClsName: " + string10);
            }
            if (!file3.exists() || file2.lastModified() > file3.lastModified()) {
                int n2;
                log.debug(Messages.getMessage("compiling00", string3));
                log.debug(Messages.getMessage("copy00", string3, string8));
                object3 = new FileReader(string3);
                object2 = new FileWriter(string8);
                object = new char[4096];
                while ((n2 = ((InputStreamReader)object3).read((char[])object, 0, 4095)) >= 0) {
                    ((OutputStreamWriter)object2).write((char[])object, 0, n2);
                }
                ((OutputStreamWriter)object2).close();
                ((InputStreamReader)object3).close();
                log.debug("javac " + string8);
                Compiler compiler = CompilerFactory.getCompiler();
                compiler.setClasspath(ClasspathUtils.getDefaultClasspath(messageContext));
                compiler.setDestination(string7);
                compiler.addFile(string8);
                boolean bl = compiler.compile();
                new File(string8).delete();
                if (!bl) {
                    new File(string9).delete();
                    Document document = XMLUtils.newDocument();
                    Element element = document.createElementNS("", "Errors");
                    StringBuffer stringBuffer = new StringBuffer("Error compiling ");
                    stringBuffer.append(string8);
                    stringBuffer.append(":\n");
                    List list = compiler.getErrors();
                    int n3 = list.size();
                    for (int i = 0; i < n3; ++i) {
                        CompilerError compilerError = (CompilerError)list.get(i);
                        if (i > 0) {
                            stringBuffer.append("\n");
                        }
                        stringBuffer.append("Line ");
                        stringBuffer.append(compilerError.getStartLine());
                        stringBuffer.append(", column ");
                        stringBuffer.append(compilerError.getStartColumn());
                        stringBuffer.append(": ");
                        stringBuffer.append(compilerError.getMessage());
                    }
                    element.appendChild(document.createTextNode(stringBuffer.toString()));
                    throw new AxisFault("Server.compileError", Messages.getMessage("badCompile00", string8), null, new Element[]{element});
                }
                ClassUtils.removeClassLoader(string10);
                soapServices.remove(string10);
            }
            if ((object3 = ClassUtils.getClassLoader(string10)) == null) {
                object3 = new JWSClassLoader(string10, messageContext.getClassLoader(), string9);
            }
            messageContext.setClassLoader((ClassLoader)object3);
            object2 = (SOAPService)soapServices.get(string10);
            if (object2 == null) {
                object2 = new SOAPService(new RPCProvider());
                ((BasicHandler)object2).setName(string10);
                ((BasicHandler)object2).setOption("className", string10);
                ((SOAPService)object2).setEngine(messageContext.getAxisEngine());
                object = (String)this.getOption("allowedMethods");
                if (object == null) {
                    object = "*";
                }
                ((BasicHandler)object2).setOption("allowedMethods", object);
                String string11 = (String)this.getOption("scope");
                if (string11 == null) {
                    string11 = Scope.DEFAULT.getName();
                }
                ((BasicHandler)object2).setOption("scope", string11);
                ((SOAPService)object2).getInitializedServiceDesc(messageContext);
                soapServices.put(string10, object2);
            }
            ((SOAPService)object2).setEngine(messageContext.getAxisEngine());
            ((SimpleChain)object2).init();
            messageContext.setService((SOAPService)object2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JWSHandler::invoke");
        }
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        try {
            this.setupService(messageContext);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            throw AxisFault.makeFault(exception);
        }
    }
}

