/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.SessionUtils;
import org.apache.commons.logging.Log;

public class SimpleSessionHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleSessionHandler.class.getName());
    public static final String SESSION_ID = "SimpleSession.id";
    public static final String SESSION_NS = "http://xml.apache.org/axis/session";
    public static final String SESSION_LOCALPART = "sessionID";
    public static final QName sessionHeaderName = new QName("http://xml.apache.org/axis/session", "sessionID");
    private Hashtable activeSessions = new Hashtable();
    private long reapPeriodicity = 30L;
    private long lastReapTime = 0L;
    private int defaultSessionTimeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws AxisFault {
        long l = System.currentTimeMillis();
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (l > this.lastReapTime + this.reapPeriodicity * 1000L) {
                bl = true;
                this.lastReapTime = l;
            }
        }
        if (bl) {
            Object object2;
            Object object3;
            object = this.activeSessions.entrySet();
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object3 = (Map.Entry)iterator.next();
                Object object4 = object3.getKey();
                object2 = (SimpleSession)object3.getValue();
                if (l - ((SimpleSession)object2).getLastAccessTime() <= (long)(((SimpleSession)object2).getTimeout() * 1000)) continue;
                log.debug(Messages.getMessage("timeout00", object4.toString()));
                hashSet.add(object4);
            }
            for (Object object4 : hashSet) {
                object3 = (SimpleSession)this.activeSessions.get(object4);
                this.activeSessions.remove(object4);
                object2 = ((SimpleSession)object3).getKeys();
                while (object2 != null && object2.hasMoreElements()) {
                    String string = (String)object2.nextElement();
                    Object object5 = ((SimpleSession)object3).get(string);
                    if (object5 == null || !(object5 instanceof ServiceLifecycle)) continue;
                    ((ServiceLifecycle)object5).destroy();
                }
            }
        }
        if (messageContext.isClient()) {
            this.doClient(messageContext);
        } else {
            this.doServer(messageContext);
        }
    }

    public void doClient(MessageContext messageContext) throws AxisFault {
        if (messageContext.getPastPivot()) {
            Message message = messageContext.getResponseMessage();
            if (message == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = sOAPEnvelope.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (sOAPHeaderElement == null) {
                return;
            }
            try {
                Long l = (Long)sOAPHeaderElement.getValueAsType(Constants.XSD_LONG);
                AxisEngine axisEngine = messageContext.getAxisEngine();
                axisEngine.setOption(SESSION_ID, l);
                sOAPHeaderElement.setProcessed(true);
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
        } else {
            AxisEngine axisEngine = messageContext.getAxisEngine();
            Long l = (Long)axisEngine.getOption(SESSION_ID);
            if (l == null) {
                return;
            }
            Message message = messageContext.getRequestMessage();
            if (message == null) {
                throw new AxisFault(Messages.getMessage("noRequest00"));
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(SESSION_NS, SESSION_LOCALPART, l);
            sOAPEnvelope.addHeader(sOAPHeaderElement);
        }
    }

    public void doServer(MessageContext messageContext) throws AxisFault {
        if (messageContext.getPastPivot()) {
            Long l = (Long)messageContext.getProperty(SESSION_ID);
            if (l == null) {
                return;
            }
            Message message = messageContext.getResponseMessage();
            if (message == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(SESSION_NS, SESSION_LOCALPART, l);
            sOAPEnvelope.addHeader(sOAPHeaderElement);
        } else {
            Long l;
            Message message = messageContext.getRequestMessage();
            if (message == null) {
                throw new AxisFault(Messages.getMessage("noRequest00"));
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = sOAPEnvelope.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (sOAPHeaderElement != null) {
                try {
                    l = (Long)sOAPHeaderElement.getValueAsType(Constants.XSD_LONG);
                }
                catch (Exception exception) {
                    throw AxisFault.makeFault(exception);
                }
            } else {
                l = this.getNewSession();
            }
            SimpleSession simpleSession = (SimpleSession)this.activeSessions.get(l);
            if (simpleSession == null) {
                l = this.getNewSession();
                simpleSession = (SimpleSession)this.activeSessions.get(l);
            }
            simpleSession.touch();
            messageContext.setSession(simpleSession);
            messageContext.setProperty(SESSION_ID, l);
        }
    }

    private synchronized Long getNewSession() {
        Long l = SessionUtils.generateSession();
        SimpleSession simpleSession = new SimpleSession();
        simpleSession.setTimeout(this.defaultSessionTimeout);
        this.activeSessions.put(l, simpleSession);
        return l;
    }

    public void setReapPeriodicity(long l) {
        this.reapPeriodicity = l;
    }

    public void setDefaultSessionTimeout(int n) {
        this.defaultSessionTimeout = n;
    }
}

