/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPFaultBuilder;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BodyBuilder
extends SOAPHandler {
    protected static Log log = LogFactory.getLog(BodyBuilder.class.getName());
    boolean gotRPCElement = false;
    private SOAPEnvelope envelope;

    BodyBuilder(SOAPEnvelope sOAPEnvelope) {
        this.envelope = sOAPEnvelope;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2003/05/soap-envelope", "encodingStyle") != null) {
            AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Body"), null, null, null);
            throw new SAXException(axisFault);
        }
        if (!deserializationContext.isDoneParsing()) {
            if (!deserializationContext.isProcessingRef()) {
                if (this.myElement == null) {
                    try {
                        this.myElement = new SOAPBody(string, string2, string3, attributes, deserializationContext, this.envelope.getSOAPConstants());
                    }
                    catch (AxisFault axisFault) {
                        throw new SAXException(axisFault);
                    }
                }
                deserializationContext.pushNewElement(this.myElement);
            }
            this.envelope.setBody((SOAPBody)this.myElement);
        }
    }

    public MessageElement makeNewElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws AxisFault {
        return new SOAPBody(string, string2, string3, attributes, deserializationContext, deserializationContext.getSOAPConstants());
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        SOAPBodyElement sOAPBodyElement = null;
        if (log.isDebugEnabled()) {
            log.debug("Enter: BodyBuilder::onStartChild()");
        }
        QName qName = new QName(string, string2);
        SOAPHandler sOAPHandler = null;
        boolean bl = true;
        String string4 = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
        if (string4 != null && string4.equals("0")) {
            bl = false;
        }
        MessageContext messageContext = deserializationContext.getMessageContext();
        OperationDesc[] operationDescArray = null;
        try {
            if (messageContext != null) {
                operationDescArray = messageContext.getPossibleOperationsByQName(qName);
            }
            if (operationDescArray != null && operationDescArray.length == 1) {
                messageContext.setOperation(operationDescArray[0]);
            }
        }
        catch (AxisFault axisFault) {
            throw new SAXException(axisFault);
        }
        Style style = operationDescArray == null ? Style.RPC : operationDescArray[0].getStyle();
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        if (string2.equals("Fault") && string.equals(sOAPConstants.getEnvelopeURI())) {
            try {
                sOAPBodyElement = new SOAPFault(string, string2, string3, attributes, deserializationContext);
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
            sOAPBodyElement.setEnvelope(deserializationContext.getEnvelope());
            sOAPHandler = new SOAPFaultBuilder((SOAPFault)sOAPBodyElement, deserializationContext);
        } else if (!this.gotRPCElement && bl && style != Style.MESSAGE) {
            this.gotRPCElement = true;
            try {
                sOAPBodyElement = new RPCElement(string, string2, string3, attributes, deserializationContext, operationDescArray);
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
            if (!(messageContext == null || messageContext.isHighFidelity() || operationDescArray != null && operationDescArray.length != 1)) {
                ((RPCElement)sOAPBodyElement).setNeedDeser(false);
                boolean bl2 = false;
                if (messageContext.getCurrentMessage() != null && "response".equals(messageContext.getCurrentMessage().getMessageType())) {
                    bl2 = true;
                }
                sOAPHandler = new RPCHandler((RPCElement)sOAPBodyElement, bl2);
                if (operationDescArray != null) {
                    ((RPCHandler)sOAPHandler).setOperation(operationDescArray[0]);
                    messageContext.setOperation(operationDescArray[0]);
                }
            }
        }
        if (sOAPBodyElement == null) {
            if (style == Style.RPC && sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                throw new SAXException(Messages.getMessage("onlyOneBodyFor12"));
            }
            try {
                sOAPBodyElement = new SOAPBodyElement(string, string2, string3, attributes, deserializationContext);
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
            if (sOAPBodyElement.getFixupDeserializer() != null) {
                sOAPHandler = (SOAPHandler)((Object)sOAPBodyElement.getFixupDeserializer());
            }
        }
        if (sOAPHandler == null) {
            sOAPHandler = new SOAPHandler();
        }
        sOAPHandler.myElement = sOAPBodyElement;
        if (log.isDebugEnabled()) {
            log.debug("Exit: BodyBuilder::onStartChild()");
        }
        return sOAPHandler;
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) {
    }
}

