/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.BodyBuilder;
import org.apache.axis.message.HeaderBuilder;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnvelopeBuilder
extends SOAPHandler {
    private SOAPEnvelope envelope;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private boolean gotHeader = false;
    private boolean gotBody = false;

    public EnvelopeBuilder(String string, SOAPConstants sOAPConstants) {
        this.envelope = new SOAPEnvelope(false, sOAPConstants);
        this.envelope.setMessageType(string);
        this.myElement = this.envelope;
    }

    public EnvelopeBuilder(SOAPEnvelope sOAPEnvelope, String string) {
        this.envelope = sOAPEnvelope;
        this.envelope.setMessageType(string);
        this.myElement = this.envelope;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (!string2.equals("Envelope")) {
            throw new SAXException(Messages.getMessage("badTag00", string2));
        }
        MessageContext messageContext = deserializationContext.getMessageContext();
        SOAPConstants sOAPConstants = null;
        if (messageContext != null) {
            sOAPConstants = (SOAPConstants)messageContext.getProperty("SingleSOAPVersion");
        }
        this.soapConstants = string.equals("http://schemas.xmlsoap.org/soap/envelope/") ? SOAPConstants.SOAP11_CONSTANTS : (string.equals("http://www.w3.org/2003/05/soap-envelope") ? SOAPConstants.SOAP12_CONSTANTS : null);
        if (this.soapConstants == null || sOAPConstants != null && this.soapConstants != sOAPConstants) {
            this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
            if (sOAPConstants == null) {
                sOAPConstants = this.soapConstants;
            }
            try {
                AxisFault axisFault = new AxisFault(this.soapConstants.getVerMismatchFaultCodeQName(), null, Messages.getMessage("versionMissmatch00"), null, null, null);
                SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(this.soapConstants.getEnvelopeURI(), "Upgrade");
                MessageElement messageElement = new MessageElement(this.soapConstants.getEnvelopeURI(), "SupportedEnvelope");
                messageElement.addAttribute(null, "qname", new QName(sOAPConstants.getEnvelopeURI(), "Envelope"));
                sOAPHeaderElement.addChildElement(messageElement);
                axisFault.addHeader(sOAPHeaderElement);
                throw new SAXException(axisFault);
            }
            catch (SOAPException sOAPException) {
                throw new SAXException(sOAPException);
            }
        }
        if (deserializationContext.getMessageContext() != null) {
            deserializationContext.getMessageContext().setSOAPConstants(this.soapConstants);
        }
        if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2003/05/soap-envelope", "encodingStyle") != null) {
            AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Envelope"), null, null, null);
            throw new SAXException(axisFault);
        }
        this.envelope.setPrefix(string3);
        this.envelope.setNamespaceURI(string);
        this.envelope.setNSMappings(deserializationContext.getCurrentNSMappings());
        this.envelope.setSoapConstants(this.soapConstants);
        deserializationContext.pushNewElement(this.envelope);
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        QName qName = new QName(string, string2);
        if (qName.equals(this.soapConstants.getHeaderQName())) {
            if (this.gotHeader) {
                throw new SAXException(Messages.getMessage("only1Header00"));
            }
            this.gotHeader = true;
            return new HeaderBuilder(this.envelope);
        }
        if (qName.equals(this.soapConstants.getBodyQName())) {
            if (this.gotBody) {
                throw new SAXException(Messages.getMessage("only1Body00"));
            }
            this.gotBody = true;
            return new BodyBuilder(this.envelope);
        }
        if (!this.gotBody) {
            throw new SAXException(Messages.getMessage("noCustomElems00"));
        }
        if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            throw new SAXException(Messages.getMessage("noElemAfterBody12"));
        }
        try {
            MessageElement messageElement = new MessageElement(string, string2, string3, attributes, deserializationContext);
            if (messageElement.getFixupDeserializer() != null) {
                return (SOAPHandler)((Object)messageElement.getFixupDeserializer());
            }
        }
        catch (AxisFault axisFault) {
            throw new SAXException(axisFault);
        }
        return null;
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) {
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.envelope.setDirty(false);
    }
}

