/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.client.AxisClient;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPEnvelope
extends MessageElement
implements javax.xml.soap.SOAPEnvelope {
    protected static Log log = LogFactory.getLog(SOAPEnvelope.class.getName());
    private SOAPHeader header;
    private SOAPBody body;
    public Vector trailers = new Vector();
    private SOAPConstants soapConstants;
    private SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    public String messageType;

    public SOAPEnvelope() {
        this(true, SOAPConstants.SOAP11_CONSTANTS);
    }

    public SOAPEnvelope(SOAPConstants sOAPConstants) {
        this(true, sOAPConstants);
    }

    public SOAPEnvelope(SOAPConstants sOAPConstants, SchemaVersion schemaVersion) {
        this(true, sOAPConstants, schemaVersion);
    }

    public SOAPEnvelope(boolean bl, SOAPConstants sOAPConstants) {
        this(bl, sOAPConstants, SchemaVersion.SCHEMA_2001);
    }

    public SOAPEnvelope(boolean bl, SOAPConstants sOAPConstants, SchemaVersion schemaVersion) {
        super("Envelope", "soapenv", sOAPConstants != null ? sOAPConstants.getEnvelopeURI() : Constants.DEFAULT_SOAP_VERSION.getEnvelopeURI());
        if (sOAPConstants == null) {
            sOAPConstants = Constants.DEFAULT_SOAP_VERSION;
        }
        this.soapConstants = sOAPConstants;
        this.schemaVersion = schemaVersion;
        this.header = new SOAPHeader(this, sOAPConstants);
        this.body = new SOAPBody(this, sOAPConstants);
        if (bl) {
            if (this.namespaces == null) {
                this.namespaces = new ArrayList();
            }
            this.namespaces.add(new Mapping(sOAPConstants.getEnvelopeURI(), "soapenv"));
            this.namespaces.add(new Mapping(schemaVersion.getXsdURI(), "xsd"));
            this.namespaces.add(new Mapping(schemaVersion.getXsiURI(), "xsi"));
        }
        this.setDirty(true);
    }

    public SOAPEnvelope(InputStream inputStream) throws SAXException {
        InputSource inputSource = new InputSource(inputStream);
        this.header = new SOAPHeader(this, Constants.DEFAULT_SOAP_VERSION);
        DeserializationContext deserializationContext = null;
        AxisClient axisClient = new AxisClient(new NullProvider());
        MessageContext messageContext = new MessageContext(axisClient);
        deserializationContext = new DeserializationContext(inputSource, messageContext, "request", this);
        deserializationContext.parse();
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public Vector getBodyElements() throws AxisFault {
        if (this.body != null) {
            return this.body.getBodyElements();
        }
        return new Vector();
    }

    public Vector getTrailers() {
        return this.trailers;
    }

    public SOAPBodyElement getFirstBody() throws AxisFault {
        if (this.body == null) {
            return null;
        }
        return this.body.getFirstBody();
    }

    public Vector getHeaders() throws AxisFault {
        if (this.header != null) {
            return this.header.getHeaders();
        }
        return new Vector();
    }

    public Vector getHeadersByActor(ArrayList arrayList) {
        if (this.header != null) {
            return this.header.getHeadersByActor(arrayList);
        }
        return new Vector();
    }

    public void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.header == null) {
            this.header = new SOAPHeader(this, this.soapConstants);
        }
        sOAPHeaderElement.setEnvelope(this);
        this.header.addHeader(sOAPHeaderElement);
        this._isDirty = true;
    }

    public void addBodyElement(SOAPBodyElement sOAPBodyElement) {
        if (this.body == null) {
            this.body = new SOAPBody(this, this.soapConstants);
        }
        sOAPBodyElement.setEnvelope(this);
        this.body.addBodyElement(sOAPBodyElement);
        this._isDirty = true;
    }

    public void removeHeaders() {
        if (this.header != null) {
            this.removeChild(this.header);
        }
        this.header = null;
    }

    public void setHeader(SOAPHeader sOAPHeader) {
        if (this.header != null) {
            this.removeChild(this.header);
        }
        this.header = sOAPHeader;
        try {
            this.header.setParentElement(this);
        }
        catch (SOAPException sOAPException) {
            log.fatal(Messages.getMessage("exception00"), sOAPException);
        }
    }

    public void removeHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.header != null) {
            this.header.removeHeader(sOAPHeaderElement);
            this._isDirty = true;
        }
    }

    public void removeBody() {
        if (this.body != null) {
            this.removeChild(this.body);
        }
        this.body = null;
    }

    public void setBody(SOAPBody sOAPBody) {
        if (this.body != null) {
            this.removeChild(this.body);
        }
        this.body = sOAPBody;
        try {
            sOAPBody.setParentElement(this);
        }
        catch (SOAPException sOAPException) {
            log.fatal(Messages.getMessage("exception00"), sOAPException);
        }
    }

    public void removeBodyElement(SOAPBodyElement sOAPBodyElement) {
        if (this.body != null) {
            this.body.removeBodyElement(sOAPBodyElement);
            this._isDirty = true;
        }
    }

    public void removeTrailer(MessageElement messageElement) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("removeTrailer00"));
        }
        this.trailers.removeElement(messageElement);
        this._isDirty = true;
    }

    public void clearBody() {
        if (this.body != null) {
            this.body.clearBody();
            this._isDirty = true;
        }
    }

    public void addTrailer(MessageElement messageElement) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("removeTrailer00"));
        }
        messageElement.setEnvelope(this);
        this.trailers.addElement(messageElement);
        this._isDirty = true;
    }

    public SOAPHeaderElement getHeaderByName(String string, String string2) throws AxisFault {
        return this.getHeaderByName(string, string2, false);
    }

    public SOAPHeaderElement getHeaderByName(String string, String string2, boolean bl) throws AxisFault {
        if (this.header != null) {
            return this.header.getHeaderByName(string, string2, bl);
        }
        return null;
    }

    public SOAPBodyElement getBodyByName(String string, String string2) throws AxisFault {
        if (this.body == null) {
            return null;
        }
        return this.body.getBodyByName(string, string2);
    }

    public Enumeration getHeadersByName(String string, String string2) throws AxisFault {
        return this.getHeadersByName(string, string2, false);
    }

    public Enumeration getHeadersByName(String string, String string2, boolean bl) throws AxisFault {
        if (this.header != null) {
            return this.header.getHeadersByName(string, string2, bl);
        }
        return new Vector().elements();
    }

    public void outputImpl(SerializationContext serializationContext) throws Exception {
        NodeImpl nodeImpl;
        Object object2;
        boolean bl = serializationContext.getPretty();
        serializationContext.setPretty(true);
        if (this.namespaces != null) {
            for (Object object2 : this.namespaces) {
                serializationContext.registerPrefixForURI(((Mapping)object2).getPrefix(), ((Mapping)object2).getNamespaceURI());
            }
        }
        serializationContext.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Envelope"), this.attributes);
        object2 = this.getChildElements();
        while (object2.hasNext()) {
            nodeImpl = (NodeImpl)object2.next();
            if (nodeImpl instanceof SOAPHeader) {
                this.header.outputImpl(serializationContext);
                continue;
            }
            if (nodeImpl instanceof SOAPBody) {
                this.body.outputImpl(serializationContext);
                continue;
            }
            if (nodeImpl instanceof MessageElement) {
                ((MessageElement)nodeImpl).output(serializationContext);
                continue;
            }
            nodeImpl.output(serializationContext);
        }
        Enumeration enumeration = this.trailers.elements();
        while (enumeration.hasMoreElements()) {
            nodeImpl = (MessageElement)enumeration.nextElement();
            ((MessageElement)nodeImpl).output(serializationContext);
        }
        serializationContext.endElement();
        serializationContext.setPretty(bl);
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSoapConstants(SOAPConstants sOAPConstants) {
        this.soapConstants = sOAPConstants;
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public javax.xml.soap.SOAPBody addBody() throws SOAPException {
        if (this.body == null) {
            this.body = new SOAPBody(this, this.soapConstants);
            this._isDirty = true;
            this.body.setOwnerDocument(this.getOwnerDocument());
            return this.body;
        }
        throw new SOAPException(Messages.getMessage("bodyPresent"));
    }

    public javax.xml.soap.SOAPHeader addHeader() throws SOAPException {
        if (this.header == null) {
            this.header = new SOAPHeader(this, this.soapConstants);
            this.header.setOwnerDocument(this.getOwnerDocument());
            return this.header;
        }
        throw new SOAPException(Messages.getMessage("headerPresent"));
    }

    public Name createName(String string) throws SOAPException {
        return new PrefixedQName(null, string, null);
    }

    public Name createName(String string, String string2, String string3) throws SOAPException {
        return new PrefixedQName(string3, string, string2);
    }

    public javax.xml.soap.SOAPBody getBody() throws SOAPException {
        return this.body;
    }

    public javax.xml.soap.SOAPHeader getHeader() throws SOAPException {
        return this.header;
    }

    public void setSAAJEncodingCompliance(boolean bl) {
        this.body.setSAAJEncodingCompliance(bl);
    }

    public Node removeChild(Node node) throws DOMException {
        if (node == this.header) {
            this.header = null;
        } else if (node == this.body) {
            this.body = null;
        }
        return super.removeChild(node);
    }

    public Node cloneNode(boolean bl) {
        SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)super.cloneNode(bl);
        if (!bl) {
            sOAPEnvelope.body = null;
            sOAPEnvelope.header = null;
        }
        return sOAPEnvelope;
    }

    protected void childDeepCloned(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
        if (nodeImpl == this.body) {
            this.body = (SOAPBody)nodeImpl2;
            try {
                this.body.setParentElement(this);
            }
            catch (SOAPException sOAPException) {
                log.fatal(Messages.getMessage("exception00"), sOAPException);
            }
        } else if (nodeImpl == this.header) {
            this.header = (SOAPHeader)nodeImpl2;
        }
    }

    public void setOwnerDocument(SOAPPart sOAPPart) {
        super.setOwnerDocument(sOAPPart);
        if (this.body != null) {
            this.body.setOwnerDocument(sOAPPart);
            this.setOwnerDocumentForChildren(this.body.children, sOAPPart);
        }
        if (this.header != null) {
            this.header.setOwnerDocument(sOAPPart);
            this.setOwnerDocumentForChildren(this.body.children, sOAPPart);
        }
    }

    private void setOwnerDocumentForChildren(List list, SOAPPart sOAPPart) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            NodeImpl nodeImpl = (NodeImpl)list.get(i);
            nodeImpl.setOwnerDocument(sOAPPart);
            this.setOwnerDocumentForChildren(nodeImpl.children, sOAPPart);
        }
    }
}

