/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.Callback;
import org.apache.axis.encoding.CallbackTarget;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPFaultCodeBuilder;
import org.apache.axis.message.SOAPFaultDetailsBuilder;
import org.apache.axis.message.SOAPFaultReasonBuilder;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultBuilder
extends SOAPHandler
implements Callback {
    boolean waiting = false;
    boolean passedEnd = false;
    protected SOAPFault element;
    protected DeserializationContext context;
    static HashMap fields_soap11 = new HashMap();
    static HashMap fields_soap12 = new HashMap();
    protected QName faultCode = null;
    protected QName[] faultSubCode = null;
    protected String faultString = null;
    protected String faultActor = null;
    protected Element[] faultDetails;
    protected String faultNode = null;
    protected SOAPFaultCodeBuilder code;
    protected Class faultClass = null;
    protected Object faultData = null;
    private static HashMap TYPES;

    public SOAPFaultBuilder(SOAPFault sOAPFault, DeserializationContext deserializationContext) {
        this.element = sOAPFault;
        this.context = deserializationContext;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2003/05/soap-envelope", "encodingStyle") != null) {
            AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Fault"), null, null, null);
            throw new SAXException(axisFault);
        }
        super.startElement(string, string2, string3, attributes, deserializationContext);
    }

    void setFaultData(Object object) {
        this.faultData = object;
        if (this.waiting && this.passedEnd) {
            this.createFault();
        }
        this.waiting = false;
    }

    public void setFaultClass(Class clazz) {
        this.faultClass = clazz;
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        super.endElement(string, string2, deserializationContext);
        if (!this.waiting) {
            this.createFault();
        } else {
            this.passedEnd = true;
        }
    }

    void setWaiting(boolean bl) {
        this.waiting = bl;
    }

    private void createFault() {
        Object object;
        Object object2;
        SOAP11Constants sOAP11Constants;
        AxisFault axisFault = null;
        SOAPConstants sOAPConstants = sOAP11Constants = this.context.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : this.context.getMessageContext().getSOAPConstants();
        if (this.faultClass != null) {
            try {
                if (this.faultData != null) {
                    if (this.faultData instanceof AxisFault) {
                        axisFault = (AxisFault)this.faultData;
                    } else {
                        object2 = this.ConvertWrapper(this.faultData.getClass());
                        try {
                            object = this.faultClass.getConstructor(new Class[]{object2});
                            axisFault = (AxisFault)((Constructor)object).newInstance(this.faultData);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (axisFault == null && this.faultData instanceof Exception) {
                            axisFault = AxisFault.makeFault((Exception)this.faultData);
                        }
                    }
                }
                if (AxisFault.class.isAssignableFrom(this.faultClass)) {
                    if (axisFault == null) {
                        axisFault = (AxisFault)this.faultClass.newInstance();
                    }
                    if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                        axisFault.setFaultCode(this.code.getFaultCode());
                        object2 = this.code;
                        while ((object2 = ((SOAPFaultCodeBuilder)object2).getNext()) != null) {
                            axisFault.addFaultSubCode(((SOAPFaultCodeBuilder)object2).getFaultCode());
                        }
                    } else {
                        axisFault.setFaultCode(this.faultCode);
                    }
                    axisFault.setFaultString(this.faultString);
                    axisFault.setFaultActor(this.faultActor);
                    axisFault.setFaultNode(this.faultNode);
                    axisFault.setFaultDetail(this.faultDetails);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (axisFault == null) {
            if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                this.faultCode = this.code.getFaultCode();
                if (this.code.getNext() != null) {
                    object2 = new Vector();
                    object = this.code;
                    while ((object = ((SOAPFaultCodeBuilder)object).getNext()) != null) {
                        ((Vector)object2).add(((SOAPFaultCodeBuilder)object).getFaultCode());
                    }
                    this.faultSubCode = ((Vector)object2).toArray(new QName[((Vector)object2).size()]);
                }
            }
            axisFault = new AxisFault(this.faultCode, this.faultSubCode, this.faultString, this.faultActor, this.faultNode, this.faultDetails);
            try {
                object2 = this.element.getEnvelope().getHeaders();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)((Vector)object2).elementAt(i);
                    axisFault.addHeader(sOAPHeaderElement);
                }
            }
            catch (AxisFault axisFault2) {
                // empty catch block
            }
        }
        this.element.setFault(axisFault);
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        Serializable serializable;
        SOAPHandler sOAPHandler = null;
        SOAP11Constants sOAP11Constants = deserializationContext.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : deserializationContext.getMessageContext().getSOAPConstants();
        QName qName = null;
        if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
            qName = (QName)fields_soap12.get(string2);
            if (qName == null) {
                serializable = new QName(string, string2);
                if (((QName)serializable).equals(Constants.QNAME_FAULTCODE_SOAP12)) {
                    this.code = new SOAPFaultCodeBuilder();
                    return this.code;
                }
                if (((QName)serializable).equals(Constants.QNAME_FAULTREASON_SOAP12)) {
                    return new SOAPFaultReasonBuilder(this);
                }
                if (((QName)serializable).equals(Constants.QNAME_FAULTDETAIL_SOAP12)) {
                    return new SOAPFaultDetailsBuilder(this);
                }
            }
        } else {
            qName = (QName)fields_soap11.get(string2);
            if (qName == null && string2.equals("detail")) {
                return new SOAPFaultDetailsBuilder(this);
            }
        }
        if (qName != null) {
            serializable = deserializationContext.getDeserializerForType(qName);
            if (serializable != null) {
                serializable.registerValueTarget(new CallbackTarget(this, new QName(string, string2)));
            }
            sOAPHandler = (SOAPHandler)((Object)serializable);
        }
        return sOAPHandler;
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        MessageElement messageElement;
        List list;
        if ("detail".equals(string2) && (list = (messageElement = deserializationContext.getCurElement()).getChildren()) != null) {
            Element[] elementArray = new Element[list.size()];
            for (int i = 0; i < elementArray.length; ++i) {
                try {
                    elementArray[i] = ((MessageElement)list.get(i)).getAsDOM();
                    continue;
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
            this.faultDetails = elementArray;
        }
    }

    public void setValue(Object object, Object object2) {
        String string = ((QName)object2).getLocalPart();
        if (((QName)object2).getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            if (string.equals("Role")) {
                this.faultActor = (String)object;
            } else if (string.equals("Text")) {
                this.faultString = (String)object;
            } else if (string.equals("Node")) {
                this.faultNode = (String)object;
            }
        } else if (string.equals("faultcode")) {
            this.faultCode = (QName)object;
        } else if (string.equals("faultstring")) {
            this.faultString = (String)object;
        } else if (string.equals("faultactor")) {
            this.faultActor = (String)object;
        }
    }

    private Class ConvertWrapper(Class clazz) {
        Class clazz2 = (Class)TYPES.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        return clazz;
    }

    static {
        fields_soap11.put("faultcode", Constants.XSD_QNAME);
        fields_soap11.put("faultstring", Constants.XSD_STRING);
        fields_soap11.put("faultactor", Constants.XSD_STRING);
        fields_soap11.put("detail", null);
        fields_soap12.put("Reason", null);
        fields_soap12.put("Role", Constants.XSD_STRING);
        fields_soap12.put("Node", Constants.XSD_STRING);
        fields_soap12.put("Detail", null);
        TYPES = new HashMap(7);
        TYPES.put(Integer.class, Integer.TYPE);
        TYPES.put(Float.class, Float.TYPE);
        TYPES.put(Boolean.class, Boolean.TYPE);
        TYPES.put(Double.class, Double.TYPE);
        TYPES.put(Byte.class, Byte.TYPE);
        TYPES.put(Short.class, Short.TYPE);
        TYPES.put(Long.class, Long.TYPE);
    }
}

