/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.Callback;
import org.apache.axis.encoding.CallbackTarget;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.SOAPFaultBuilder;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultDetailsBuilder
extends SOAPHandler
implements Callback {
    protected SOAPFaultBuilder builder;

    public SOAPFaultDetailsBuilder(SOAPFaultBuilder sOAPFaultBuilder) {
        this.builder = sOAPFaultBuilder;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2003/05/soap-envelope", "encodingStyle") != null) {
            AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Detail"), null, null, null);
            throw new SAXException(axisFault);
        }
        super.startElement(string, string2, string3, attributes, deserializationContext);
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        Serializable serializable;
        QName qName = new QName(string, string2);
        if (string2.equals("exceptionName")) {
            Deserializer deserializer = deserializationContext.getDeserializerForType(Constants.XSD_STRING);
            deserializer.registerValueTarget(new CallbackTarget(this, "exceptionName"));
            return (SOAPHandler)((Object)deserializer);
        }
        MessageContext messageContext = deserializationContext.getMessageContext();
        SOAPConstants sOAPConstants = Constants.DEFAULT_SOAP_VERSION;
        OperationDesc operationDesc = null;
        if (messageContext != null) {
            sOAPConstants = messageContext.getSOAPConstants();
            operationDesc = messageContext.getOperation();
        }
        Class clazz = null;
        QName qName2 = null;
        if (operationDesc != null) {
            serializable = null;
            qName2 = deserializationContext.getTypeFromAttributes(string, string2, attributes);
            if (qName2 != null) {
                serializable = operationDesc.getFaultByXmlType(qName2);
            }
            if (serializable == null) {
                serializable = operationDesc.getFaultByQName(qName);
                if (qName2 == null && serializable != null) {
                    qName2 = ((FaultDesc)serializable).getXmlType();
                }
            }
            if (serializable == null && operationDesc.getFaults() != null) {
                for (FaultDesc faultDesc : operationDesc.getFaults()) {
                    if (!faultDesc.getClassName().equals(string2)) continue;
                    serializable = faultDesc;
                    qName2 = faultDesc.getXmlType();
                    break;
                }
            }
            if (serializable != null) {
                try {
                    clazz = ClassUtils.forName(((FaultDesc)serializable).getClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            qName2 = deserializationContext.getTypeFromAttributes(string, string2, attributes);
        }
        if (clazz == null) {
            clazz = deserializationContext.getTypeMapping().getClassForQName(qName2);
        }
        if (clazz != null && qName2 != null) {
            this.builder.setFaultClass(clazz);
            this.builder.setWaiting(true);
            serializable = null;
            if (attributes.getValue(sOAPConstants.getAttrHref()) == null) {
                serializable = deserializationContext.getDeserializerForType(qName2);
            } else {
                serializable = new DeserializerImpl();
                serializable.setDefaultType(qName2);
            }
            if (serializable != null) {
                serializable.registerValueTarget(new CallbackTarget(this, "faultData"));
            }
            return (SOAPHandler)((Object)serializable);
        }
        return null;
    }

    public void setValue(Object object, Object object2) {
        if ("faultData".equals(object2)) {
            this.builder.setFaultData(object);
        } else if ("exceptionName".equals(object2)) {
            String string = (String)object;
            try {
                Class clazz = ClassUtils.forName(string);
                this.builder.setFaultClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

