/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.management.ServiceAdmin;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.AxisServletBase;
import org.apache.axis.transport.http.FilterPrintWriter;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class AxisServlet
extends AxisServletBase {
    protected static Log log = LogFactory.getLog(AxisServlet.class.getName());
    private static Log tlog = LogFactory.getLog("org.apache.axis.TIME");
    private static Log exceptionLog = LogFactory.getLog("org.apache.axis.EXCEPTIONS");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "axis.jws.servletClassDir";
    public static final String INIT_PROPERTY_DISABLE_SERVICES_LIST = "axis.disableServiceList";
    public static final String INIT_PROPERTY_SERVICES_PATH = "axis.servicesPath";
    private String transportName;
    private Handler transport;
    private ServletSecurityProvider securityProvider = null;
    private String servicesPath;
    private static boolean isDebug = false;
    private boolean enableList = false;
    private boolean disableServicesList = false;
    private String jwsClassDir = null;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletConfig().getServletContext();
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug("In servlet init");
        }
        this.transportName = this.getOption(servletContext, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(servletContext, INIT_PROPERTY_JWS_CLASS_DIR, null);
        this.disableServicesList = JavaUtils.isTrue(this.getOption(servletContext, INIT_PROPERTY_DISABLE_SERVICES_LIST, "false"));
        this.servicesPath = this.getOption(servletContext, INIT_PROPERTY_SERVICES_PATH, "/services/");
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
        this.initQueryStringHandlers();
        try {
            ServiceAdmin.setEngine(this.getEngine(), servletContext.getServerInfo());
        }
        catch (AxisFault axisFault) {
            exceptionLog.info("Exception setting AxisEngine on ServiceAdmin " + axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (isDebug) {
            log.debug("Enter: doGet()");
        }
        FilterPrintWriter filterPrintWriter = new FilterPrintWriter(httpServletResponse);
        try {
            boolean bl;
            boolean bl2;
            AxisServer axisServer = this.getEngine();
            ServletContext servletContext = this.getServletConfig().getServletContext();
            String string = httpServletRequest.getPathInfo();
            String string2 = servletContext.getRealPath(httpServletRequest.getServletPath());
            if (string2 == null) {
                string2 = httpServletRequest.getServletPath();
            }
            if (bl2 = httpServletRequest.getRequestURI().endsWith(".jws")) {
                string = httpServletRequest.getServletPath();
            }
            if (this.processQuery(httpServletRequest, httpServletResponse, filterPrintWriter)) {
                return;
            }
            boolean bl3 = bl = string == null || string.equals("");
            if (!this.disableServicesList) {
                if (bl) {
                    this.reportAvailableServices(httpServletResponse, filterPrintWriter, httpServletRequest);
                } else if (string2 != null) {
                    MessageContext messageContext = this.createMessageContext(axisServer, httpServletRequest, httpServletResponse);
                    String string3 = HttpUtils.getRequestURL(httpServletRequest).toString();
                    messageContext.setProperty("transport.url", string3);
                    String string4 = string.startsWith("/") ? string.substring(1) : string;
                    SOAPService sOAPService = axisServer.getService(string4);
                    if (sOAPService == null) {
                        if (bl2) {
                            this.reportCantGetJWSService(httpServletRequest, httpServletResponse, filterPrintWriter);
                        } else {
                            this.reportCantGetAxisService(httpServletRequest, httpServletResponse, filterPrintWriter);
                        }
                    } else {
                        this.reportServiceInfo(httpServletResponse, filterPrintWriter, sOAPService, string4);
                    }
                }
            } else {
                httpServletResponse.setContentType("text/html; charset=utf-8");
                ((PrintWriter)filterPrintWriter).println("<html><h1>Axis HTTP Servlet</h1>");
                ((PrintWriter)filterPrintWriter).println(Messages.getMessage("reachedServlet00"));
                ((PrintWriter)filterPrintWriter).println("<p>" + Messages.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                ((PrintWriter)filterPrintWriter).println("</html>");
            }
        }
        catch (AxisFault axisFault) {
            this.reportTroubleInGet(axisFault, httpServletResponse, filterPrintWriter);
        }
        catch (Exception exception) {
            this.reportTroubleInGet(exception, httpServletResponse, filterPrintWriter);
        }
        finally {
            ((PrintWriter)filterPrintWriter).close();
            if (isDebug) {
                log.debug("Exit: doGet()");
            }
        }
    }

    private void reportTroubleInGet(Throwable throwable, HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setContentType("text/html; charset=utf-8");
        httpServletResponse.setStatus(500);
        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        printWriter.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
        if (throwable instanceof AxisFault) {
            AxisFault axisFault = (AxisFault)throwable;
            this.processAxisFault(axisFault);
            this.writeFault(printWriter, axisFault);
        } else {
            this.logException(throwable);
            printWriter.println("<pre>Exception - " + throwable + "<br>");
            if (this.isDevelopment()) {
                printWriter.println(JavaUtils.stackToString(throwable));
            }
            printWriter.println("</pre>");
        }
    }

    protected void processAxisFault(AxisFault axisFault) {
        Element element = axisFault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (element != null) {
            exceptionLog.info(Messages.getMessage("axisFault00"), axisFault);
            axisFault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (exceptionLog.isDebugEnabled()) {
            exceptionLog.debug(Messages.getMessage("axisFault00"), axisFault);
        }
        if (!this.isDevelopment()) {
            axisFault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    protected void logException(Throwable throwable) {
        exceptionLog.info(Messages.getMessage("exception00"), throwable);
    }

    private void writeFault(PrintWriter printWriter, AxisFault axisFault) {
        String string = XMLUtils.xmlEncodeString(axisFault.getLocalizedMessage());
        printWriter.println("<pre>Fault - " + string + "<br>");
        printWriter.println(axisFault.dumpToString());
        printWriter.println("</pre>");
    }

    protected void reportServiceInfo(HttpServletResponse httpServletResponse, PrintWriter printWriter, SOAPService sOAPService, String string) {
        httpServletResponse.setContentType("text/html; charset=utf-8");
        printWriter.println("<h1>" + sOAPService.getName() + "</h1>");
        printWriter.println("<p>" + Messages.getMessage("axisService00") + "</p>");
        printWriter.println("<i>" + Messages.getMessage("perhaps00") + "</i>");
    }

    protected void reportNoWSDL(HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, AxisFault axisFault) {
    }

    protected void reportAvailableServices(HttpServletResponse httpServletResponse, PrintWriter printWriter, HttpServletRequest httpServletRequest) throws ConfigurationException, AxisFault {
        Iterator iterator;
        AxisServer axisServer = this.getEngine();
        httpServletResponse.setContentType("text/html; charset=utf-8");
        printWriter.println("<h2>And now... Some Services</h2>");
        try {
            iterator = axisServer.getConfig().getDeployedServices();
        }
        catch (ConfigurationException configurationException) {
            if (configurationException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configurationException.getContainedException();
            }
            throw configurationException;
        }
        String string = this.getWebappBase(httpServletRequest) + this.servicesPath;
        printWriter.println("<ul>");
        while (iterator.hasNext()) {
            ServiceDesc serviceDesc = (ServiceDesc)iterator.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<li>");
            String string2 = serviceDesc.getName();
            stringBuffer.append(string2);
            stringBuffer.append(" <a href=\"");
            String string3 = serviceDesc.getEndpointURL();
            String string4 = string3 == null ? string : string3;
            stringBuffer.append(string4);
            stringBuffer.append(string2);
            stringBuffer.append("?wsdl\"><i>(wsdl)</i></a></li>");
            printWriter.println(stringBuffer.toString());
            ArrayList arrayList = serviceDesc.getOperations();
            if (arrayList.isEmpty()) continue;
            printWriter.println("<ul>");
            for (OperationDesc operationDesc : arrayList) {
                printWriter.println("<li>" + operationDesc.getName());
            }
            printWriter.println("</ul>");
        }
        printWriter.println("</ul>");
    }

    protected void reportCantGetAxisService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html; charset=utf-8");
        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        printWriter.println("<p>" + Messages.getMessage("noService06") + "</p>");
    }

    protected void reportCantGetJWSService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        String string = httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "");
        String string2 = this.getServletConfig().getServletContext().getRealPath(string);
        log.debug("JWS real path: " + string2);
        boolean bl = new File(string2).exists() && string2.endsWith(".jws");
        httpServletResponse.setContentType("text/html; charset=utf-8");
        if (bl) {
            httpServletResponse.setStatus(200);
            printWriter.println(Messages.getMessage("foundJWS00") + "<p>");
            String string3 = httpServletRequest.getRequestURI();
            String string4 = Messages.getMessage("foundJWS01");
            printWriter.println("<a href='" + string3 + "?wsdl'>" + string4 + "</a>");
        } else {
            httpServletResponse.setStatus(404);
            printWriter.println(Messages.getMessage("noService06"));
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Message message;
        MessageContext messageContext;
        String string2;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        block32: {
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
            l = 0L;
            string2 = null;
            messageContext = null;
            if (isDebug) {
                log.debug("Enter: doPost()");
            }
            if (tlog.isDebugEnabled()) {
                l5 = System.currentTimeMillis();
            }
            message = null;
            string = null;
            try {
                String string3;
                object3 = this.getEngine();
                if (object3 == null) {
                    ServletException servletException = new ServletException(Messages.getMessage("noEngine00"));
                    log.debug("No Engine!", servletException);
                    throw servletException;
                }
                httpServletResponse.setBufferSize(8192);
                messageContext = this.createMessageContext((AxisEngine)object3, httpServletRequest, httpServletResponse);
                if (this.securityProvider != null) {
                    if (isDebug) {
                        log.debug("securityProvider:" + this.securityProvider);
                    }
                    messageContext.setProperty("securityProvider", this.securityProvider);
                }
                object2 = new Message(httpServletRequest.getInputStream(), false, httpServletRequest.getHeader("Content-Type"), httpServletRequest.getHeader("Content-Location"));
                object = ((Message)object2).getMimeHeaders();
                Object object4 = httpServletRequest.getHeaderNames();
                while (object4.hasMoreElements()) {
                    string3 = (String)object4.nextElement();
                    Enumeration enumeration = httpServletRequest.getHeaders(string3);
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        ((MimeHeaders)object).addHeader(string3, string4);
                    }
                }
                if (isDebug) {
                    log.debug("Request Message:" + object2);
                }
                messageContext.setRequestMessage((Message)object2);
                object4 = HttpUtils.getRequestURL(httpServletRequest).toString();
                messageContext.setProperty("transport.url", object4);
                try {
                    string3 = (String)((Message)object2).getProperty("javax.xml.soap.character-set-encoding");
                    if (string3 != null) {
                        messageContext.setProperty("javax.xml.soap.character-set-encoding", string3);
                    }
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                try {
                    string2 = this.getSoapAction(httpServletRequest);
                    if (string2 != null) {
                        messageContext.setUseSOAPAction(true);
                        messageContext.setSOAPActionURI(string2);
                    }
                    messageContext.setSession(new AxisHttpSession(httpServletRequest));
                    if (tlog.isDebugEnabled()) {
                        l4 = System.currentTimeMillis();
                    }
                    if (isDebug) {
                        log.debug("Invoking Axis Engine.");
                    }
                    object3.invoke(messageContext);
                    if (isDebug) {
                        log.debug("Return from Axis Engine.");
                    }
                    if (tlog.isDebugEnabled()) {
                        l3 = System.currentTimeMillis();
                    }
                    message = messageContext.getResponseMessage();
                }
                catch (AxisFault axisFault) {
                    this.processAxisFault(axisFault);
                    this.configureResponseFromAxisFault(httpServletResponse, axisFault);
                    message = messageContext.getResponseMessage();
                    if (message == null) {
                        message = new Message(axisFault);
                        ((SOAPPart)message.getSOAPPart()).getMessage().setMessageContext(messageContext);
                    }
                }
                catch (Exception exception) {
                    message = messageContext.getResponseMessage();
                    httpServletResponse.setStatus(500);
                    message = this.convertExceptionToAxisFault(exception, message);
                    ((SOAPPart)message.getSOAPPart()).getMessage().setMessageContext(messageContext);
                }
                catch (Throwable throwable) {
                    this.logException(throwable);
                    message = messageContext.getResponseMessage();
                    httpServletResponse.setStatus(500);
                    message = new Message(new AxisFault(throwable.toString(), throwable));
                    ((SOAPPart)message.getSOAPPart()).getMessage().setMessageContext(messageContext);
                }
            }
            catch (AxisFault axisFault) {
                this.processAxisFault(axisFault);
                this.configureResponseFromAxisFault(httpServletResponse, axisFault);
                message = messageContext.getResponseMessage();
                if (message != null) break block32;
                message = new Message(axisFault);
                ((SOAPPart)message.getSOAPPart()).getMessage().setMessageContext(messageContext);
            }
        }
        if (tlog.isDebugEnabled()) {
            l2 = System.currentTimeMillis();
        }
        if (message != null) {
            object3 = message.getMimeHeaders();
            object2 = ((MimeHeaders)object3).getAllHeaders();
            while (object2.hasNext()) {
                object = (MimeHeader)object2.next();
                httpServletResponse.addHeader(((MimeHeader)object).getName(), ((MimeHeader)object).getValue());
            }
            object2 = (String)messageContext.getProperty("javax.xml.soap.character-set-encoding");
            if (object2 != null) {
                try {
                    message.setProperty("javax.xml.soap.character-set-encoding", object2);
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
            }
            string = message.getContentType(messageContext.getSOAPConstants());
            this.sendResponse(string, httpServletResponse, message);
        } else {
            httpServletResponse.setStatus(202);
        }
        if (isDebug) {
            log.debug("Response sent.");
            log.debug("Exit: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            l = System.currentTimeMillis();
            tlog.debug("axisServlet.doPost: " + string2 + " pre=" + (l4 - l5) + " invoke=" + (l3 - l4) + " post=" + (l2 - l3) + " send=" + (l - l2) + " " + messageContext.getTargetService() + "." + (messageContext.getOperation() == null ? "" : messageContext.getOperation().getName()));
        }
    }

    private void configureResponseFromAxisFault(HttpServletResponse httpServletResponse, AxisFault axisFault) {
        int n = this.getHttpServletResponseStatus(axisFault);
        if (n == 401) {
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        httpServletResponse.setStatus(n);
    }

    private Message convertExceptionToAxisFault(Exception exception, Message message) {
        this.logException(exception);
        if (message == null) {
            AxisFault axisFault = AxisFault.makeFault(exception);
            this.processAxisFault(axisFault);
            message = new Message(axisFault);
        }
        return message;
    }

    protected int getHttpServletResponseStatus(AxisFault axisFault) {
        return axisFault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String string, HttpServletResponse httpServletResponse, Message message) throws AxisFault, IOException {
        if (message == null) {
            httpServletResponse.setStatus(204);
            if (isDebug) {
                log.debug("NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug("Returned Content-Type:" + string);
            }
            try {
                httpServletResponse.setContentType(string);
                message.writeTo(httpServletResponse.getOutputStream());
            }
            catch (SOAPException sOAPException) {
                this.logException(sOAPException);
            }
        }
        if (!httpServletResponse.isCommitted()) {
            httpServletResponse.flushBuffer();
        }
    }

    private MessageContext createMessageContext(AxisEngine axisEngine, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        MessageContext messageContext = new MessageContext(axisEngine);
        String string = AxisServlet.getRequestPath(httpServletRequest);
        if (isDebug) {
            log.debug("MessageContext:" + messageContext);
            log.debug("HEADER_CONTENT_TYPE:" + httpServletRequest.getHeader("Content-Type"));
            log.debug("HEADER_CONTENT_LOCATION:" + httpServletRequest.getHeader("Content-Location"));
            log.debug("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir()));
            log.debug("Constants.MC_RELATIVE_PATH:" + string);
            log.debug("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath()));
            log.debug("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + httpServletRequest.getPathInfo());
            log.debug("HTTPConstants.HEADER_AUTHORIZATION:" + httpServletRequest.getHeader("Authorization"));
            log.debug("Constants.MC_REMOTE_ADDR:" + httpServletRequest.getRemoteAddr());
            log.debug("configPath:" + String.valueOf(this.getWebInfPath()));
        }
        messageContext.setTransportName(this.transportName);
        messageContext.setProperty("jws.classDir", this.jwsClassDir);
        messageContext.setProperty("home.dir", this.getHomeDir());
        messageContext.setProperty("path", string);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, this);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.getWebInfPath());
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, httpServletRequest.getPathInfo());
        messageContext.setProperty("Authorization", httpServletRequest.getHeader("Authorization"));
        messageContext.setProperty("remoteaddr", httpServletRequest.getRemoteAddr());
        ServletEndpointContextImpl servletEndpointContextImpl = new ServletEndpointContextImpl();
        messageContext.setProperty("servletEndpointContext", servletEndpointContextImpl);
        String string2 = this.getServletConfig().getServletContext().getRealPath(string);
        if (string2 != null) {
            messageContext.setProperty("realpath", string2);
        }
        messageContext.setProperty("configPath", this.getWebInfPath());
        return messageContext;
    }

    private String getSoapAction(HttpServletRequest httpServletRequest) throws AxisFault {
        String string = httpServletRequest.getHeader("SOAPAction");
        if (isDebug) {
            log.debug("HEADER_SOAP_ACTION:" + string);
        }
        if (string == null) {
            AxisFault axisFault = new AxisFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            exceptionLog.error(Messages.getMessage("genFault00"), axisFault);
            throw axisFault;
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            int n = string.length() - 1;
            string = string.substring(1, n);
        }
        if (string.length() == 0) {
            string = httpServletRequest.getContextPath();
        }
        return string;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    public void initQueryStringHandlers() {
        try {
            this.transport = this.getEngine().getTransport(this.transportName);
            if (this.transport == null) {
                this.transport = new SimpleTargetedChain();
                this.transport.setOption("qs.list", "org.apache.axis.transport.http.QSListHandler");
                this.transport.setOption("qs.method", "org.apache.axis.transport.http.QSMethodHandler");
                this.transport.setOption("qs.wsdl", "org.apache.axis.transport.http.QSWSDLHandler");
                return;
            }
            boolean bl = true;
            String string = (String)this.transport.getOption("useDefaultQueryStrings");
            if (string != null && string.toLowerCase().equals("false")) {
                bl = false;
            }
            if (bl) {
                this.transport.setOption("qs.list", "org.apache.axis.transport.http.QSListHandler");
                this.transport.setOption("qs.method", "org.apache.axis.transport.http.QSMethodHandler");
                this.transport.setOption("qs.wsdl", "org.apache.axis.transport.http.QSWSDLHandler");
            }
        }
        catch (AxisFault axisFault) {
            this.transport = new SimpleTargetedChain();
            this.transport.setOption("qs.list", "org.apache.axis.transport.http.QSListHandler");
            this.transport.setOption("qs.method", "org.apache.axis.transport.http.QSMethodHandler");
            this.transport.setOption("qs.wsdl", "org.apache.axis.transport.http.QSWSDLHandler");
            return;
        }
    }

    private boolean processQuery(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws AxisFault {
        String string = httpServletRequest.getServletPath();
        String string2 = httpServletRequest.getQueryString();
        AxisServer axisServer = this.getEngine();
        Iterator iterator = this.transport.getOptions().keySet().iterator();
        if (string2 == null) {
            return false;
        }
        String string3 = httpServletRequest.getContextPath() + string;
        String string4 = httpServletRequest.getRequestURI();
        String string5 = string3.length() + 1 < string4.length() ? string4.substring(string3.length() + 1) : "";
        while (iterator.hasNext()) {
            String string6 = (String)iterator.next();
            if (!string6.startsWith("qs.")) continue;
            String string7 = string6.substring(string6.indexOf(".") + 1).toLowerCase();
            int n = 0;
            boolean bl = false;
            while (!bl && n < string2.length()) {
                char c;
                if ((c = string2.charAt(n++)) != '&' && c != '=') continue;
                bl = true;
                --n;
            }
            if (n < string2.length()) {
                string2 = string2.substring(0, n);
            }
            if (!string2.toLowerCase().equals(string7)) continue;
            if (this.transport.getOption(string6).equals("")) {
                return false;
            }
            try {
                MessageContext messageContext = this.createMessageContext(axisServer, httpServletRequest, httpServletResponse);
                Class<?> clazz = Class.forName((String)this.transport.getOption(string6));
                Method method = clazz.getDeclaredMethod("invoke", messageContext.getClass());
                String string8 = HttpUtils.getRequestURL(httpServletRequest).toString();
                messageContext.setProperty("transport.url", string8);
                messageContext.setProperty("transport.http.plugin.serviceName", string5);
                messageContext.setProperty("transport.http.plugin.pluginName", string7);
                messageContext.setProperty("transport.http.plugin.isDevelopment", new Boolean(this.isDevelopment()));
                messageContext.setProperty("transport.http.plugin.enableList", new Boolean(this.enableList));
                messageContext.setProperty("transport.http.plugin.engine", axisServer);
                messageContext.setProperty("transport.http.plugin.writer", printWriter);
                messageContext.setProperty("transport.http.plugin.log", log);
                messageContext.setProperty("transport.http.plugin.exceptionLog", exceptionLog);
                method.invoke(clazz.newInstance(), messageContext);
                printWriter.close();
                return true;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.reportTroubleInGet(invocationTargetException.getTargetException(), httpServletResponse, printWriter);
                return true;
            }
            catch (Exception exception) {
                this.reportTroubleInGet(exception, httpServletResponse, printWriter);
                return true;
            }
        }
        return false;
    }

    private static String getRequestPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "");
    }
}

