/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.util.HashMap;
import java.util.Set;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorManager;
import org.apache.axis.transport.jms.JMSURLHelper;
import org.apache.axis.transport.jms.MapUtils;
import org.apache.axis.transport.jms.QueueConnector;
import org.apache.axis.transport.jms.TopicConnector;
import org.apache.commons.logging.Log;

public abstract class JMSConnectorFactory {
    protected static Log log = LogFactory.getLog(JMSConnectorFactory.class.getName());

    public static JMSConnector matchConnector(Set set, HashMap hashMap, HashMap hashMap2, String string, String string2, JMSVendorAdapter jMSVendorAdapter) {
        for (JMSConnector jMSConnector : set) {
            block6: {
                String string3;
                String string4 = jMSConnector.getUsername();
                if (!((string4 == null && string == null || string4 != null && string != null && string4.equals(string)) && ((string3 = jMSConnector.getPassword()) == null && string2 == null || string3 != null && string2 != null && string3.equals(string2)))) continue;
                int n = jMSConnector.getNumRetries();
                String string5 = (String)hashMap.get("transport.jms.numRetries");
                int n2 = 5;
                if (string5 != null) {
                    n2 = Integer.parseInt(string5);
                }
                if (n != n2) continue;
                String string6 = jMSConnector.getClientID();
                String string7 = (String)hashMap.get("transport.jms.clientID");
                if ((string6 != null || string7 != null) && (string6 == null || string7 == null || !string6.equals(string7))) continue;
                String string8 = jMSConnector instanceof QueueConnector ? "QUEUE" : "TOPIC";
                String string9 = (String)hashMap.get("transport.jms.domain");
                String string10 = "QUEUE";
                if (string9 != null) {
                    string10 = string9;
                }
                if (!(string8 == null && string10 == null || string8 != null && string10 != null && string8.equalsIgnoreCase(string10))) continue;
                JMSURLHelper jMSURLHelper = jMSConnector.getJMSURL();
                if (!jMSVendorAdapter.isMatchingConnectionFactory(jMSConnector.getConnectionFactory(), jMSURLHelper, hashMap2)) continue;
                try {
                    JMSConnectorManager.getInstance().reserve(jMSConnector);
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("JMSConnectorFactory: Found matching connector");
                }
                catch (Exception exception) {
                    continue;
                }
            }
            return jMSConnector;
        }
        if (log.isDebugEnabled()) {
            log.debug("JMSConnectorFactory: No matching connectors found");
        }
        return null;
    }

    public static JMSConnector createServerConnector(HashMap hashMap, HashMap hashMap2, String string, String string2, JMSVendorAdapter jMSVendorAdapter) throws Exception {
        return JMSConnectorFactory.createConnector(hashMap, hashMap2, true, string, string2, jMSVendorAdapter);
    }

    public static JMSConnector createClientConnector(HashMap hashMap, HashMap hashMap2, String string, String string2, JMSVendorAdapter jMSVendorAdapter) throws Exception {
        return JMSConnectorFactory.createConnector(hashMap, hashMap2, false, string, string2, jMSVendorAdapter);
    }

    private static JMSConnector createConnector(HashMap hashMap, HashMap hashMap2, boolean bl, String string, String string2, JMSVendorAdapter jMSVendorAdapter) throws Exception {
        if (hashMap != null) {
            hashMap = (HashMap)hashMap.clone();
        }
        int n = MapUtils.removeIntProperty(hashMap, "transport.jms.numRetries", 5);
        int n2 = MapUtils.removeIntProperty(hashMap, "transport.jms.numSessions", 5);
        long l = MapUtils.removeLongProperty(hashMap, "transport.jms.connectRetryInterval", 2000L);
        long l2 = MapUtils.removeLongProperty(hashMap, "transport.jms.interactRetryInterval", 250L);
        long l3 = MapUtils.removeLongProperty(hashMap, "transport.jms.timeoutTime", 5000L);
        String string3 = MapUtils.removeStringProperty(hashMap, "transport.jms.clientID", null);
        String string4 = MapUtils.removeStringProperty(hashMap, "transport.jms.domain", "QUEUE");
        JMSURLHelper jMSURLHelper = (JMSURLHelper)hashMap.get("transport.jms.EndpointAddress");
        if (hashMap2 == null) {
            throw new IllegalArgumentException("noCfConfig");
        }
        if (string4.equals("QUEUE")) {
            return new QueueConnector(jMSVendorAdapter.getQueueConnectionFactory(hashMap2), n, n2, l, l2, l3, bl, string3, string, string2, jMSVendorAdapter, jMSURLHelper);
        }
        return new TopicConnector(jMSVendorAdapter.getTopicConnectionFactory(hashMap2), n, n2, l, l2, l3, bl, string3, string, string2, jMSVendorAdapter, jMSURLHelper);
    }
}

