/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.mail.MailServer;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;

public class MailWorker
implements Runnable {
    protected static Log log = LogFactory.getLog(MailWorker.class.getName());
    private MailServer server;
    private MimeMessage mimeMessage;
    private static String transportName = "Mail";
    private Properties prop = new Properties();
    private Session session = Session.getDefaultInstance(this.prop, null);

    public MailWorker(MailServer mailServer, MimeMessage mimeMessage) {
        this.server = mailServer;
        this.mimeMessage = mimeMessage;
    }

    public void run() {
        AxisServer axisServer = MailServer.getAxisServer();
        MessageContext messageContext = new MessageContext(axisServer);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        Message message = null;
        try {
            messageContext.setTargetService(null);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        messageContext.setResponseMessage(null);
        messageContext.reset();
        messageContext.setTransportName(transportName);
        message = null;
        try {
            Object object;
            Object object2;
            String string;
            try {
                this.parseHeaders(this.mimeMessage, stringBuffer3, stringBuffer4, stringBuffer);
                messageContext.setProperty("realpath", stringBuffer2.toString());
                messageContext.setProperty("path", stringBuffer2.toString());
                messageContext.setProperty("jws.classDir", "jwsClasses");
                string = stringBuffer.toString();
                if (string != null) {
                    messageContext.setUseSOAPAction(true);
                    messageContext.setSOAPActionURI(string);
                }
                Message message2 = new Message(this.mimeMessage.getInputStream(), false, stringBuffer3.toString(), stringBuffer4.toString());
                messageContext.setRequestMessage(message2);
                axisServer.invoke(messageContext);
                message = messageContext.getResponseMessage();
                if (message == null) {
                    throw new AxisFault(Messages.getMessage("nullResponse00"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (exception instanceof AxisFault) {
                    object2 = (AxisFault)exception;
                    log.debug(Messages.getMessage("serverFault00"), (Throwable)object2);
                } else {
                    object2 = AxisFault.makeFault(exception);
                }
                message = messageContext.getResponseMessage();
                if (message == null) {
                    message = new Message(object2);
                }
                try {
                    object = message.getSOAPEnvelope();
                    ((SOAPEnvelope)object).clearBody();
                    ((SOAPEnvelope)object).addBodyElement(new SOAPFault((AxisFault)exception));
                }
                catch (AxisFault axisFault) {
                    // empty catch block
                }
            }
            string = ((InternetAddress)this.mimeMessage.getReplyTo()[0]).getAddress();
            object2 = ((InternetAddress)this.mimeMessage.getAllRecipients()[0]).getAddress();
            object = "Re: " + this.mimeMessage.getSubject();
            this.writeUsingSMTP(messageContext, this.server.getHost(), (String)object2, string, (String)object, message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.debug(Messages.getMessage("exception00"), exception);
        }
        if (messageContext.getProperty("quit.requested") != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeUsingSMTP(MessageContext messageContext, String string, String string2, String string3, String string4, Message message) throws Exception {
        SMTPClient sMTPClient = new SMTPClient();
        sMTPClient.connect(string);
        System.out.print(sMTPClient.getReplyString());
        int n = sMTPClient.getReplyCode();
        if (!SMTPReply.isPositiveCompletion(n)) {
            sMTPClient.disconnect();
            AxisFault axisFault = new AxisFault("SMTP", "( SMTP server refused connection )", null, null);
            throw axisFault;
        }
        sMTPClient.login(string);
        System.out.print(sMTPClient.getReplyString());
        n = sMTPClient.getReplyCode();
        if (!SMTPReply.isPositiveCompletion(n)) {
            sMTPClient.disconnect();
            AxisFault axisFault = new AxisFault("SMTP", "( SMTP server refused connection )", null, null);
            throw axisFault;
        }
        MimeMessage mimeMessage = new MimeMessage(this.session);
        mimeMessage.setFrom(new InternetAddress(string2));
        mimeMessage.addRecipient(MimeMessage.RecipientType.TO, new InternetAddress(string3));
        mimeMessage.setDisposition("inline");
        mimeMessage.setSubject(string4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        message.writeTo(byteArrayOutputStream);
        mimeMessage.setContent(byteArrayOutputStream.toString(), message.getContentType(messageContext.getSOAPConstants()));
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(8192);
        mimeMessage.writeTo(byteArrayOutputStream2);
        sMTPClient.setSender(string2);
        System.out.print(sMTPClient.getReplyString());
        sMTPClient.addRecipient(string3);
        System.out.print(sMTPClient.getReplyString());
        Writer writer = sMTPClient.sendMessageData();
        System.out.print(sMTPClient.getReplyString());
        writer.write(byteArrayOutputStream2.toString());
        writer.flush();
        writer.close();
        System.out.print(sMTPClient.getReplyString());
        if (!sMTPClient.completePendingCommand()) {
            System.out.print(sMTPClient.getReplyString());
            AxisFault axisFault = new AxisFault("SMTP", "( Failed to send email )", null, null);
            throw axisFault;
        }
        System.out.print(sMTPClient.getReplyString());
        sMTPClient.logout();
        sMTPClient.disconnect();
    }

    private void parseHeaders(MimeMessage mimeMessage, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws Exception {
        stringBuffer.append(mimeMessage.getContentType());
        stringBuffer2.append(mimeMessage.getContentID());
        String[] stringArray = mimeMessage.getHeader("SOAPAction");
        if (stringArray != null) {
            stringBuffer3.append(stringArray[0]);
        }
    }
}

