/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.axis.utils.Messages;

public class Month
implements Serializable {
    int month;
    String timezone = null;

    public Month(int n) throws NumberFormatException {
        this.setValue(n);
    }

    public Month(int n, String string) throws NumberFormatException {
        this.setValue(n, string);
    }

    public Month(String string) throws NumberFormatException {
        if (string.length() < 6) {
            throw new NumberFormatException(Messages.getMessage("badMonth00"));
        }
        if (string.charAt(0) != '-' || string.charAt(1) != '-' || string.charAt(4) != '-' || string.charAt(5) != '-') {
            throw new NumberFormatException(Messages.getMessage("badMonth00"));
        }
        this.setValue(Integer.parseInt(string.substring(2, 4)), string.substring(6));
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        if (n < 1 || n > 12) {
            throw new NumberFormatException(Messages.getMessage("badMonth00"));
        }
        this.month = n;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String string) {
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-' ? string.length() != 6 || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5)) : !string.equals("Z")) {
                throw new NumberFormatException(Messages.getMessage("badTimezone00"));
            }
            this.timezone = string;
        }
    }

    public void setValue(int n, String string) throws NumberFormatException {
        this.setMonth(n);
        this.setTimezone(string);
    }

    public void setValue(int n) throws NumberFormatException {
        this.setMonth(n);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        String string = "--" + numberFormat.format(this.month) + "--";
        if (this.timezone != null) {
            string = string + this.timezone;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Month)) {
            return false;
        }
        Month month = (Month)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl2 = bl = this.month == month.month;
        if (this.timezone != null) {
            bl = bl && this.timezone.equals(month.timezone);
        }
        return bl;
    }

    public int hashCode() {
        return null == this.timezone ? this.month : this.month ^ this.timezone.hashCode();
    }
}

