/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Admin {
    protected static Log log = LogFactory.getLog(Admin.class.getName());

    public Element[] AdminService(Element[] elementArray) throws Exception {
        log.debug("Enter: Admin::AdminService");
        MessageContext messageContext = MessageContext.getCurrentContext();
        Document document = this.process(messageContext, elementArray[0]);
        Element[] elementArray2 = new Element[]{document.getDocumentElement()};
        log.debug("Exit: Admin::AdminService");
        return elementArray2;
    }

    protected static Document processWSDD(MessageContext messageContext, AxisEngine axisEngine, Element element) throws Exception {
        Document document = null;
        String string = element.getLocalName();
        if (string.equals("passwd")) {
            String string2 = element.getFirstChild().getNodeValue();
            axisEngine.setAdminPassword(string2);
            document = XMLUtils.newDocument();
            element = document.createElementNS("", "Admin");
            document.appendChild(element);
            element.appendChild(document.createTextNode(Messages.getMessage("done00")));
            return document;
        }
        if (string.equals("quit")) {
            log.error(Messages.getMessage("quitRequest00"));
            if (messageContext != null) {
                messageContext.setProperty("quit.requested", "true");
            }
            document = XMLUtils.newDocument();
            element = document.createElementNS("", "Admin");
            document.appendChild(element);
            element.appendChild(document.createTextNode(Messages.getMessage("quit00", "")));
            return document;
        }
        if (string.equals("list")) {
            return Admin.listConfig(axisEngine);
        }
        if (string.equals("clientdeploy")) {
            axisEngine = axisEngine.getClientEngine();
        }
        WSDDDocument wSDDDocument = new WSDDDocument(element);
        EngineConfiguration engineConfiguration = axisEngine.getConfig();
        if (engineConfiguration instanceof WSDDEngineConfiguration) {
            WSDDDeployment wSDDDeployment = ((WSDDEngineConfiguration)engineConfiguration).getDeployment();
            wSDDDocument.deploy(wSDDDeployment);
        }
        axisEngine.refreshGlobalOptions();
        axisEngine.saveConfiguration();
        document = XMLUtils.newDocument();
        element = document.createElementNS("", "Admin");
        document.appendChild(element);
        element.appendChild(document.createTextNode(Messages.getMessage("done00")));
        return document;
    }

    public Document process(MessageContext messageContext, Element element) throws Exception {
        this.verifyHostAllowed(messageContext);
        String string = element.getNamespaceURI();
        AxisEngine axisEngine = messageContext.getAxisEngine();
        if (string != null && string.equals("http://xml.apache.org/axis/wsdd/")) {
            return Admin.processWSDD(messageContext, axisEngine, element);
        }
        throw new Exception(Messages.getMessage("adminServiceNoWSDD"));
    }

    private void verifyHostAllowed(MessageContext messageContext) throws AxisFault {
        String string;
        SOAPService sOAPService = messageContext.getService();
        if (sOAPService != null && !JavaUtils.isTrueExplicitly(sOAPService.getOption("enableRemoteAdmin")) && (string = messageContext.getStrProp("remoteaddr")) != null && !string.equals("127.0.0.1")) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                InetAddress inetAddress2 = InetAddress.getByName(string);
                if (log.isDebugEnabled()) {
                    log.debug("Comparing remote caller " + inetAddress2 + " to " + inetAddress);
                }
                if (!inetAddress.equals(inetAddress2)) {
                    log.error(Messages.getMessage("noAdminAccess01", inetAddress2.toString()));
                    throw new AxisFault("Server.Unauthorized", Messages.getMessage("noAdminAccess00"), null, null);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new AxisFault("Server.UnknownHost", Messages.getMessage("unknownHost00"), null, null);
            }
        }
    }

    public static Document listConfig(AxisEngine axisEngine) throws AxisFault {
        StringWriter stringWriter = new StringWriter();
        SerializationContext serializationContext = new SerializationContext(stringWriter, null);
        serializationContext.setPretty(true);
        try {
            EngineConfiguration engineConfiguration = axisEngine.getConfig();
            if (engineConfiguration instanceof WSDDEngineConfiguration) {
                WSDDDeployment wSDDDeployment = ((WSDDEngineConfiguration)engineConfiguration).getDeployment();
                wSDDDeployment.writeToContext(serializationContext);
            }
        }
        catch (Exception exception) {
            throw new AxisFault(Messages.getMessage("noEngineWSDD"));
        }
        try {
            stringWriter.close();
            return XMLUtils.newDocument(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
        }
        catch (Exception exception) {
            log.error("exception00", exception);
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        if (stringArray.length < 2 || !stringArray[0].equals("client") && !stringArray[0].equals("server")) {
            log.error(Messages.getMessage("usage00", "Admin client|server <xml-file>"));
            log.error(Messages.getMessage("where00", "<xml-file>"));
            log.error("<deploy>");
            log.error("  <handler name=a class=className/>");
            log.error("  <chain name=a flow=\"a,b,c\" />");
            log.error("  <chain name=a request=\"a,b,c\" pivot=\"d\"");
            log.error("                  response=\"e,f,g\" />");
            log.error("  <service name=a handler=b />");
            log.error("</deploy>");
            log.error("<undeploy>");
            log.error("  <handler name=a/>");
            log.error("  <chain name=a/>");
            log.error("  <service name=a/>");
            log.error("</undeploy>");
            log.error("<list/>");
            throw new IllegalArgumentException(Messages.getMessage("usage00", "Admin client|server <xml-file>"));
        }
        Admin admin = new Admin();
        AxisEngine axisEngine = stringArray[0].equals("client") ? new AxisClient() : new AxisServer();
        axisEngine.setShouldSaveConfig(true);
        axisEngine.init();
        MessageContext messageContext = new MessageContext(axisEngine);
        try {
            for (n = 1; n < stringArray.length; ++n) {
                Document document;
                Document document2;
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("process00", stringArray[n]));
                }
                if ((document2 = admin.process(messageContext, (document = XMLUtils.newDocument(new FileInputStream(stringArray[n]))).getDocumentElement())) == null) continue;
                System.out.println(XMLUtils.DocumentToString(document2));
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("errorProcess00", stringArray[n]), exception);
            throw exception;
        }
    }
}

