/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.axis.AxisProperties;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;

public class ClasspathUtils {
    public static String expandDirs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (!file.isDirectory()) continue;
            File[] fileArray = file.listFiles(new JavaArchiveFilter());
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(fileArray[i]).append(File.pathSeparator);
            }
        }
        return stringBuffer.toString();
    }

    public static boolean isJar(InputStream inputStream) {
        try {
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            if (jarInputStream.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static String getDefaultClasspath(MessageContext messageContext) {
        StringBuffer stringBuffer = new StringBuffer();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClasspathUtils.fillClassPath(classLoader, stringBuffer);
        String string = (String)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION);
        if (string != null) {
            stringBuffer.append(string + File.separatorChar + "classes" + File.pathSeparatorChar);
            try {
                String string2 = string + File.separatorChar + "lib";
                File file = new File(string2);
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (!string3.endsWith(".jar")) continue;
                    stringBuffer.append(string2 + File.separatorChar + string3 + File.pathSeparatorChar);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ClasspathUtils.getClassPathFromDirectoryProperty(stringBuffer, "axis.ext.dirs");
        ClasspathUtils.getClassPathFromProperty(stringBuffer, "org.apache.catalina.jsp_classpath");
        ClasspathUtils.getClassPathFromProperty(stringBuffer, "ws.ext.dirs");
        ClasspathUtils.getClassPathFromProperty(stringBuffer, "com.ibm.websphere.servlet.application.classpath");
        ClasspathUtils.getClassPathFromProperty(stringBuffer, "java.class.path");
        ClasspathUtils.getClassPathFromDirectoryProperty(stringBuffer, "java.ext.dirs");
        ClasspathUtils.getClassPathFromProperty(stringBuffer, "sun.boot.class.path");
        return stringBuffer.toString();
    }

    private static void getClassPathFromDirectoryProperty(StringBuffer stringBuffer, String string) {
        String string2 = AxisProperties.getProperty(string);
        String string3 = null;
        try {
            string3 = ClasspathUtils.expandDirs(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append(File.pathSeparatorChar);
        }
    }

    private static void getClassPathFromProperty(StringBuffer stringBuffer, String string) {
        String string2 = AxisProperties.getProperty(string);
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(File.pathSeparatorChar);
        }
    }

    private static void fillClassPath(ClassLoader classLoader, StringBuffer stringBuffer) {
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                for (int i = 0; uRLArray != null && i < uRLArray.length; ++i) {
                    String string = uRLArray[i].getPath();
                    if (string.length() >= 3 && string.charAt(0) == '/' && string.charAt(2) == ':') {
                        string = string.substring(1);
                    }
                    stringBuffer.append(URLDecoder.decode(string));
                    stringBuffer.append(File.pathSeparatorChar);
                    File file = new File(uRLArray[i].getFile());
                    if (!file.isFile()) continue;
                    FileInputStream fileInputStream = null;
                    try {
                        Attributes attributes;
                        JarFile jarFile;
                        Manifest manifest;
                        fileInputStream = new FileInputStream(file);
                        if (!ClasspathUtils.isJar(fileInputStream) || (manifest = (jarFile = new JarFile(file)).getManifest()) == null || (attributes = manifest.getMainAttributes()) == null) continue;
                        String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
                        String string3 = file.getParent();
                        if (string2 == null) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken();
                            stringBuffer.append(string3 + File.separatorChar + string4);
                            stringBuffer.append(File.pathSeparatorChar);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        if (fileInputStream == null) continue;
                        try {
                            fileInputStream.close();
                            continue;
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
            }
            classLoader = classLoader.getParent();
        }
    }

    private static class JavaArchiveFilter
    implements FileFilter {
        private JavaArchiveFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return string.endsWith(".jar") || string.endsWith(".zip");
        }
    }
}

