/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.bytecode;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.bytecode.ParamReader;
import org.apache.commons.logging.Log;

public class ParamNameExtractor {
    protected static Log log = LogFactory.getLog(ParamNameExtractor.class.getName());

    public static String[] getParameterNamesFromDebugInfo(Method method) {
        int n = method.getParameterTypes().length;
        if (n == 0) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Proxy.isProxyClass(clazz)) {
            return null;
        }
        try {
            ParamReader paramReader = new ParamReader(clazz);
            String[] stringArray = paramReader.getParameterNames(method);
            return stringArray;
        }
        catch (IOException iOException) {
            log.info(Messages.getMessage("error00") + ":" + iOException);
            return null;
        }
    }
}

