/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.Version;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Emitter {
    protected static Log log = LogFactory.getLog(Emitter.class.getName());
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    private Class cls;
    private Class[] extraClasses;
    private Class implCls;
    private Vector allowedMethods = null;
    private Vector disallowedMethods = null;
    private ArrayList stopClasses = new ArrayList();
    private boolean useInheritedMethods = false;
    private String intfNS;
    private String implNS;
    private String inputSchema;
    private String inputWSDL;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private String targetService = null;
    private String description;
    private Style style = Style.RPC;
    private Use use = null;
    private TypeMapping tm = null;
    private TypeMappingRegistry tmr = new TypeMappingRegistryImpl();
    private Namespaces namespaces;
    private Map exceptionMsg = null;
    private Map usedElementNames;
    private ArrayList encodingList;
    protected Types types;
    private String clsName;
    private String portTypeName;
    private String bindingName;
    private ServiceDesc serviceDesc;
    private JavaServiceDesc serviceDesc2;
    private String soapAction = "DEFAULT";
    private boolean emitAllTypes = false;
    private String versionMessage = null;
    private HashMap qName2ClassMap;
    public static final int MODE_RPC = 0;
    public static final int MODE_DOCUMENT = 1;
    public static final int MODE_DOC_WRAPPED = 2;
    protected static TypeMapping standardTypes = (TypeMapping)new TypeMappingRegistryImpl().getTypeMapping(null);
    Document docHolder;

    public Emitter() {
        this.createDocumentFragment();
        this.namespaces = new Namespaces();
        this.exceptionMsg = new HashMap();
        this.usedElementNames = new HashMap();
        this.qName2ClassMap = new HashMap();
    }

    public void emit(String string, String string2) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Definition definition = this.getIntfWSDL();
        Definition definition2 = this.getImplWSDL();
        if (string == null) {
            string = this.getServicePortName() + "_interface.wsdl";
        }
        if (string2 == null) {
            string2 = this.getServicePortName() + "_implementation.wsdl";
        }
        for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
            this.types.writeTypeForPart(this.extraClasses[i], null);
        }
        Document document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
        this.types.insertTypesFragment(document);
        this.prettyDocumentToFile(document, string);
        document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition2);
        this.prettyDocumentToFile(document, string2);
    }

    public void emit(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.emit(string, 0);
    }

    public Document emit(int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document document;
        switch (n) {
            default: {
                int n2;
                Definition definition = this.getWSDL();
                for (n2 = 0; this.extraClasses != null && n2 < this.extraClasses.length; ++n2) {
                    this.types.writeTypeForPart(this.extraClasses[n2], null);
                }
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 1: {
                int n2;
                Definition definition = this.getIntfWSDL();
                for (n2 = 0; this.extraClasses != null && n2 < this.extraClasses.length; ++n2) {
                    this.types.writeTypeForPart(this.extraClasses[n2], null);
                }
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 2: {
                Definition definition = this.getImplWSDL();
                document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
            }
        }
        if (this.versionMessage == null) {
            this.versionMessage = Messages.getMessage("wsdlCreated00", XMLUtils.xmlEncodeString(Version.getVersion()));
        }
        if (this.versionMessage != null && this.versionMessage.length() > 0) {
            Comment comment = document.createComment(this.versionMessage);
            document.getDocumentElement().insertBefore(comment, document.getDocumentElement().getFirstChild());
        }
        return document;
    }

    public String emitToString(int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document document = this.emit(n);
        StringWriter stringWriter = new StringWriter();
        XMLUtils.PrettyDocumentToWriter(document, stringWriter);
        return stringWriter.toString();
    }

    public void emit(String string, int n) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document document = this.emit(n);
        if (string == null) {
            string = this.getServicePortName();
            switch (n) {
                case 0: {
                    string = string + ".wsdl";
                    break;
                }
                case 1: {
                    string = string + "_interface.wsdl";
                    break;
                }
                case 2: {
                    string = string + "_implementation.wsdl";
                }
            }
        }
        this.prettyDocumentToFile(document, string);
    }

    public Definition getWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(0);
        Definition definition = this.createDefinition();
        this.writeDefinitions(definition, this.intfNS);
        this.types = this.createTypes(definition);
        Binding binding = this.writeBinding(definition, true);
        this.writePortType(definition, binding);
        this.writeService(definition, binding);
        return definition;
    }

    public Definition getIntfWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(1);
        Definition definition = this.createDefinition();
        this.writeDefinitions(definition, this.intfNS);
        this.types = this.createTypes(definition);
        Binding binding = this.writeBinding(definition, true);
        this.writePortType(definition, binding);
        return definition;
    }

    public Definition getImplWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(2);
        Definition definition = this.createDefinition();
        this.writeDefinitions(definition, this.implNS);
        this.writeImport(definition, this.intfNS, this.importUrl);
        Binding binding = this.writeBinding(definition, false);
        this.writeService(definition, binding);
        return definition;
    }

    protected void init(int n) {
        Object object;
        if (this.use == null) {
            this.use = this.style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
        if (this.tm == null) {
            object = "";
            if (this.use == Use.ENCODED) {
                object = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            this.tm = (TypeMapping)this.tmr.getTypeMapping((String)object);
        }
        if (this.serviceDesc == null) {
            this.serviceDesc = object = new JavaServiceDesc();
            ((JavaServiceDesc)object).setImplClass(this.cls);
            this.serviceDesc.setTypeMapping(this.tm);
            ((JavaServiceDesc)object).setStopClasses(this.stopClasses);
            this.serviceDesc.setAllowedMethods(this.allowedMethods);
            ((JavaServiceDesc)object).setDisallowedMethods(this.disallowedMethods);
            this.serviceDesc.setStyle(this.style);
            this.serviceDesc.setUse(this.use);
            if (this.implCls != null && this.implCls != this.cls && this.serviceDesc2 == null) {
                this.serviceDesc2 = new JavaServiceDesc();
                this.serviceDesc2.setImplClass(this.implCls);
                this.serviceDesc2.setTypeMapping(this.tm);
                this.serviceDesc2.setStopClasses(this.stopClasses);
                this.serviceDesc2.setAllowedMethods(this.allowedMethods);
                this.serviceDesc2.setDisallowedMethods(this.disallowedMethods);
                this.serviceDesc2.setStyle(this.style);
            }
        }
        if (this.encodingList == null) {
            int n2;
            if (this.cls != null) {
                this.clsName = this.cls.getName();
                this.clsName = this.clsName.substring(this.clsName.lastIndexOf(46) + 1);
            } else {
                this.clsName = this.getServiceDesc().getName();
            }
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(this.clsName);
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                object = this.getLocationUrl();
                if (object != null && (object = ((String)object).lastIndexOf(47) > 0 ? ((String)object).substring(((String)object).lastIndexOf(47) + 1) : (((String)object).lastIndexOf(92) > 0 ? ((String)object).substring(((String)object).lastIndexOf(92) + 1) : null)) != null && ((String)object).endsWith(".jws")) {
                    object = ((String)object).substring(0, ((String)object).length() - ".jws".length());
                }
                if (object == null || ((String)object).equals("")) {
                    object = this.clsName;
                }
                this.setServicePortName((String)object);
            }
            if (this.getBindingName() == null) {
                this.setBindingName(this.getServicePortName() + "SoapBinding");
            }
            this.encodingList = new ArrayList();
            this.encodingList.add(Constants.URI_DEFAULT_SOAP_ENC);
            if (this.intfNS == null) {
                object = this.cls.getPackage();
                this.intfNS = this.namespaces.getCreate(object == null ? null : ((Package)object).getName());
            }
            if (this.implNS == null) {
                this.implNS = n == 0 ? this.intfNS : this.intfNS + "-impl";
            }
            this.serviceDesc.setDefaultNamespace(this.intfNS);
            if (this.serviceDesc2 != null) {
                this.serviceDesc2.setDefaultNamespace(this.implNS);
            }
            if (this.cls != null && (n2 = ((String)(object = this.cls.getName())).lastIndexOf(".")) > 0) {
                String string = ((String)object).substring(0, n2);
                this.namespaces.put(string, this.intfNS, "intf");
            }
            this.namespaces.putPrefix(this.implNS, "impl");
        }
    }

    protected Definition createDefinition() throws WSDLException, SAXException, IOException, ParserConfigurationException {
        Definition definition;
        if (this.inputWSDL == null) {
            definition = WSDLFactory.newInstance().newDefinition();
        } else {
            WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
            Document document = XMLUtils.newDocument(this.inputWSDL);
            definition = wSDLReader.readWSDL(null, document);
            definition.setTypes(null);
        }
        return definition;
    }

    protected Types createTypes(Definition definition) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Class[] classArray;
        this.types = new Types(definition, this.tm, (TypeMapping)this.tmr.getDefaultTypeMapping(), this.namespaces, this.intfNS, this.stopClasses, this.serviceDesc, this);
        if (this.inputWSDL != null) {
            this.types.loadInputTypes(this.inputWSDL);
        }
        if (this.inputSchema != null) {
            classArray = new StringTokenizer(this.inputSchema, ", ");
            while (classArray.hasMoreTokens()) {
                String string = classArray.nextToken();
                this.types.loadInputSchema(string);
            }
        }
        if (this.emitAllTypes && this.tm != null) {
            classArray = this.tm.getAllClasses();
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                QName qName = this.tm.getTypeQName(clazz);
                if (qName.getLocalPart().indexOf(">") != -1 || standardTypes.getSerializer(clazz) != null) continue;
                this.types.writeTypeForPart(clazz, qName);
            }
            this.types.mappedTypes = null;
        }
        return this.types;
    }

    protected Element createDocumentationElement(String string) {
        Element element = this.docHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "documentation");
        element.setPrefix("wsdl");
        Text text = this.docHolder.createTextNode(string);
        element.appendChild(text);
        return element;
    }

    protected void writeDefinitions(Definition definition, String string) {
        definition.setTargetNamespace(string);
        definition.addNamespace("intf", this.intfNS);
        definition.addNamespace("impl", this.implNS);
        definition.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        if (this.use == Use.ENCODED) {
            definition.addNamespace("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
            this.namespaces.putPrefix(Constants.URI_DEFAULT_SOAP_ENC, "soapenc");
        }
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
        definition.addNamespace("apachesoap", "http://xml.apache.org/xml-soap");
        this.namespaces.putPrefix("http://xml.apache.org/xml-soap", "apachesoap");
    }

    protected void writeImport(Definition definition, String string, String string2) {
        Import import_ = definition.createImport();
        import_.setNamespaceURI(string);
        if (string2 != null && !string2.equals("")) {
            import_.setLocationURI(string2);
        }
        definition.addImport(import_);
    }

    protected Binding writeBinding(Definition definition, boolean bl) {
        QName qName = new QName(this.intfNS, this.getBindingName());
        Binding binding = definition.getBinding(qName);
        if (binding != null) {
            return binding;
        }
        binding = definition.createBinding();
        binding.setUndefined(false);
        binding.setQName(qName);
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        String string = this.style == Style.RPC ? "rpc" : "document";
        sOAPBindingImpl.setStyle(string);
        sOAPBindingImpl.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement(sOAPBindingImpl);
        if (bl) {
            definition.addBinding(binding);
        }
        return binding;
    }

    private void createDocumentFragment() {
        try {
            this.docHolder = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalException(parserConfigurationException);
        }
    }

    protected void writeService(Definition definition, Binding binding) {
        QName qName = new QName(this.implNS, this.getServiceElementName());
        Service service = definition.getService(qName);
        if (service == null) {
            service = definition.createService();
            service.setQName(qName);
            definition.addService(service);
        }
        if (this.description != null) {
            service.setDocumentationElement(this.createDocumentationElement(this.description));
        } else if (this.serviceDesc.getDocumentation() != null) {
            service.setDocumentationElement(this.createDocumentationElement(this.serviceDesc.getDocumentation()));
        }
        Port port = definition.createPort();
        port.setBinding(binding);
        port.setName(this.getServicePortName());
        SOAPAddressImpl sOAPAddressImpl = new SOAPAddressImpl();
        sOAPAddressImpl.setLocationURI(this.locationUrl);
        port.addExtensibilityElement(sOAPAddressImpl);
        service.addPort(port);
    }

    protected void writePortType(Definition definition, Binding binding) throws WSDLException, AxisFault {
        QName qName = new QName(this.intfNS, this.getPortTypeName());
        PortType portType = definition.getPortType(qName);
        boolean bl = false;
        if (portType == null) {
            portType = definition.createPortType();
            portType.setUndefined(false);
            portType.setQName(qName);
            bl = true;
        } else if (binding.getBindingOperations().size() > 0) {
            return;
        }
        ArrayList arrayList = this.serviceDesc.getOperations();
        for (OperationDesc operationDesc : arrayList) {
            BindingOperation bindingOperation = this.writeOperation(definition, binding, operationDesc);
            Operation operation = bindingOperation.getOperation();
            OperationDesc operationDesc2 = operationDesc;
            if (operationDesc2.getDocumentation() != null) {
                operation.setDocumentationElement(this.createDocumentationElement(operationDesc2.getDocumentation()));
            }
            if (this.serviceDesc2 != null) {
                OperationDesc[] operationDescArray = this.serviceDesc2.getOperationsByName(operationDesc.getName());
                boolean bl2 = false;
                if (operationDescArray != null) {
                    for (int i = 0; i < operationDescArray.length && !bl2; ++i) {
                        OperationDesc operationDesc3 = operationDescArray[i];
                        if (operationDesc3.getParameters().size() != operationDesc.getParameters().size()) continue;
                        boolean bl3 = true;
                        for (int j = 0; j < operationDesc.getParameters().size() && bl3; ++j) {
                            if (operationDesc3.getParameter(j).getMode() == operationDesc.getParameter(j).getMode() && operationDesc3.getParameter(j).getJavaType().equals(operationDesc.getParameter(j).getJavaType())) continue;
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        operationDesc2 = operationDesc3;
                        bl2 = true;
                    }
                }
            }
            this.writeMessages(definition, operation, operationDesc2, bindingOperation);
            if (!bl) continue;
            portType.addOperation(operation);
        }
        if (bl) {
            definition.addPortType(portType);
        }
        binding.setPortType(portType);
    }

    protected void writeMessages(Definition definition, Operation operation, OperationDesc operationDesc, BindingOperation bindingOperation) throws WSDLException, AxisFault {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Input input = definition.createInput();
        Message message = this.writeRequestMessage(definition, operationDesc, bindingOperation);
        input.setMessage(message);
        String string = message.getQName().getLocalPart();
        input.setName(string);
        bindingOperation.getBindingInput().setName(string);
        operation.setInput(input);
        definition.addMessage(message);
        if (OperationType.REQUEST_RESPONSE.equals(operationDesc.getMep())) {
            message = this.writeResponseMessage(definition, operationDesc, bindingOperation);
            serializable3 = definition.createOutput();
            serializable3.setMessage(message);
            string = message.getQName().getLocalPart();
            serializable3.setName(string);
            bindingOperation.getBindingOutput().setName(string);
            operation.setOutput((Output)serializable3);
            definition.addMessage(message);
        }
        serializable3 = operationDesc.getFaults();
        for (int i = 0; serializable3 != null && i < ((ArrayList)serializable3).size(); ++i) {
            serializable2 = (FaultDesc)((ArrayList)serializable3).get(i);
            message = this.writeFaultMessage(definition, (FaultDesc)serializable2);
            Fault fault = definition.createFault();
            fault.setMessage(message);
            fault.setName(((FaultDesc)serializable2).getName());
            operation.addFault(fault);
            serializable = definition.createBindingFault();
            serializable.setName(((FaultDesc)serializable2).getName());
            SOAPFault sOAPFault = this.writeSOAPFault((FaultDesc)serializable2);
            serializable.addExtensibilityElement(sOAPFault);
            bindingOperation.addBindingFault((BindingFault)serializable);
            if (definition.getMessage(message.getQName()) != null) continue;
            definition.addMessage(message);
        }
        ArrayList arrayList = operationDesc.getParameters();
        serializable2 = new Vector();
        for (int i = 0; i < arrayList.size(); ++i) {
            serializable = (ParameterDesc)arrayList.get(i);
            ((Vector)serializable2).add(((ParameterDesc)serializable).getName());
        }
        if (((Vector)serializable2).size() > 0) {
            if (this.style == Style.WRAPPED) {
                ((Vector)serializable2).clear();
            } else {
                operation.setParameterOrdering((List)((Object)serializable2));
            }
        }
    }

    protected BindingOperation writeOperation(Definition definition, Binding binding, OperationDesc operationDesc) {
        Operation operation = definition.createOperation();
        QName qName = operationDesc.getElementQName();
        if (qName != null && qName.getLocalPart() != null) {
            operation.setName(qName.getLocalPart());
        } else {
            operation.setName(operationDesc.getName());
        }
        operation.setUndefined(false);
        return this.writeBindingOperation(definition, binding, operation, operationDesc);
    }

    protected BindingOperation writeBindingOperation(Definition definition, Binding binding, Operation operation, OperationDesc operationDesc) {
        String string;
        BindingOperation bindingOperation = definition.createBindingOperation();
        BindingInput bindingInput = definition.createBindingInput();
        BindingOutput bindingOutput = null;
        if (OperationType.REQUEST_RESPONSE.equals(operationDesc.getMep())) {
            bindingOutput = definition.createBindingOutput();
        }
        bindingOperation.setName(operation.getName());
        bindingOperation.setOperation(operation);
        SOAPOperationImpl sOAPOperationImpl = new SOAPOperationImpl();
        if (this.getSoapAction().equalsIgnoreCase("OPERATION")) {
            string = operation.getName();
        } else if (this.getSoapAction().equalsIgnoreCase("NONE")) {
            string = "";
        } else {
            string = operationDesc.getSoapAction();
            if (string == null) {
                string = "";
            }
        }
        sOAPOperationImpl.setSoapActionURI(string);
        bindingOperation.addExtensibilityElement(sOAPOperationImpl);
        ExtensibilityElement extensibilityElement = this.writeSOAPBody(operationDesc.getElementQName());
        bindingInput.addExtensibilityElement(extensibilityElement);
        if (bindingOutput != null) {
            ExtensibilityElement extensibilityElement2 = this.writeSOAPBody(operationDesc.getReturnQName());
            bindingOutput.addExtensibilityElement(extensibilityElement2);
            bindingOperation.setBindingOutput(bindingOutput);
        }
        bindingOperation.setBindingInput(bindingInput);
        binding.addBindingOperation(bindingOperation);
        return bindingOperation;
    }

    protected SOAPHeader writeSOAPHeader(ParameterDesc parameterDesc, QName qName, String string) {
        SOAPHeaderImpl sOAPHeaderImpl = new SOAPHeaderImpl();
        if (this.use == Use.ENCODED) {
            sOAPHeaderImpl.setUse("encoded");
            sOAPHeaderImpl.setEncodingStyles(this.encodingList);
        } else {
            sOAPHeaderImpl.setUse("literal");
        }
        if (this.targetService == null) {
            sOAPHeaderImpl.setNamespaceURI(this.intfNS);
        } else {
            sOAPHeaderImpl.setNamespaceURI(this.targetService);
        }
        QName qName2 = parameterDesc.getQName();
        if (qName2 != null && !qName2.getNamespaceURI().equals("")) {
            sOAPHeaderImpl.setNamespaceURI(qName2.getNamespaceURI());
        }
        sOAPHeaderImpl.setMessage(qName);
        sOAPHeaderImpl.setPart(string);
        return sOAPHeaderImpl;
    }

    protected ExtensibilityElement writeSOAPBody(QName qName) {
        SOAPBodyImpl sOAPBodyImpl = new SOAPBodyImpl();
        if (this.use == Use.ENCODED) {
            sOAPBodyImpl.setUse("encoded");
            sOAPBodyImpl.setEncodingStyles(this.encodingList);
        } else {
            sOAPBodyImpl.setUse("literal");
        }
        if (this.style == Style.RPC) {
            if (this.targetService == null) {
                sOAPBodyImpl.setNamespaceURI(this.intfNS);
            } else {
                sOAPBodyImpl.setNamespaceURI(this.targetService);
            }
            if (qName != null && !qName.getNamespaceURI().equals("")) {
                sOAPBodyImpl.setNamespaceURI(qName.getNamespaceURI());
            }
        }
        return sOAPBodyImpl;
    }

    protected SOAPFault writeSOAPFault(FaultDesc faultDesc) {
        SOAPFaultImpl sOAPFaultImpl = new SOAPFaultImpl();
        sOAPFaultImpl.setName(faultDesc.getName());
        if (this.use != Use.ENCODED) {
            sOAPFaultImpl.setUse("literal");
        } else {
            sOAPFaultImpl.setUse("encoded");
            sOAPFaultImpl.setEncodingStyles(this.encodingList);
            QName qName = faultDesc.getQName();
            if (qName != null && !qName.getNamespaceURI().equals("")) {
                sOAPFaultImpl.setNamespaceURI(qName.getNamespaceURI());
            } else if (this.targetService == null) {
                sOAPFaultImpl.setNamespaceURI(this.intfNS);
            } else {
                sOAPFaultImpl.setNamespaceURI(this.targetService);
            }
        }
        return sOAPFaultImpl;
    }

    protected Message writeRequestMessage(Definition definition, OperationDesc operationDesc, BindingOperation bindingOperation) throws WSDLException, AxisFault {
        String string;
        Serializable serializable;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = operationDesc.getAllInParams();
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, this.getRequestQName(operationDesc).getLocalPart() + "Request");
        message.setQName(qName);
        message.setUndefined(false);
        boolean bl = this.writeHeaderParts(definition, arrayList2, bindingOperation, message, true);
        if (operationDesc.getStyle() == Style.MESSAGE) {
            object = operationDesc.getElementQName();
            this.types.writeElementDecl((QName)object, Object.class, Constants.XSD_ANYTYPE, false, null);
            serializable = definition.createPart();
            serializable.setName("part");
            serializable.setElementName((QName)object);
            message.addPart((Part)serializable);
            arrayList.add(serializable.getName());
        } else if (operationDesc.getStyle() == Style.WRAPPED) {
            string = this.writeWrapperPart(definition, message, operationDesc, true);
            arrayList.add(string);
        } else {
            if (operationDesc.getStyle() == Style.DOCUMENT && arrayList2.size() > 1) {
                System.out.println(Messages.getMessage("warnDocLitInteropMultipleInputParts"));
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                serializable = (ParameterDesc)arrayList2.get(i);
                if (((ParameterDesc)serializable).isInHeader() || ((ParameterDesc)serializable).isOutHeader()) continue;
                string = this.writePartToMessage(definition, message, true, (ParameterDesc)serializable);
                arrayList.add(string);
            }
        }
        if (bl) {
            object = bindingOperation.getBindingInput().getExtensibilityElements();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                if (!(e instanceof SOAPBodyImpl)) continue;
                SOAPBodyImpl sOAPBodyImpl = (SOAPBodyImpl)e;
                sOAPBodyImpl.setParts(arrayList);
            }
        }
        return message;
    }

    private boolean writeHeaderParts(Definition definition, ArrayList arrayList, BindingOperation bindingOperation, Message message, boolean bl) throws WSDLException, AxisFault {
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            SOAPHeader sOAPHeader;
            String string;
            ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
            if (bl && parameterDesc.isInHeader()) {
                string = this.writePartToMessage(definition, message, bl, parameterDesc);
                sOAPHeader = this.writeSOAPHeader(parameterDesc, message.getQName(), string);
                bindingOperation.getBindingInput().addExtensibilityElement(sOAPHeader);
                bl2 = true;
                continue;
            }
            if (bl || !parameterDesc.isOutHeader()) continue;
            string = this.writePartToMessage(definition, message, bl, parameterDesc);
            sOAPHeader = this.writeSOAPHeader(parameterDesc, message.getQName(), string);
            bindingOperation.getBindingOutput().addExtensibilityElement(sOAPHeader);
            bl2 = true;
        }
        return bl2;
    }

    protected QName getRequestQName(OperationDesc operationDesc) {
        this.qualifyOperation(operationDesc);
        QName qName = operationDesc.getElementQName();
        if (qName == null) {
            qName = new QName(operationDesc.getName());
        }
        return qName;
    }

    private void qualifyOperation(OperationDesc operationDesc) {
        if (this.style == Style.WRAPPED && this.use == Use.LITERAL) {
            QName qName = operationDesc.getElementQName();
            if (qName == null) {
                qName = new QName(this.intfNS, operationDesc.getName());
            } else if (qName.getNamespaceURI().equals("")) {
                qName = new QName(this.intfNS, qName.getLocalPart());
            }
            operationDesc.setElementQName(qName);
        }
    }

    protected QName getResponseQName(OperationDesc operationDesc) {
        this.qualifyOperation(operationDesc);
        QName qName = operationDesc.getElementQName();
        if (qName == null) {
            return new QName(operationDesc.getName() + "Response");
        }
        return new QName(qName.getNamespaceURI(), qName.getLocalPart() + "Response");
    }

    public String writeWrapperPart(Definition definition, Message message, OperationDesc operationDesc, boolean bl) throws AxisFault {
        Serializable serializable;
        QName qName;
        QName qName2 = qName = bl ? this.getRequestQName(operationDesc) : this.getResponseQName(operationDesc);
        boolean bl2 = bl ? operationDesc.getNumInParams() > 0 : (operationDesc.getReturnClass() != Void.TYPE ? true : operationDesc.getNumOutParams() > 0);
        Element element = this.types.writeWrapperElement(qName, bl, bl2);
        if (element != null) {
            Serializable serializable2 = serializable = bl ? operationDesc.getAllInParams() : operationDesc.getAllOutParams();
            if (!bl) {
                String string = operationDesc.getReturnQName() == null ? operationDesc.getName() + "Return" : operationDesc.getReturnQName().getLocalPart();
                this.types.writeWrappedParameter(element, string, operationDesc.getReturnType(), operationDesc.getReturnClass());
            }
            for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)((ArrayList)serializable).get(i);
                if (parameterDesc.isInHeader() || parameterDesc.isOutHeader()) continue;
                this.types.writeWrappedParameter(element, parameterDesc.getName(), parameterDesc.getTypeQName(), parameterDesc.getJavaType());
            }
        }
        serializable = definition.createPart();
        serializable.setName("parameters");
        serializable.setElementName(qName);
        message.addPart((Part)serializable);
        return serializable.getName();
    }

    protected Message writeResponseMessage(Definition definition, OperationDesc operationDesc, BindingOperation bindingOperation) throws WSDLException, AxisFault {
        Serializable serializable;
        Object object;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = operationDesc.getAllOutParams();
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, this.getResponseQName(operationDesc).getLocalPart());
        message.setQName(qName);
        message.setUndefined(false);
        boolean bl = this.writeHeaderParts(definition, arrayList2, bindingOperation, message, false);
        if (operationDesc.getStyle() == Style.WRAPPED) {
            string = this.writeWrapperPart(definition, message, operationDesc, false);
            arrayList.add(string);
        } else {
            String string2;
            object = new ParameterDesc();
            if (operationDesc.getReturnQName() == null) {
                string2 = "";
                if (operationDesc.getStyle() != Style.RPC && ((string2 = this.getServiceDesc().getDefaultNamespace()) == null || "".equals(string2))) {
                    string2 = "http://ws.apache.org/axis/defaultNS";
                }
                ((ParameterDesc)object).setQName(new QName(string2, operationDesc.getName() + "Return"));
            } else {
                ((ParameterDesc)object).setQName(operationDesc.getReturnQName());
            }
            ((ParameterDesc)object).setTypeQName(operationDesc.getReturnType());
            ((ParameterDesc)object).setMode((byte)2);
            ((ParameterDesc)object).setIsReturn(true);
            ((ParameterDesc)object).setJavaType(operationDesc.getReturnClass());
            string2 = this.writePartToMessage(definition, message, false, (ParameterDesc)object);
            arrayList.add(string2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                serializable = (ParameterDesc)arrayList2.get(i);
                if (((ParameterDesc)serializable).isInHeader() || ((ParameterDesc)serializable).isOutHeader()) continue;
                string = this.writePartToMessage(definition, message, false, (ParameterDesc)serializable);
                arrayList.add(string);
            }
        }
        if (bl) {
            object = bindingOperation.getBindingOutput().getExtensibilityElements();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                if (!(e instanceof SOAPBodyImpl)) continue;
                serializable = (SOAPBodyImpl)e;
                ((SOAPBodyImpl)serializable).setParts(arrayList);
            }
        }
        return message;
    }

    protected Message writeFaultMessage(Definition definition, FaultDesc faultDesc) throws WSDLException, AxisFault {
        String string = faultDesc.getClassName();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        faultDesc.setName(string2);
        Message message = (Message)this.exceptionMsg.get(string);
        if (message == null) {
            message = definition.createMessage();
            QName qName = this.createMessageName(definition, string2);
            message.setQName(qName);
            message.setUndefined(false);
            ArrayList arrayList = faultDesc.getParameters();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                    this.writePartToMessage(definition, message, true, parameterDesc);
                }
            }
            this.exceptionMsg.put(string, message);
        }
        return message;
    }

    public String writePartToMessage(Definition definition, Message message, boolean bl, ParameterDesc parameterDesc) throws WSDLException, AxisFault {
        if (parameterDesc == null || parameterDesc.getJavaType() == Void.TYPE) {
            return null;
        }
        if (bl && parameterDesc.getMode() == 2) {
            return null;
        }
        if (!bl && parameterDesc.getMode() == 1) {
            return null;
        }
        Part part = definition.createPart();
        if (parameterDesc.getDocumentation() != null) {
            part.setDocumentationElement(this.createDocumentationElement(parameterDesc.getDocumentation()));
        }
        Class clazz = parameterDesc.getJavaType();
        if (parameterDesc.getMode() != 1 && !parameterDesc.getIsReturn()) {
            clazz = JavaUtils.getHolderValueType(clazz);
        }
        if (this.use == Use.ENCODED || this.style == Style.RPC) {
            QName qName = parameterDesc.getTypeQName();
            if (clazz != null) {
                qName = this.types.writeTypeAndSubTypeForPart(clazz, qName);
            }
            if (qName != null) {
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
            }
        } else if (this.use == Use.LITERAL) {
            Serializable serializable;
            QName qName = parameterDesc.getQName();
            if (parameterDesc.getTypeQName() == null) {
                log.warn(Messages.getMessage("registerTypeMappingFor01", parameterDesc.getJavaType().getName()));
                serializable = this.types.writeTypeForPart(parameterDesc.getJavaType(), null);
                if (serializable != null) {
                    parameterDesc.setTypeQName((QName)serializable);
                } else {
                    parameterDesc.setTypeQName(Constants.XSD_ANYTYPE);
                }
            }
            if (parameterDesc.getTypeQName().getNamespaceURI().equals("")) {
                parameterDesc.setTypeQName(new QName(this.intfNS, parameterDesc.getTypeQName().getLocalPart()));
            }
            if (parameterDesc.getQName().getNamespaceURI().equals("")) {
                qName = new QName(this.intfNS, parameterDesc.getQName().getLocalPart());
                parameterDesc.setQName(qName);
            }
            if ((serializable = (ArrayList)this.usedElementNames.get(qName.getNamespaceURI())) == null) {
                serializable = new ArrayList(1);
                this.usedElementNames.put(qName.getNamespaceURI(), serializable);
            } else if (((ArrayList)serializable).contains(qName.getLocalPart())) {
                qName = new QName(qName.getNamespaceURI(), JavaUtils.getUniqueValue((Collection)((Object)serializable), qName.getLocalPart()));
            }
            ((ArrayList)serializable).add(qName.getLocalPart());
            this.types.writeElementDecl(qName, parameterDesc.getJavaType(), parameterDesc.getTypeQName(), false, parameterDesc.getItemQName());
            part.setName(parameterDesc.getName());
            part.setElementName(qName);
            message.addPart(part);
        }
        return parameterDesc.getName();
    }

    protected QName createMessageName(Definition definition, String string) {
        QName qName = new QName(this.intfNS, string);
        int n = 1;
        while (definition.getMessage(qName) != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(n);
            qName = new QName(this.intfNS, stringBuffer.toString());
            ++n;
        }
        return qName;
    }

    protected void prettyDocumentToFile(Document document, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
        XMLUtils.PrettyDocumentToStream(document, fileOutputStream);
        fileOutputStream.close();
    }

    public Class getCls() {
        return this.cls;
    }

    public void setCls(Class clazz) {
        this.cls = clazz;
    }

    public void setClsSmart(Class clazz, String string) {
        if (clazz == null || string == null) {
            return;
        }
        if (string.lastIndexOf(47) > 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        } else if (string.lastIndexOf(92) > 0) {
            string = string.substring(string.lastIndexOf(92) + 1);
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Class<?> clazz2 = null;
        for (int i = 0; i < constructorArray.length && clazz2 == null; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || !classArray[0].isInterface() || classArray[0].getName() == null || !Types.getLocalNameFromFullName(classArray[0].getName()).equals(string)) continue;
            clazz2 = classArray[0];
        }
        if (clazz2 != null) {
            this.setCls(clazz2);
            if (this.implCls == null) {
                this.setImplCls(clazz);
            }
        } else {
            this.setCls(clazz);
        }
    }

    public void setCls(String string) throws ClassNotFoundException {
        this.cls = ClassUtils.forName(string);
    }

    public Class getImplCls() {
        return this.implCls;
    }

    public void setImplCls(Class clazz) {
        this.implCls = clazz;
    }

    public void setImplCls(String string) {
        try {
            this.implCls = ClassUtils.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String string) {
        this.intfNS = string;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String string) {
        this.implNS = string;
    }

    public Vector getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.allowedMethods == null) {
                this.allowedMethods = new Vector();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.allowedMethods.add(stringTokenizer.nextToken());
            }
        }
    }

    public void setAllowedMethods(Vector vector) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new Vector();
        }
        this.allowedMethods.addAll(vector);
    }

    public boolean getUseInheritedMethods() {
        return this.useInheritedMethods;
    }

    public void setUseInheritedMethods(boolean bl) {
        this.useInheritedMethods = bl;
    }

    public void setDisallowedMethods(Vector vector) {
        if (this.disallowedMethods == null) {
            this.disallowedMethods = new Vector();
        }
        this.disallowedMethods.addAll(vector);
    }

    public void setDisallowedMethods(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.disallowedMethods == null) {
                this.disallowedMethods = new Vector();
            }
            this.disallowedMethods = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.disallowedMethods.add(stringTokenizer.nextToken());
            }
        }
    }

    public Vector getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setStopClasses(ArrayList arrayList) {
        if (this.stopClasses == null) {
            this.stopClasses = new ArrayList();
        }
        this.stopClasses.addAll(arrayList);
    }

    public void setStopClasses(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.stopClasses == null) {
                this.stopClasses = new ArrayList();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.stopClasses.add(stringTokenizer.nextToken());
            }
        }
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String string) {
        this.inputWSDL = string;
    }

    public String getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(String string) {
        this.inputSchema = string;
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String string) {
        this.locationUrl = string;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String string) {
        this.importUrl = string;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String string) {
        this.servicePortName = string;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String string) {
        this.serviceElementName = string;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String string) {
        this.portTypeName = string;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String string) {
        this.bindingName = string;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String string) {
        this.targetService = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return (TypeMapping)this.tmr.getDefaultTypeMapping();
    }

    public void setDefaultTypeMapping(TypeMapping typeMapping) {
        this.tmr.registerDefault(typeMapping);
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.tmr = typeMappingRegistry;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.setStyle(Style.getStyle(string));
    }

    public void setStyle(Style style) {
        this.style = style;
        if (this.style.equals(Style.WRAPPED)) {
            this.setUse(Use.LITERAL);
        }
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(String string) {
        this.use = Use.getUse(string);
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public void setMode(int n) {
        if (n == 0) {
            this.setStyle(Style.RPC);
            this.setUse(Use.ENCODED);
        } else if (n == 1) {
            this.setStyle(Style.DOCUMENT);
            this.setUse(Use.LITERAL);
        } else if (n == 2) {
            this.setStyle(Style.WRAPPED);
            this.setUse(Use.LITERAL);
        }
    }

    public int getMode() {
        if (this.style == Style.RPC) {
            return 0;
        }
        if (this.style == Style.DOCUMENT) {
            return 1;
        }
        if (this.style == Style.WRAPPED) {
            return 2;
        }
        return -1;
    }

    public ServiceDesc getServiceDesc() {
        return this.serviceDesc;
    }

    public void setServiceDesc(ServiceDesc serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    public Class[] getExtraClasses() {
        return this.extraClasses;
    }

    public void setExtraClasses(Class[] classArray) {
        this.extraClasses = classArray;
    }

    public void setExtraClasses(String string) throws ClassNotFoundException {
        Class clazz;
        Class[] classArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (string != null) {
            classArray = new StringTokenizer(string, " ,");
            while (classArray.hasMoreTokens()) {
                String string2 = classArray.nextToken();
                clazz = ClassUtils.forName(string2);
                arrayList.add(clazz);
            }
        }
        if (this.extraClasses != null) {
            classArray = new Class[arrayList.size() + this.extraClasses.length];
            for (int i = 0; i < this.extraClasses.length; ++i) {
                classArray[i] = clazz = this.extraClasses[i];
            }
        } else {
            classArray = new Class[arrayList.size()];
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            classArray[i] = clazz = (Class)arrayList.get(i);
        }
        this.extraClasses = classArray;
    }

    public void setEmitAllTypes(boolean bl) {
        this.emitAllTypes = bl;
    }

    public String getVersionMessage() {
        return this.versionMessage;
    }

    public void setVersionMessage(String string) {
        this.versionMessage = string;
    }

    public HashMap getQName2ClassMap() {
        return this.qName2ClassMap;
    }
}

