/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.gen;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.CLUtil;
import org.apache.axis.utils.DefaultAuthenticator;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Parser;

public class WSDL2 {
    protected static final int DEBUG_OPT = 68;
    protected static final int HELP_OPT = 104;
    protected static final int NETWORK_TIMEOUT_OPT = 79;
    protected static final int NOIMPORTS_OPT = 110;
    protected static final int VERBOSE_OPT = 118;
    protected static final int NOWRAP_OPT = 87;
    protected static final int QUIET_OPT = 113;
    protected CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, Messages.getMessage("optionHelp00")), new CLOptionDescriptor("verbose", 8, 118, Messages.getMessage("optionVerbose00")), new CLOptionDescriptor("noImports", 8, 110, Messages.getMessage("optionImport00")), new CLOptionDescriptor("timeout", 2, 79, Messages.getMessage("optionTimeout00")), new CLOptionDescriptor("Debug", 8, 68, Messages.getMessage("optionDebug00")), new CLOptionDescriptor("noWrapped", 8, 87, Messages.getMessage("optionNoWrap00")), new CLOptionDescriptor("quiet", 8, 113, Messages.getMessage("optionQuiet"))};
    protected String wsdlURI = null;
    protected Parser parser = this.createParser();

    protected WSDL2() {
    }

    protected Parser createParser() {
        return new Parser();
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void addOptions(CLOptionDescriptor[] cLOptionDescriptorArray) {
        if (cLOptionDescriptorArray != null && cLOptionDescriptorArray.length > 0) {
            CLOptionDescriptor[] cLOptionDescriptorArray2 = new CLOptionDescriptor[this.options.length + cLOptionDescriptorArray.length];
            System.arraycopy(this.options, 0, cLOptionDescriptorArray2, 0, this.options.length);
            System.arraycopy(cLOptionDescriptorArray, 0, cLOptionDescriptorArray2, this.options.length, cLOptionDescriptorArray.length);
            this.options = cLOptionDescriptorArray2;
        }
    }

    protected void removeOption(String string) {
        int n = -1;
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].getName().equals(string)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[this.options.length - 1];
            System.arraycopy(this.options, 0, cLOptionDescriptorArray, 0, n);
            if (n < cLOptionDescriptorArray.length) {
                System.arraycopy(this.options, n + 1, cLOptionDescriptorArray, n, cLOptionDescriptorArray.length - n);
            }
            this.options = cLOptionDescriptorArray;
        }
    }

    protected void parseOption(CLOption cLOption) {
        switch (cLOption.getId()) {
            case 0: {
                if (this.wsdlURI != null) {
                    System.out.println(Messages.getMessage("w2jDuplicateWSDLURI00", this.wsdlURI, cLOption.getArgument()));
                    this.printUsage();
                }
                this.wsdlURI = cLOption.getArgument();
                break;
            }
            case 104: {
                this.printUsage();
                break;
            }
            case 110: {
                this.parser.setImports(false);
                break;
            }
            case 79: {
                String string = cLOption.getArgument();
                long l = Long.parseLong(string);
                if (l > 0L) {
                    l *= 1000L;
                }
                this.parser.setTimeout(l);
                break;
            }
            case 118: {
                this.parser.setVerbose(true);
                break;
            }
            case 68: {
                this.parser.setDebug(true);
                break;
            }
            case 113: {
                this.parser.setQuiet(true);
                break;
            }
            case 87: {
                this.parser.setNowrap(true);
            }
        }
    }

    protected void validateOptions() {
        if (this.wsdlURI == null) {
            System.out.println(Messages.getMessage("w2jMissingWSDLURI00"));
            this.printUsage();
        }
        if (this.parser.isQuiet()) {
            if (this.parser.isVerbose()) {
                System.out.println(Messages.getMessage("exclusiveQuietVerbose"));
                this.printUsage();
            }
            if (this.parser.isDebug()) {
                System.out.println(Messages.getMessage("exclusiveQuietDebug"));
                this.printUsage();
            }
        }
        this.checkForAuthInfo(this.wsdlURI);
        Authenticator.setDefault(new DefaultAuthenticator(this.parser.getUsername(), this.parser.getPassword()));
    }

    private void checkForAuthInfo(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String string2 = uRL.getUserInfo();
        if (string2 != null) {
            int n = string2.indexOf(58);
            if (n >= 0) {
                this.parser.setUsername(string2.substring(0, n));
                this.parser.setPassword(string2.substring(n + 1));
            } else {
                this.parser.setUsername(string2);
            }
        }
    }

    protected void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Messages.getMessage("usage00", "java " + this.getClass().getName() + " [options] WSDL-URI")).append(string);
        stringBuffer.append(Messages.getMessage("options00")).append(string);
        stringBuffer.append(CLUtil.describeOptions(this.options).toString());
        System.out.println(stringBuffer.toString());
        System.exit(1);
    }

    protected void run(String[] stringArray) {
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, this.options);
        if (null != cLArgsParser.getErrorString()) {
            System.err.println(Messages.getMessage("error01", cLArgsParser.getErrorString()));
            this.printUsage();
        }
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        try {
            for (int i = 0; i < n; ++i) {
                this.parseOption((CLOption)vector.get(i));
            }
            this.validateOptions();
            this.parser.run(this.wsdlURI);
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        WSDL2 wSDL2 = new WSDL2();
        wSDL2.run(stringArray);
    }
}

