/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.ContainedEntry;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBeanHelperWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class JavaBeanWriter
extends JavaClassWriter {
    private TypeEntry type;
    private Vector elements;
    private Vector attributes;
    private TypeEntry extendType;
    protected JavaBeanHelperWriter helper;
    protected Vector names = new Vector();
    protected ArrayList simpleValueTypes = new ArrayList();
    protected Set enumerationTypes = new HashSet();
    protected PrintWriter pw;
    protected boolean enableDefaultConstructor = true;
    protected boolean enableFullConstructor = false;
    protected boolean enableSimpleConstructors = false;
    protected boolean enableToString = false;
    protected boolean enableSetters = true;
    protected boolean enableGetters = true;
    protected boolean enableEquals = true;
    protected boolean enableHashCode = true;
    protected boolean enableMemberFields = true;
    protected boolean isAny = false;
    protected boolean isMixed = false;

    protected JavaBeanWriter(Emitter emitter, TypeEntry typeEntry, Vector vector, TypeEntry typeEntry2, Vector vector2, JavaWriter javaWriter) {
        super(emitter, typeEntry.getName(), "complexType");
        this.type = typeEntry;
        this.elements = vector;
        this.attributes = vector2;
        this.extendType = typeEntry2;
        this.helper = (JavaBeanHelperWriter)javaWriter;
        if (typeEntry.isSimpleType()) {
            this.enableSimpleConstructors = true;
            this.enableToString = true;
        } else if (null != typeEntry2 && null != SchemaUtils.getComplexElementRestrictionBase(typeEntry.getNode(), emitter.getSymbolTable())) {
            this.enableMemberFields = false;
            this.enableGetters = false;
            this.enableSetters = false;
            this.enableEquals = false;
            this.enableHashCode = false;
        }
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        this.writeHeaderComments(printWriter);
        this.writePackage(printWriter);
        try {
            String string = SchemaUtils.getAnnotationDocumentation(this.type.getNode());
            string = this.getJavadocDescriptionPart(string, false);
            if (string != null && string.trim().length() > 0) {
                printWriter.println();
                printWriter.println("/**");
                printWriter.println(string);
                printWriter.println(" */");
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        printWriter.println(this.getClassModifiers() + this.getClassText() + this.getClassName() + ' ' + this.getExtendsText() + this.getImplementsText() + "{");
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.pw = printWriter;
        if (this.enableMemberFields) {
            this.writeMemberFields();
        }
        if (this.enableDefaultConstructor) {
            this.writeDefaultConstructor();
        }
        if (this.enableFullConstructor) {
            this.writeFullConstructor();
        }
        if (this.enableSimpleConstructors) {
            this.writeSimpleConstructors();
        }
        if (!this.enableFullConstructor && !this.enableSimpleConstructors && this.enableMemberFields) {
            this.writeMinimalConstructor();
        }
        if (this.enableToString) {
            this.writeToStringMethod();
        }
        this.writeAccessMethods();
        if (this.enableEquals) {
            this.writeEqualsMethod();
        }
        if (this.enableHashCode) {
            this.writeHashCodeMethod();
        }
        if (!this.emitter.isHelperWanted()) {
            this.helper.setPrintWriter(printWriter);
        }
        this.helper.generate();
    }

    protected void preprocess() {
        String string;
        String string2;
        Object object;
        int n;
        if (this.elements != null) {
            for (n = 0; n < this.elements.size(); ++n) {
                object = (ElementDecl)this.elements.get(n);
                string2 = ((ContainedEntry)object).getType().getName();
                if (((ElementDecl)object).getAnyElement()) {
                    string2 = "org.apache.axis.message.MessageElement []";
                    string = "_any";
                    this.isAny = true;
                } else {
                    string = ((SymTabEntry)object).getName();
                    if (((ContainedEntry)object).getType().getUnderlTypeNillable() || ((ElementDecl)object).getNillable() && ((ElementDecl)object).getMaxOccursIsUnbounded()) {
                        string2 = Utils.getWrapperType(((ContainedEntry)object).getType());
                    } else if (((ElementDecl)object).getMinOccursIs0() && ((ElementDecl)object).getMaxOccursIsExactlyOne() || ((ElementDecl)object).getNillable() || ((ElementDecl)object).getOptional()) {
                        string2 = Utils.getWrapperType(string2);
                    }
                }
                string = JavaUtils.getUniqueValue(this.helper.reservedPropNames, string);
                this.names.add(string2);
                this.names.add(string);
                if (this.type.isSimpleType() && (string.endsWith("Value") || string.equals("_value"))) {
                    this.simpleValueTypes.add(string2);
                }
                if (null == Utils.getEnumerationBaseAndValues(((ContainedEntry)object).getType().getNode(), this.emitter.getSymbolTable())) continue;
                this.enumerationTypes.add(string2);
            }
        }
        if (this.enableMemberFields && SchemaUtils.isMixed(this.type.getNode())) {
            this.isMixed = true;
            if (!this.isAny) {
                this.names.add("org.apache.axis.message.MessageElement []");
                this.names.add("_any");
            }
        }
        if (this.attributes != null) {
            for (n = 0; n < this.attributes.size(); ++n) {
                object = (ContainedAttribute)this.attributes.get(n);
                string2 = ((ContainedEntry)object).getType().getName();
                string = ((SymTabEntry)object).getName();
                if (((ContainedAttribute)object).getOptional()) {
                    string2 = Utils.getWrapperType(string2);
                }
                string = JavaUtils.getUniqueValue(this.helper.reservedPropNames, string);
                this.names.add(string2);
                this.names.add(string);
                if (this.type.isSimpleType() && (string.endsWith("Value") || string.equals("_value"))) {
                    this.simpleValueTypes.add(string2);
                }
                if (null == Utils.getEnumerationBaseAndValues(((ContainedEntry)object).getType().getNode(), this.emitter.getSymbolTable())) continue;
                this.enumerationTypes.add(string2);
            }
        }
        if (this.extendType != null && this.extendType.getDimensions().equals("[]")) {
            String string3 = this.extendType.getName();
            object = this.extendType.getQName().getLocalPart();
            string2 = Utils.xmlNameToJava((String)object);
            this.names.add(string3);
            this.names.add(string2);
        }
        block2: for (int i = 1; i < this.names.size(); i += 2) {
            int n2 = 2;
            string2 = (String)this.names.elementAt(i);
            if (i >= this.names.size() - 2) continue;
            int n3 = this.names.indexOf(string2, i + 1);
            while (n3 > 0) {
                this.names.set(n3, this.names.get(n3) + Integer.toString(n2));
                ++n2;
                if (i >= this.names.size() - 2) continue block2;
                n3 = this.names.indexOf(string2, n3 + 1);
            }
        }
    }

    protected String getBinaryTypeEncoderName(String string) {
        TypeEntry typeEntry = this.getElementDecl(string);
        if (typeEntry != null) {
            String string2 = typeEntry.getQName().getLocalPart();
            if (string2.equals("base64Binary")) {
                return "org.apache.axis.encoding.Base64";
            }
            if (string2.equals("hexBinary")) {
                return "org.apache.axis.types.HexBinary";
            }
            throw new RuntimeException("Unknown binary type " + string2 + " for element " + string);
        }
        throw new RuntimeException("Unknown element " + string);
    }

    protected TypeEntry getElementDecl(String string) {
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementDecl elementDecl = (ElementDecl)this.elements.get(i);
                String string2 = elementDecl.getAnyElement() ? "_any" : elementDecl.getName();
                if (!string2.equals(string)) continue;
                return elementDecl.getType();
            }
        }
        return null;
    }

    protected String getClassModifiers() {
        Node node = this.type.getNode();
        if (node != null && JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "abstract"))) {
            return super.getClassModifiers() + "abstract ";
        }
        return super.getClassModifiers();
    }

    protected String getExtendsText() {
        String string = "";
        if (this.extendType != null && !this.type.isSimpleType() && this.extendType.getDimensions().length() == 0) {
            string = " extends " + this.extendType.getName() + " ";
        }
        return string;
    }

    protected String getImplementsText() {
        String string = " implements java.io.Serializable";
        if (this.type.isSimpleType()) {
            string = string + ", org.apache.axis.encoding.SimpleType";
        }
        this.preprocess();
        if (this.isAny) {
            string = string + ", org.apache.axis.encoding.AnyContentType";
        }
        if (this.isMixed) {
            string = string + ", org.apache.axis.encoding.MixedContentType";
        }
        string = string + " ";
        return string;
    }

    protected void writeMemberFields() {
        if (this.isUnion()) {
            this.pw.println("    private java.lang.String _value;");
            return;
        }
        for (int i = 0; i < this.names.size(); i += 2) {
            Object object;
            String string = "";
            if (this.elements != null && this.elements != null && i < this.elements.size() * 2) {
                object = (ElementDecl)this.elements.get(i / 2);
                string = ((ElementDecl)object).getDocumentation();
            }
            object = (String)this.names.get(i);
            String string2 = (String)this.names.get(i + 1);
            if (string != null && string.trim().length() > 0) {
                String string3 = this.getJavadocDescriptionPart(string, false).substring(3);
                this.pw.println("    /** " + string3.trim() + " */");
            }
            this.pw.print("    private " + (String)object + " " + string2 + ";");
            if (this.elements == null || i >= this.elements.size() * 2) {
                this.pw.println("  // attribute");
                continue;
            }
            this.pw.println();
        }
        this.pw.println();
    }

    protected void writeDefaultConstructor() {
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        this.pw.println();
    }

    protected void writeMinimalConstructor() {
        String string;
        int n;
        if (this.isUnion() || this.names.size() == 0) {
            return;
        }
        this.pw.println("    public " + this.className + "(");
        for (n = 0; n < this.names.size(); n += 2) {
            string = (String)this.names.get(n);
            String string2 = (String)this.names.get(n + 1);
            this.pw.print("           " + string + " " + string2);
            if (n >= this.names.size() - 2) {
                this.pw.println(") {");
                continue;
            }
            this.pw.println(",");
        }
        for (n = 0; n < this.names.size(); n += 2) {
            string = (String)this.names.get(n + 1);
            this.pw.println("           this." + string + " = " + string + ";");
            if (n >= this.names.size() - 2) break;
        }
        this.pw.println("    }");
        this.pw.println();
    }

    protected void writeFullConstructor() {
        int n;
        if (this.type.isSimpleType()) {
            return;
        }
        Vector<TypeEntry> vector = new Vector<TypeEntry>();
        vector.add(this.type);
        TypeEntry typeEntry = this.extendType;
        while (typeEntry != null) {
            vector.add(typeEntry);
            typeEntry = SchemaUtils.getComplexElementExtensionBase(typeEntry.getNode(), this.emitter.getSymbolTable());
        }
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        for (n = vector.size() - 1; n >= 0; --n) {
            Vector vector4;
            Vector vector5;
            TypeEntry typeEntry2 = (TypeEntry)vector.elementAt(n);
            String string = "";
            if (n > 0) {
                string = "_" + Utils.xmlNameToJava(typeEntry2.getQName().getLocalPart()) + "_";
            }
            if ((vector5 = typeEntry2.getContainedAttributes()) != null) {
                for (int i = 0; i < vector5.size(); ++i) {
                    ContainedAttribute containedAttribute = (ContainedAttribute)vector5.get(i);
                    vector2.add(containedAttribute.getType().getName());
                    vector3.add(JavaUtils.getUniqueValue(this.helper.reservedPropNames, containedAttribute.getName()));
                }
            }
            if ((vector4 = typeEntry2.getContainedElements()) == null) continue;
            for (int i = 0; i < vector4.size(); ++i) {
                ElementDecl elementDecl = (ElementDecl)vector4.get(i);
                vector2.add(elementDecl.getType().getName());
                vector3.add(JavaUtils.getUniqueValue(this.helper.reservedPropNames, elementDecl.getName()));
            }
        }
        n = vector2.size() - this.names.size() / 2;
        if (vector2.size() > 0) {
            int n2;
            this.pw.println("    public " + this.className + "(");
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                this.pw.print("           " + vector2.elementAt(n2) + " " + vector3.elementAt(n2));
                if (n2 + 1 < vector2.size()) {
                    this.pw.println(",");
                    continue;
                }
                this.pw.println(") {");
            }
            if (this.extendType != null && n > 0) {
                this.pw.println("        super(");
                for (n2 = 0; n2 < n; ++n2) {
                    this.pw.print("            " + vector3.elementAt(n2));
                    if (n2 + 1 < n) {
                        this.pw.println(",");
                        continue;
                    }
                    this.pw.println(");");
                }
            }
            for (n2 = n; n2 < vector3.size(); ++n2) {
                this.pw.println("        this." + vector3.elementAt(n2) + " = " + vector3.elementAt(n2) + ";");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeSimpleConstructors() {
        if (this.simpleValueTypes.size() == 0) {
            return;
        }
        this.pw.println("    // " + Messages.getMessage("needStringCtor"));
        if (this.isUnion() || this.simpleValueTypes.get(0).equals("java.lang.String")) {
            this.pw.println("    public " + this.className + "(java.lang.String _value) {");
            this.pw.println("        this._value = _value;");
            this.pw.println("    }");
            int n = 0;
            for (String string : this.simpleValueTypes) {
                if (string.equals("java.lang.String")) {
                    n += 2;
                    continue;
                }
                String string2 = "_value";
                if (this.isUnion()) {
                    String string3 = (String)this.names.get(n + 1);
                    string2 = Utils.capitalizeFirstChar(string3);
                }
                this.pw.println("    public " + this.className + "(" + string + " _value) {");
                this.pw.println("        set" + string2 + "(_value);");
                this.pw.println("    }");
                this.pw.println();
                n += 2;
            }
        } else if (this.simpleValueTypes.size() == 1) {
            this.pw.println("    public " + this.className + "(" + this.simpleValueTypes.get(0) + " _value) {");
            this.pw.println("        this._value = _value;");
            this.pw.println("    }");
            this.pw.println("    public " + this.className + "(java.lang.String _value) {");
            this.writeSimpleTypeGetter((String)this.simpleValueTypes.get(0), null, "this._value =");
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeSimpleTypeGetter(String string, String string2, String string3) {
        String string4 = JavaUtils.getWrapper(string);
        if (string4 != null) {
            this.pw.println("        " + string3 + " new " + string4 + "(_value)." + string + "Value();");
        } else if (string.equals("byte[]")) {
            String string5 = this.getBinaryTypeEncoderName("_value");
            this.pw.println("        " + string3 + " " + string5 + ".decode(_value);");
        } else if (string.equals("org.apache.axis.types.URI")) {
            this.pw.println("        try {");
            this.pw.println("            " + string3 + " new org.apache.axis.types.URI(_value);");
            this.pw.println("        }");
            this.pw.println("        catch (org.apache.axis.types.URI.MalformedURIException mue) {");
            this.pw.println("            throw new java.lang.RuntimeException(mue.toString());");
            this.pw.println("       }");
        } else if (string.equals("java.util.Date")) {
            this.pw.println("        try {");
            this.pw.println("            " + string3 + " (java.text.DateFormat.getDateTimeInstance()).parse(_value);");
            this.pw.println("        }");
            this.pw.println("        catch (java.text.ParseException e){");
            this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
            this.pw.println("        }");
        } else if (string.equals("java.util.Calendar")) {
            this.pw.println("        java.util.Calendar cal =");
            this.pw.println("            (java.util.Calendar) new org.apache.axis.encoding.ser.CalendarDeserializer(");
            this.pw.println("                java.lang.String.class, org.apache.axis.Constants.XSD_STRING).makeValue(_value);");
            this.pw.println("        " + string3 + " cal;");
        } else if (this.enumerationTypes.contains(string)) {
            this.pw.println("        " + string3 + " " + string + ".fromString(_value);");
        } else {
            this.pw.println("        " + string3 + " new " + string + "(_value);");
        }
    }

    private boolean isUnion() {
        return this.simpleValueTypes.size() > 1;
    }

    protected void writeToStringMethod() {
        if (this.simpleValueTypes.size() == 0) {
            return;
        }
        this.pw.println("    // " + Messages.getMessage("needToString"));
        this.pw.println("    public java.lang.String toString() {");
        if (this.isUnion() || this.simpleValueTypes.get(0).equals("java.lang.String")) {
            this.pw.println("        return _value;");
        } else {
            String string = JavaUtils.getWrapper((String)this.simpleValueTypes.get(0));
            if (string != null) {
                this.pw.println("        return new " + string + "(_value).toString();");
            } else {
                String string2 = (String)this.simpleValueTypes.get(0);
                if (string2.equals("byte[]")) {
                    String string3 = this.getBinaryTypeEncoderName("_value");
                    this.pw.println("        return _value == null ? null : " + string3 + ".encode(_value);");
                } else if (string2.equals("java.util.Calendar")) {
                    this.pw.println("        return _value == null ? null : new org.apache.axis.encoding.ser.CalendarSerializer().getValueAsString(_value, null);");
                } else {
                    this.pw.println("        return _value == null ? null : _value.toString();");
                }
            }
        }
        this.pw.println("    }");
        this.pw.println();
    }

    protected void writeSimpleTypeSetter(String string) {
        String string2 = JavaUtils.getWrapper(string);
        if (string2 != null) {
            this.pw.println("        this._value = new " + string2 + "(_value).toString();");
        } else if (string.equals("byte[]")) {
            String string3 = this.getBinaryTypeEncoderName("_value");
            this.pw.println("        this._value = _value == null ? null : " + string3 + ".encode(_value);");
        } else if (string.equals("java.util.Calendar")) {
            this.pw.println("        this._value = _value == null ? null : new org.apache.axis.encoding.ser.CalendarSerializer().getValueAsString(_value, null);");
        } else {
            this.pw.println("        this._value = _value == null ? null : _value.toString();");
        }
    }

    protected void writeAccessMethods() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.names.size()) {
            Object object;
            String string;
            Object object2;
            String string2 = (String)this.names.get(n2);
            String string3 = (String)this.names.get(n2 + 1);
            String string4 = Utils.capitalizeFirstChar(string3);
            String string5 = "";
            if (this.elements != null && this.elements != null && n2 < this.elements.size() * 2) {
                object2 = (ElementDecl)this.elements.get(n2 / 2);
                string5 = ((ElementDecl)object2).getDocumentation();
            }
            object2 = "get";
            if (string2.equals("boolean")) {
                object2 = "is";
            }
            if ((string = this.getJavadocDescriptionPart(string5, false)).length() > 3) {
                string = string.substring(2);
            }
            if (this.enableGetters) {
                try {
                    this.pw.println();
                    this.pw.println("    /**");
                    this.pw.println("     * Gets the " + string3 + " value for this " + this.getClassName() + ".");
                    this.pw.println("     * ");
                    this.pw.println("     * @return " + string3 + string);
                    this.pw.println("     */");
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
                this.pw.println("    public " + string2 + " " + (String)object2 + string4 + "() {");
                if (this.isUnion()) {
                    this.writeSimpleTypeGetter(string2, string3, "return");
                } else {
                    this.pw.println("        return " + string3 + ";");
                }
                this.pw.println("    }");
                this.pw.println();
            }
            if (this.enableSetters) {
                try {
                    object = this.isUnion() ? "_value" : string3;
                    this.pw.println();
                    this.pw.println("    /**");
                    this.pw.println("     * Sets the " + (String)object + " value for this " + this.getClassName() + ".");
                    this.pw.println("     * ");
                    this.pw.println("     * @param " + (String)object + string);
                    this.pw.println("     */");
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
                if (this.isUnion()) {
                    this.pw.println("    public void set" + string4 + "(" + string2 + " _value) {");
                    this.writeSimpleTypeSetter(string2);
                } else {
                    this.pw.println("    public void set" + string4 + "(" + string2 + " " + string3 + ") {");
                    this.pw.println("        this." + string3 + " = " + string3 + ";");
                }
                this.pw.println("    }");
                this.pw.println();
            }
            if (this.elements != null && n < this.elements.size() && ((ContainedEntry)(object = (ElementDecl)this.elements.get(n))).getType().getQName().getLocalPart().indexOf("[") > 0) {
                String string6 = string2.substring(0, string2.lastIndexOf("["));
                if (this.enableGetters) {
                    this.pw.println("    public " + string6 + " " + (String)object2 + string4 + "(int i) {");
                    this.pw.println("        return this." + string3 + "[i];");
                    this.pw.println("    }");
                    this.pw.println();
                }
                if (this.enableSetters) {
                    this.pw.println("    public void set" + string4 + "(int i, " + string6 + " _value) {");
                    this.pw.println("        this." + string3 + "[i] = _value;");
                    this.pw.println("    }");
                    this.pw.println();
                }
            }
            n2 += 2;
            ++n;
        }
    }

    protected void writeEqualsMethod() {
        this.pw.println("    private java.lang.Object __equalsCalc = null;");
        this.pw.println("    public synchronized boolean equals(java.lang.Object obj) {");
        this.pw.println("        if (!(obj instanceof " + this.className + ")) return false;");
        this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
        this.pw.println("        if (obj == null) return false;");
        this.pw.println("        if (this == obj) return true;");
        this.pw.println("        if (__equalsCalc != null) {");
        this.pw.println("            return (__equalsCalc == obj);");
        this.pw.println("        }");
        this.pw.println("        __equalsCalc = obj;");
        String string = "true";
        if (this.extendType != null && !this.type.isSimpleType()) {
            string = "super.equals(obj)";
        }
        this.pw.println("        boolean _equals;");
        if (this.names.size() == 0) {
            this.pw.println("        _equals = " + string + ";");
        } else if (this.isUnion()) {
            this.pw.println("        _equals = " + string + " && " + " this.toString().equals(obj.toString());");
        } else {
            this.pw.println("        _equals = " + string + " && ");
            for (int i = 0; i < this.names.size(); i += 2) {
                String string2 = (String)this.names.get(i);
                String string3 = (String)this.names.get(i + 1);
                String string4 = "get";
                if (string2.equals("boolean")) {
                    string4 = "is";
                }
                if (string2.equals("int") || string2.equals("long") || string2.equals("short") || string2.equals("float") || string2.equals("double") || string2.equals("boolean") || string2.equals("byte")) {
                    this.pw.print("            this." + string3 + " == other." + string4 + Utils.capitalizeFirstChar(string3) + "()");
                } else if (string2.indexOf("[") >= 0) {
                    this.pw.println("            ((this." + string3 + "==null && other." + string4 + Utils.capitalizeFirstChar(string3) + "()==null) || ");
                    this.pw.println("             (this." + string3 + "!=null &&");
                    this.pw.print("              java.util.Arrays.equals(this." + string3 + ", other." + string4 + Utils.capitalizeFirstChar(string3) + "())))");
                } else {
                    this.pw.println("            ((this." + string3 + "==null && other." + string4 + Utils.capitalizeFirstChar(string3) + "()==null) || ");
                    this.pw.println("             (this." + string3 + "!=null &&");
                    this.pw.print("              this." + string3 + ".equals(other." + string4 + Utils.capitalizeFirstChar(string3) + "())))");
                }
                if (i == this.names.size() - 2) {
                    this.pw.println(";");
                    continue;
                }
                this.pw.println(" &&");
            }
        }
        this.pw.println("        __equalsCalc = null;");
        this.pw.println("        return _equals;");
        this.pw.println("    }");
        this.pw.println("");
    }

    protected void writeHashCodeMethod() {
        this.pw.println("    private boolean __hashCodeCalc = false;");
        this.pw.println("    public synchronized int hashCode() {");
        this.pw.println("        if (__hashCodeCalc) {");
        this.pw.println("            return 0;");
        this.pw.println("        }");
        this.pw.println("        __hashCodeCalc = true;");
        String string = "1";
        if (this.extendType != null && !this.type.isSimpleType()) {
            string = "super.hashCode()";
        }
        this.pw.println("        int _hashCode = " + string + ";");
        if (this.isUnion()) {
            this.pw.println("        if (this._value != null) {");
            this.pw.println("            _hashCode += this._value.hashCode();");
            this.pw.println("        }");
        }
        for (int i = 0; !this.isUnion() && i < this.names.size(); i += 2) {
            String string2 = (String)this.names.get(i);
            String string3 = (String)this.names.get(i + 1);
            String string4 = "get";
            if (string2.equals("boolean")) {
                string4 = "is";
            }
            if (string2.equals("int") || string2.equals("short") || string2.equals("byte")) {
                this.pw.println("        _hashCode += " + string4 + Utils.capitalizeFirstChar(string3) + "();");
                continue;
            }
            if (string2.equals("boolean")) {
                this.pw.println("        _hashCode += (" + string4 + Utils.capitalizeFirstChar(string3) + "() ? Boolean.TRUE : Boolean.FALSE).hashCode();");
                continue;
            }
            if (string2.equals("long")) {
                this.pw.println("        _hashCode += new Long(" + string4 + Utils.capitalizeFirstChar(string3) + "()).hashCode();");
                continue;
            }
            if (string2.equals("float")) {
                this.pw.println("        _hashCode += new Float(" + string4 + Utils.capitalizeFirstChar(string3) + "()).hashCode();");
                continue;
            }
            if (string2.equals("double")) {
                this.pw.println("        _hashCode += new Double(" + string4 + Utils.capitalizeFirstChar(string3) + "()).hashCode();");
                continue;
            }
            if (string2.indexOf("[") >= 0) {
                this.pw.println("        if (" + string4 + Utils.capitalizeFirstChar(string3) + "() != null) {");
                this.pw.println("            for (int i=0;");
                this.pw.println("                 i<java.lang.reflect.Array.getLength(" + string4 + Utils.capitalizeFirstChar(string3) + "());");
                this.pw.println("                 i++) {");
                this.pw.println("                java.lang.Object obj = java.lang.reflect.Array.get(" + string4 + Utils.capitalizeFirstChar(string3) + "(), i);");
                this.pw.println("                if (obj != null &&");
                this.pw.println("                    !obj.getClass().isArray()) {");
                this.pw.println("                    _hashCode += obj.hashCode();");
                this.pw.println("                }");
                this.pw.println("            }");
                this.pw.println("        }");
                continue;
            }
            this.pw.println("        if (" + string4 + Utils.capitalizeFirstChar(string3) + "() != null) {");
            this.pw.println("            _hashCode += " + string4 + Utils.capitalizeFirstChar(string3) + "().hashCode();");
            this.pw.println("        }");
        }
        this.pw.println("        __hashCodeCalc = false;");
        this.pw.println("        return _hashCode;");
        this.pw.println("    }");
        this.pw.println("");
    }

    public void generate() throws IOException {
        String string = this.getPackage() + "." + this.getClassName();
        if (this.emitter.isDeploy() && this.emitter.doesExist(string)) {
            if (this.emitter.isHelperWanted()) {
                this.helper.generate();
            }
        } else {
            super.generate();
        }
    }
}

