/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Scope;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.commons.logging.Log;

public class JavaDeployWriter
extends JavaWriter {
    protected static Log log = LogFactory.getLog(JavaDeployWriter.class.getName());
    protected Definition definition;
    protected SymbolTable symbolTable;
    protected Emitter emitter;
    Use use = Use.DEFAULT;
    private static final Map mepStrings = new HashMap();

    public JavaDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "deploy");
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        if (this.emitter.isServerSide()) {
            super.generate();
        }
    }

    protected String getFileName() {
        String string = this.emitter.getNamespaces().getAsDir(this.definition.getTargetNamespace());
        return string + "deploy.wsdd";
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        printWriter.println(Messages.getMessage("deploy00"));
        printWriter.println(Messages.getMessage("deploy02"));
        printWriter.println(Messages.getMessage("deploy03"));
        printWriter.println(Messages.getMessage("deploy05"));
        printWriter.println(Messages.getMessage("deploy06"));
        printWriter.println(Messages.getMessage("deploy07"));
        printWriter.println(Messages.getMessage("deploy09"));
        printWriter.println();
        printWriter.println("<deployment");
        printWriter.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\"");
        printWriter.println("    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">");
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeDeployServices(printWriter);
        printWriter.println("</deployment>");
    }

    protected void writeDeployServices(PrintWriter printWriter) throws IOException {
        Map map = this.definition.getServices();
        for (Service service : map.values()) {
            printWriter.println();
            printWriter.println("  <!-- " + Messages.getMessage("wsdlService00", service.getQName().getLocalPart()) + " -->");
            printWriter.println();
            for (Port port : service.getPorts().values()) {
                BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port.getBinding().getQName());
                if (bindingEntry.getBindingType() != 0) continue;
                this.writeDeployPort(printWriter, port, service, bindingEntry);
            }
        }
    }

    protected void writeDeployTypes(PrintWriter printWriter, Binding binding, boolean bl, boolean bl2, Use use) throws IOException {
        Object object;
        printWriter.println();
        if (bl2) {
            object = binding.getQName();
            this.writeTypeMapping(printWriter, ((QName)object).getNamespaceURI(), "DataHandler", "javax.activation.DataHandler", "org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory", "org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory", use.getEncoding());
        }
        object = this.symbolTable.getTypeIndex();
        Collection collection = object.values();
        for (TypeEntry typeEntry : collection) {
            String string;
            String string2;
            boolean bl3 = true;
            if (!Utils.shouldEmit(typeEntry)) {
                bl3 = false;
            }
            if (!bl3) continue;
            String string3 = typeEntry.getQName().getNamespaceURI();
            String string4 = typeEntry.getQName().getLocalPart();
            String string5 = typeEntry.getName();
            String string6 = "";
            QName qName = null;
            if (!bl) {
                string6 = use.getEncoding();
            }
            if (string5.endsWith("[]")) {
                if (SchemaUtils.isListWithItemType(typeEntry.getNode())) {
                    string2 = "org.apache.axis.encoding.ser.SimpleListSerializerFactory";
                    string = "org.apache.axis.encoding.ser.SimpleListDeserializerFactory";
                } else {
                    string2 = "org.apache.axis.encoding.ser.ArraySerializerFactory";
                    string = "org.apache.axis.encoding.ser.ArrayDeserializerFactory";
                    qName = typeEntry.getComponentType();
                }
            } else if (typeEntry.getNode() != null && Utils.getEnumerationBaseAndValues(typeEntry.getNode(), this.symbolTable) != null) {
                string2 = "org.apache.axis.encoding.ser.EnumSerializerFactory";
                string = "org.apache.axis.encoding.ser.EnumDeserializerFactory";
            } else if (typeEntry.isSimpleType()) {
                string2 = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                string = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
            } else if (typeEntry.getBaseType() != null) {
                string2 = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                string = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
            } else {
                string2 = "org.apache.axis.encoding.ser.BeanSerializerFactory";
                string = "org.apache.axis.encoding.ser.BeanDeserializerFactory";
            }
            if (qName == null) {
                this.writeTypeMapping(printWriter, string3, string4, string5, string2, string, string6);
                continue;
            }
            this.writeArrayTypeMapping(printWriter, string3, string4, string5, string6, qName);
        }
    }

    protected void writeArrayTypeMapping(PrintWriter printWriter, String string, String string2, String string3, String string4, QName qName) throws IOException {
        printWriter.println("      <arrayMapping");
        printWriter.println("        xmlns:ns=\"" + string + "\"");
        printWriter.println("        qname=\"ns:" + string2 + '\"');
        printWriter.println("        type=\"java:" + string3 + '\"');
        printWriter.println("        innerType=\"" + Utils.genQNameAttributeString(qName, "cmp-ns") + '\"');
        printWriter.println("        encodingStyle=\"" + string4 + "\"");
        printWriter.println("      />");
    }

    protected void writeTypeMapping(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        printWriter.println("      <typeMapping");
        printWriter.println("        xmlns:ns=\"" + string + "\"");
        printWriter.println("        qname=\"ns:" + string2 + '\"');
        printWriter.println("        type=\"java:" + string3 + '\"');
        printWriter.println("        serializer=\"" + string4 + "\"");
        printWriter.println("        deserializer=\"" + string5 + "\"");
        printWriter.println("        encodingStyle=\"" + string6 + "\"");
        printWriter.println("      />");
    }

    protected void writeDeployPort(PrintWriter printWriter, Port port, Service service, BindingEntry bindingEntry) throws IOException {
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        String string = port.getName();
        boolean bl = bindingEntry.hasLiteral();
        boolean bl2 = Utils.hasMIME(bindingEntry);
        String string2 = "java";
        String string3 = "";
        for (Object object2 : bindingEntry.getBinding().getExtensibilityElements()) {
            if (object2 instanceof SOAPBinding) {
                this.use = Use.ENCODED;
                continue;
            }
            if (!(object2 instanceof UnknownExtensibilityElement) || !((QName)(serializable2 = ((UnknownExtensibilityElement)(serializable = (UnknownExtensibilityElement)object2)).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)serializable2).getLocalPart().equals("binding")) continue;
            this.use = Use.ENCODED;
        }
        if (this.symbolTable.isWrapped()) {
            string3 = " style=\"" + Style.WRAPPED + "\"";
            this.use = Use.LITERAL;
        } else {
            string3 = " style=\"" + bindingEntry.getBindingStyle().getName() + "\"";
            if (bl) {
                this.use = Use.LITERAL;
            }
        }
        object2 = " use=\"" + this.use + "\"";
        printWriter.println("  <service name=\"" + string + "\" provider=\"" + string2 + ":RPC" + "\"" + string3 + object2 + ">");
        printWriter.println("      <parameter name=\"wsdlTargetNamespace\" value=\"" + service.getQName().getNamespaceURI() + "\"/>");
        printWriter.println("      <parameter name=\"wsdlServiceElement\" value=\"" + service.getQName().getLocalPart() + "\"/>");
        if (bl2) {
            printWriter.println("      <parameter name=\"sendMultiRefs\" value=\"false\"/>");
        }
        serializable = new ArrayList();
        serializable2 = new ArrayList();
        Map map = this.symbolTable.getElementFormDefaults();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue().equals("qualified")) {
                ((ArrayList)serializable).add(entry.getKey());
                continue;
            }
            ((ArrayList)serializable2).add(entry.getKey());
        }
        if (((ArrayList)serializable).size() > 0) {
            printWriter.print("      <parameter name=\"schemaQualified\" value=\"");
            for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                printWriter.print(((ArrayList)serializable).get(i));
                if (i == ((ArrayList)serializable).size() - 1) continue;
                printWriter.print(',');
            }
            printWriter.println("\"/>");
        }
        if (((ArrayList)serializable2).size() > 0) {
            printWriter.print("      <parameter name=\"schemaUnqualified\" value=\"");
            for (int i = 0; i < ((ArrayList)serializable2).size(); ++i) {
                printWriter.print(((ArrayList)serializable2).get(i));
                if (i == ((ArrayList)serializable2).size() - 1) continue;
                printWriter.print(',');
            }
            printWriter.println("\"/>");
        }
        printWriter.println("      <parameter name=\"wsdlServicePort\" value=\"" + string + "\"/>");
        this.writeDeployBinding(printWriter, bindingEntry);
        this.writeDeployTypes(printWriter, bindingEntry.getBinding(), bl, bl2, this.use);
        printWriter.println("  </service>");
    }

    protected void writeDeployBinding(PrintWriter printWriter, BindingEntry bindingEntry) throws IOException {
        Object object;
        Object object2;
        Binding binding = bindingEntry.getBinding();
        Object object3 = bindingEntry.getName();
        object3 = this.emitter.isSkeletonWanted() ? (String)object3 + "Skeleton" : ((object2 = this.emitter.getImplementationClassName()) != null ? object2 : (String)object3 + "Impl");
        printWriter.println("      <parameter name=\"className\" value=\"" + (String)object3 + "\"/>");
        printWriter.println("      <parameter name=\"wsdlPortType\" value=\"" + binding.getPortType().getQName().getLocalPart() + "\"/>");
        printWriter.println("      <parameter name=\"typeMappingVersion\" value=\"" + this.emitter.getTypeMappingVersion() + "\"/>");
        object2 = new HashSet();
        String string = binding.getQName().getNamespaceURI();
        if (!this.emitter.isSkeletonWanted()) {
            for (Object object4 : binding.getBindingOperations()) {
                Serializable serializable;
                Object object5;
                object = object4.getOperation();
                OperationType operationType = object.getStyle();
                if (OperationType.NOTIFICATION.equals(operationType) || OperationType.SOLICIT_RESPONSE.equals(operationType)) continue;
                String string2 = null;
                ServiceDesc serviceDesc = this.emitter.getServiceDesc();
                if (this.emitter.isDeploy() && serviceDesc != null) {
                    object5 = serviceDesc.getOperationsByQName(new QName(string, object.getName()));
                    if (((OperationDesc[])object5).length == 0) {
                        log.warn("Can't find operation in the Java Class for WSDL binding operation : " + object.getName());
                        continue;
                    }
                    serializable = object5[0];
                    if (((OperationDesc)serializable).getMethod() == null) {
                        log.warn("Can't find Java method for operation descriptor : " + ((OperationDesc)serializable).getName());
                        continue;
                    }
                    string2 = ((OperationDesc)serializable).getMethod().getName();
                } else {
                    string2 = JavaUtils.xmlNameToJava(object.getName());
                }
                ((HashSet)object2).add(string2);
                object5 = this.symbolTable.getOperationParameters((Operation)object, "", bindingEntry);
                if (object5 == null) continue;
                serializable = Utils.getOperationQName((BindingOperation)object4, bindingEntry, this.symbolTable);
                QName qName = null;
                QName qName2 = null;
                if (object5.returnParam != null) {
                    qName = object5.returnParam.getQName();
                    qName2 = Utils.getXSIType(object5.returnParam);
                }
                HashMap hashMap = bindingEntry.getFaults();
                ArrayList arrayList = null;
                if (hashMap != null) {
                    arrayList = (ArrayList)hashMap.get(object4);
                }
                String string3 = Utils.getOperationSOAPAction((BindingOperation)object4);
                this.writeOperation(printWriter, string2, (QName)serializable, qName, qName2, (Parameters)object5, binding.getQName(), arrayList, string3);
            }
        }
        printWriter.print("      <parameter name=\"allowedMethods\" value=\"");
        if (((HashSet)object2).isEmpty()) {
            printWriter.println("*\"/>");
        } else {
            Object object4;
            boolean bl = true;
            object4 = ((HashSet)object2).iterator();
            while (object4.hasNext()) {
                object = (String)object4.next();
                if (bl) {
                    printWriter.print((String)object);
                    bl = false;
                    continue;
                }
                printWriter.print(" " + (String)object);
            }
            printWriter.println("\"/>");
        }
        Scope scope = this.emitter.getScope();
        if (scope != null) {
            printWriter.println("      <parameter name=\"scope\" value=\"" + scope.getName() + "\"/>");
        }
    }

    protected void writeOperation(PrintWriter printWriter, String string, QName qName, QName qName2, QName qName3, Parameters parameters, QName qName4, ArrayList arrayList, String string2) {
        Object object;
        QName qName5;
        Object object22;
        Object object3;
        Parameter parameter;
        printWriter.print("      <operation name=\"" + string + "\"");
        if (qName != null) {
            printWriter.print(" qname=\"" + Utils.genQNameAttributeString(qName, "operNS") + "\"");
        }
        if (qName2 != null) {
            printWriter.print(" returnQName=\"" + Utils.genQNameAttributeStringWithLastLocalPart(qName2, "retNS") + "\"");
        }
        if (qName3 != null) {
            printWriter.print(" returnType=\"" + Utils.genQNameAttributeString(qName3, "rtns") + "\"");
        }
        if ((parameter = parameters.returnParam) != null) {
            object3 = parameter.getType();
            QName qName6 = Utils.getItemQName((TypeEntry)object3);
            if (qName6 != null) {
                printWriter.print(" returnItemQName=\"");
                printWriter.print(Utils.genQNameAttributeString(qName6, "tns"));
                printWriter.print("\"");
            }
            if ((object22 = Utils.getItemType((TypeEntry)object3)) != null && this.use == Use.ENCODED) {
                printWriter.print(" returnItemType=\"");
                printWriter.print(Utils.genQNameAttributeString((QName)object22, "tns2"));
                printWriter.print("\"");
            }
        }
        if (string2 != null) {
            printWriter.print(" soapAction=\"" + string2 + "\"");
        }
        if (!OperationType.REQUEST_RESPONSE.equals(parameters.mep) && (object3 = this.getMepString(parameters.mep)) != null) {
            printWriter.print(" mep=\"" + (String)object3 + "\"");
        }
        if (parameters.returnParam != null && parameters.returnParam.isOutHeader()) {
            printWriter.print(" returnHeader=\"true\"");
        }
        printWriter.println(" >");
        object3 = parameters.list;
        for (int i = 0; i < ((Vector)object3).size(); ++i) {
            QName qName7;
            object22 = (Parameter)((Vector)object3).elementAt(i);
            qName5 = ((Parameter)object22).getQName();
            object = Utils.getXSIType((Parameter)object22);
            printWriter.print("        <parameter");
            if (qName5 == null) {
                printWriter.print(" name=\"" + ((Parameter)object22).getName() + "\"");
            } else {
                printWriter.print(" qname=\"" + Utils.genQNameAttributeStringWithLastLocalPart(qName5, "pns") + "\"");
            }
            printWriter.print(" type=\"" + Utils.genQNameAttributeString((QName)object, "tns") + "\"");
            if (((Parameter)object22).getMode() != 1) {
                printWriter.print(" mode=\"" + this.getModeString(((Parameter)object22).getMode()) + "\"");
            }
            if (((Parameter)object22).isInHeader()) {
                printWriter.print(" inHeader=\"true\"");
            }
            if (((Parameter)object22).isOutHeader()) {
                printWriter.print(" outHeader=\"true\"");
            }
            if ((qName7 = Utils.getItemQName(((Parameter)object22).getType())) != null) {
                printWriter.print(" itemQName=\"");
                printWriter.print(Utils.genQNameAttributeString(qName7, "itns"));
                printWriter.print("\"");
            }
            printWriter.println("/>");
        }
        if (arrayList != null) {
            for (Object object22 : arrayList) {
                qName5 = ((FaultInfo)object22).getQName();
                if (qName5 == null) continue;
                object = Utils.getFullExceptionName(((FaultInfo)object22).getMessage(), this.symbolTable);
                printWriter.print("        <fault");
                printWriter.print(" name=\"" + ((FaultInfo)object22).getName() + "\"");
                printWriter.print(" qname=\"" + Utils.genQNameAttributeString(qName5, "fns") + "\"");
                printWriter.print(" class=\"" + (String)object + "\"");
                printWriter.print(" type=\"" + Utils.genQNameAttributeString(((FaultInfo)object22).getXMLType(), "tns") + "\"");
                printWriter.println("/>");
            }
        }
        printWriter.println("      </operation>");
    }

    public String getModeString(byte by) {
        if (by == 1) {
            return "IN";
        }
        if (by == 3) {
            return "INOUT";
        }
        return "OUT";
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        File file = new File(string);
        File file2 = new File(file.getParent());
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        return new PrintWriter(outputStreamWriter);
    }

    String getMepString(OperationType operationType) {
        return (String)mepStrings.get(operationType.toString());
    }

    static {
        mepStrings.put(OperationType.REQUEST_RESPONSE.toString(), "request-response");
        mepStrings.put(OperationType.ONE_WAY.toString(), "oneway");
    }
}

