/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.rpc.ServiceException;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaServiceIfaceWriter
extends JavaClassWriter {
    private Service service;
    private SymbolTable symbolTable;

    protected JavaServiceIfaceWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName(), "service");
        this.service = serviceEntry.getService();
        this.symbolTable = symbolTable;
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends javax.xml.rpc.Service ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeComment(printWriter, this.service.getDocumentationElement(), false);
        Map map = this.service.getPorts();
        for (Port port : map.values()) {
            Binding binding = port.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{port.getName()}));
            }
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (portTypeEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bindingEntry.getBindingType() != 0) continue;
            String string = (String)bindingEntry.getDynamicVar("port name:" + port.getName());
            if (string == null) {
                string = port.getName();
            }
            if (!JavaUtils.isJavaId(string)) {
                string = Utils.xmlNameToJavaClass(string);
            }
            String string2 = (String)bindingEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            printWriter.println("    public java.lang.String get" + string + "Address();");
            printWriter.println();
            printWriter.println("    public " + string2 + " get" + string + "() throws " + ServiceException.class.getName() + ";");
            printWriter.println();
            printWriter.println("    public " + string2 + " get" + string + "(java.net.URL portAddress) throws " + ServiceException.class.getName() + ";");
        }
    }
}

