/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;

public class JavaUndeployWriter
extends JavaWriter {
    protected Definition definition;

    public JavaUndeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "undeploy");
        this.definition = definition;
    }

    public void generate() throws IOException {
        if (this.emitter.isServerSide()) {
            super.generate();
        }
    }

    protected String getFileName() {
        String string = this.emitter.getNamespaces().getAsDir(this.definition.getTargetNamespace());
        return string + "undeploy.wsdd";
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        printWriter.println(Messages.getMessage("deploy01"));
        printWriter.println(Messages.getMessage("deploy02"));
        printWriter.println(Messages.getMessage("deploy04"));
        printWriter.println(Messages.getMessage("deploy05"));
        printWriter.println(Messages.getMessage("deploy06"));
        printWriter.println(Messages.getMessage("deploy08"));
        printWriter.println(Messages.getMessage("deploy09"));
        printWriter.println();
        printWriter.println("<undeployment");
        printWriter.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\">");
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeDeployServices(printWriter);
        printWriter.println("</undeployment>");
    }

    protected void writeDeployServices(PrintWriter printWriter) throws IOException {
        Map map = this.definition.getServices();
        for (Service service : map.values()) {
            printWriter.println();
            printWriter.println("  <!-- " + Messages.getMessage("wsdlService00", service.getQName().getLocalPart()) + " -->");
            printWriter.println();
            for (Port port : service.getPorts().values()) {
                this.writeDeployPort(printWriter, port);
            }
        }
    }

    protected void writeDeployPort(PrintWriter printWriter, Port port) throws IOException {
        String string = port.getName();
        printWriter.println("  <service name=\"" + string + "\"/>");
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        File file = new File(string);
        File file2 = new File(file.getParent());
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        return new PrintWriter(outputStreamWriter);
    }
}

