/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.util.List;
import java.util.Map;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class BlockInfo {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_END = 2;
    public static final int ALIGN_FULL = 3;
    protected float top;
    protected float right;
    protected float bottom;
    protected float left;
    protected float indent;
    protected int alignment;
    protected float lineHeight;
    protected List fontFamilyList;
    protected Map fontAttrs;
    protected float ascent = -1.0f;
    protected float descent = -1.0f;
    protected boolean flowRegionBreak;

    public BlockInfo(float f, float f2, float f3, float f4, float f5, int n, float f6, List list, Map map, boolean bl) {
        this.top = f;
        this.right = f2;
        this.bottom = f3;
        this.left = f4;
        this.indent = f5;
        this.alignment = n;
        this.lineHeight = f6;
        this.fontFamilyList = list;
        this.fontAttrs = map;
        this.flowRegionBreak = bl;
    }

    public BlockInfo(float f, int n) {
        this.setMargin(f);
        this.indent = 0.0f;
        this.alignment = n;
        this.flowRegionBreak = false;
    }

    public void setMargin(float f) {
        this.top = f;
        this.right = f;
        this.bottom = f;
        this.left = f;
    }

    public void initLineInfo(FontRenderContext fontRenderContext) {
        float f = 12.0f;
        Float f2 = (Float)this.fontAttrs.get(TextAttribute.SIZE);
        if (f2 != null) {
            f = f2.floatValue();
        }
        for (GVTFontFamily gVTFontFamily : this.fontFamilyList) {
            if (gVTFontFamily instanceof UnresolvedFontFamily) {
                gVTFontFamily = FontFamilyResolver.resolve((UnresolvedFontFamily)gVTFontFamily);
            }
            if (gVTFontFamily == null) continue;
            GVTFont gVTFont = gVTFontFamily.deriveFont(f, this.fontAttrs);
            GVTLineMetrics gVTLineMetrics = gVTFont.getLineMetrics("", fontRenderContext);
            this.ascent = gVTLineMetrics.getAscent();
            this.descent = gVTLineMetrics.getDescent();
            break;
        }
        if (this.ascent == -1.0f) {
            this.ascent = f * 0.8f;
            this.descent = f * 0.2f;
        }
    }

    public float getTopMargin() {
        return this.top;
    }

    public float getRightMargin() {
        return this.right;
    }

    public float getBottomMargin() {
        return this.bottom;
    }

    public float getLeftMargin() {
        return this.left;
    }

    public float getIndent() {
        return this.indent;
    }

    public int getTextAlignment() {
        return this.alignment;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public List getFontFamilyList() {
        return this.fontFamilyList;
    }

    public Map getFontAttrs() {
        return this.fontAttrs;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public boolean isFlowRegionBreak() {
        return this.flowRegionBreak;
    }
}

