/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.InstructionComparator;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public abstract class Instruction
implements Cloneable,
Serializable {
    protected short length = 1;
    protected short opcode = (short)-1;
    private static InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(short s, short s2) {
        this.length = s2;
        this.opcode = s;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this.opcode];
    }

    public String toString(boolean bl) {
        if (bl) {
            return this.getName() + "[" + this.opcode + "](" + this.length + ")";
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool constantPool) {
        return this.toString(false);
    }

    public Instruction copy() {
        Instruction instruction = null;
        if (InstructionConstants.INSTRUCTIONS[this.getOpcode()] != null) {
            instruction = this;
        } else {
            try {
                instruction = (Instruction)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.err.println(cloneNotSupportedException);
            }
        }
        return instruction;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
    }

    public static final Instruction readInstruction(ByteSequence byteSequence) throws IOException {
        Class<?> clazz;
        boolean bl = false;
        short s = (short)byteSequence.readUnsignedByte();
        Instruction instruction = null;
        if (s == 196) {
            bl = true;
            s = (short)byteSequence.readUnsignedByte();
        }
        if (InstructionConstants.INSTRUCTIONS[s] != null) {
            return InstructionConstants.INSTRUCTIONS[s];
        }
        try {
            clazz = Class.forName(Instruction.className(s));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassGenException("Illegal opcode detected.");
        }
        try {
            instruction = (Instruction)clazz.newInstance();
            if (bl && !(instruction instanceof LocalVariableInstruction) && !(instruction instanceof IINC) && !(instruction instanceof RET)) {
                throw new Exception("Illegal opcode after wide: " + s);
            }
            instruction.setOpcode(s);
            instruction.initFromFile(byteSequence, bl);
        }
        catch (Exception exception) {
            throw new ClassGenException(exception.toString());
        }
        return instruction;
    }

    private static final String className(short s) {
        String string = Constants.OPCODE_NAMES[s].toUpperCase();
        try {
            int n = string.length();
            char c = string.charAt(n - 2);
            char c2 = string.charAt(n - 1);
            if (c == '_' && c2 >= '0' && c2 <= '5') {
                string = string.substring(0, n - 2);
            }
            if (string.equals("ICONST_M1")) {
                string = "ICONST";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return "org.apache.bcel.generic." + string;
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        return Constants.CONSUME_STACK[this.opcode];
    }

    public int produceStack(ConstantPoolGen constantPoolGen) {
        return Constants.PRODUCE_STACK[this.opcode];
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        return this.length;
    }

    private void setOpcode(short s) {
        this.opcode = s;
    }

    void dispose() {
    }

    public abstract void accept(Visitor var1);

    public static InstructionComparator getComparator() {
        return cmp;
    }

    public static void setComparator(InstructionComparator instructionComparator) {
        cmp = instructionComparator;
    }

    public boolean equals(Object object) {
        return object instanceof Instruction ? cmp.equals(this, (Instruction)object) : false;
    }
}

