/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;

public class ClassLoader
extends java.lang.ClassLoader {
    private Hashtable classes = new Hashtable();
    private String[] ignored_packages = new String[]{"java.", "javax.", "sun."};
    private Repository repository = SyntheticRepository.getInstance();
    private java.lang.ClassLoader deferTo = ClassLoader.getSystemClassLoader();

    public ClassLoader() {
    }

    public ClassLoader(java.lang.ClassLoader classLoader) {
        this.deferTo = classLoader;
        this.repository = new ClassLoaderRepository(classLoader);
    }

    public ClassLoader(String[] stringArray) {
        this.addIgnoredPkgs(stringArray);
    }

    public ClassLoader(java.lang.ClassLoader classLoader, String[] stringArray) {
        this.deferTo = classLoader;
        this.repository = new ClassLoaderRepository(classLoader);
        this.addIgnoredPkgs(stringArray);
    }

    private void addIgnoredPkgs(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + this.ignored_packages.length];
        System.arraycopy(this.ignored_packages, 0, stringArray2, 0, this.ignored_packages.length);
        System.arraycopy(stringArray, 0, stringArray2, this.ignored_packages.length, stringArray.length);
        this.ignored_packages = stringArray2;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = (Class<?>)this.classes.get(string);
        if (clazz == null) {
            for (int i = 0; i < this.ignored_packages.length; ++i) {
                if (!string.startsWith(this.ignored_packages[i])) continue;
                clazz = this.deferTo.loadClass(string);
                break;
            }
            if (clazz == null) {
                JavaClass javaClass = null;
                if (string.indexOf("$$BCEL$$") >= 0) {
                    javaClass = this.createClass(string);
                } else {
                    javaClass = this.repository.loadClass(string);
                    if (javaClass != null) {
                        javaClass = this.modifyClass(javaClass);
                    } else {
                        throw new ClassNotFoundException(string);
                    }
                }
                if (javaClass != null) {
                    byte[] byArray = javaClass.getBytes();
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                } else {
                    clazz = Class.forName(string);
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
        }
        this.classes.put(string, clazz);
        return clazz;
    }

    protected JavaClass modifyClass(JavaClass javaClass) {
        return javaClass;
    }

    protected JavaClass createClass(String string) {
        Object object;
        Object object2;
        int n = string.indexOf("$$BCEL$$");
        String string2 = string.substring(n + 8);
        JavaClass javaClass = null;
        try {
            object2 = Utility.decode(string2, true);
            object = new ClassParser(new ByteArrayInputStream((byte[])object2), "foo");
            javaClass = ((ClassParser)object).parse();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        object2 = javaClass.getConstantPool();
        object = (ConstantClass)((ConstantPool)object2).getConstant(javaClass.getClassNameIndex(), (byte)7);
        ConstantUtf8 constantUtf8 = (ConstantUtf8)((ConstantPool)object2).getConstant(((ConstantClass)object).getNameIndex(), (byte)1);
        constantUtf8.setBytes(string.replace('.', '/'));
        return javaClass;
    }
}

