/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.io.DotTerminatedMessageReader;
import org.apache.commons.net.io.DotTerminatedMessageWriter;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.nntp.ArticlePointer;
import org.apache.commons.net.nntp.NNTP;
import org.apache.commons.net.nntp.NNTPReply;
import org.apache.commons.net.nntp.NewGroupsOrNewsQuery;
import org.apache.commons.net.nntp.NewsgroupInfo;

public class NNTPClient
extends NNTP {
    private void __parseArticlePointer(String string, ArticlePointer articlePointer) throws MalformedServerReplyException {
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 3) {
                stringTokenizer.nextToken();
                try {
                    articlePointer.articleNumber = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    break block3;
                }
                articlePointer.articleId = stringTokenizer.nextToken();
                return;
            }
        }
        throw new MalformedServerReplyException("Could not parse article pointer.\nServer reply: " + string);
    }

    private void __parseGroupReply(String string, NewsgroupInfo newsgroupInfo) throws MalformedServerReplyException {
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 5) {
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                newsgroupInfo._setNewsgroup(stringTokenizer.nextToken());
                try {
                    newsgroupInfo._setArticleCount(Integer.parseInt(string2));
                    newsgroupInfo._setFirstArticle(Integer.parseInt(string3));
                    newsgroupInfo._setLastArticle(Integer.parseInt(string4));
                }
                catch (NumberFormatException numberFormatException) {
                    break block3;
                }
                newsgroupInfo._setPostingPermission(0);
                return;
            }
        }
        throw new MalformedServerReplyException("Could not parse newsgroup info.\nServer reply: " + string);
    }

    private NewsgroupInfo __parseNewsgroupListEntry(String string) {
        NewsgroupInfo newsgroupInfo = new NewsgroupInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 4) {
            return null;
        }
        newsgroupInfo._setNewsgroup(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        try {
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            newsgroupInfo._setFirstArticle(n2);
            newsgroupInfo._setLastArticle(n);
            if (n2 == 0 && n == 0) {
                newsgroupInfo._setArticleCount(0);
            } else {
                newsgroupInfo._setArticleCount(n - n2 + 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        switch (string4.charAt(0)) {
            case 'Y': 
            case 'y': {
                newsgroupInfo._setPostingPermission(2);
                break;
            }
            case 'N': 
            case 'n': {
                newsgroupInfo._setPostingPermission(3);
                break;
            }
            case 'M': 
            case 'm': {
                newsgroupInfo._setPostingPermission(1);
                break;
            }
            default: {
                newsgroupInfo._setPostingPermission(0);
            }
        }
        return newsgroupInfo;
    }

    private NewsgroupInfo[] __readNewsgroupListing() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new DotTerminatedMessageReader(this._reader_));
        Vector<NewsgroupInfo> vector = new Vector<NewsgroupInfo>(2048);
        while ((string = bufferedReader.readLine()) != null) {
            NewsgroupInfo newsgroupInfo = this.__parseNewsgroupListEntry(string);
            if (newsgroupInfo != null) {
                vector.addElement(newsgroupInfo);
                continue;
            }
            throw new MalformedServerReplyException(string);
        }
        int n = vector.size();
        if (n < 1) {
            return new NewsgroupInfo[0];
        }
        Object[] objectArray = new NewsgroupInfo[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Reader __retrieve(int n, String string, ArticlePointer articlePointer) throws IOException {
        if (string != null ? !NNTPReply.isPositiveCompletion(this.sendCommand(n, string)) : !NNTPReply.isPositiveCompletion(this.sendCommand(n))) {
            return null;
        }
        if (articlePointer != null) {
            this.__parseArticlePointer(this.getReplyString(), articlePointer);
        }
        DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);
        return dotTerminatedMessageReader;
    }

    private Reader __retrieve(int n, int n2, ArticlePointer articlePointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.sendCommand(n, Integer.toString(n2)))) {
            return null;
        }
        if (articlePointer != null) {
            this.__parseArticlePointer(this.getReplyString(), articlePointer);
        }
        DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);
        return dotTerminatedMessageReader;
    }

    public Reader retrieveArticle(String string, ArticlePointer articlePointer) throws IOException {
        return this.__retrieve(0, string, articlePointer);
    }

    public Reader retrieveArticle(String string) throws IOException {
        return this.retrieveArticle(string, null);
    }

    public Reader retrieveArticle() throws IOException {
        return this.retrieveArticle(null);
    }

    public Reader retrieveArticle(int n, ArticlePointer articlePointer) throws IOException {
        return this.__retrieve(0, n, articlePointer);
    }

    public Reader retrieveArticle(int n) throws IOException {
        return this.retrieveArticle(n, null);
    }

    public Reader retrieveArticleHeader(String string, ArticlePointer articlePointer) throws IOException {
        return this.__retrieve(3, string, articlePointer);
    }

    public Reader retrieveArticleHeader(String string) throws IOException {
        return this.retrieveArticleHeader(string, null);
    }

    public Reader retrieveArticleHeader() throws IOException {
        return this.retrieveArticleHeader(null);
    }

    public Reader retrieveArticleHeader(int n, ArticlePointer articlePointer) throws IOException {
        return this.__retrieve(3, n, articlePointer);
    }

    public Reader retrieveArticleHeader(int n) throws IOException {
        return this.retrieveArticleHeader(n, null);
    }

    public Reader retrieveArticleBody(String string, ArticlePointer articlePointer) throws IOException {
        return this.__retrieve(1, string, articlePointer);
    }

    public Reader retrieveArticleBody(String string) throws IOException {
        return this.retrieveArticleBody(string, null);
    }

    public Reader retrieveArticleBody() throws IOException {
        return this.retrieveArticleBody(null);
    }

    public Reader retrieveArticleBody(int n, ArticlePointer articlePointer) throws IOException {
        return this.__retrieve(1, n, articlePointer);
    }

    public Reader retrieveArticleBody(int n) throws IOException {
        return this.retrieveArticleBody(n, null);
    }

    public boolean selectNewsgroup(String string, NewsgroupInfo newsgroupInfo) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.group(string))) {
            return false;
        }
        if (newsgroupInfo != null) {
            this.__parseGroupReply(this.getReplyString(), newsgroupInfo);
        }
        return true;
    }

    public boolean selectNewsgroup(String string) throws IOException {
        return this.selectNewsgroup(string, null);
    }

    public String listHelp() throws IOException {
        if (!NNTPReply.isInformational(this.help())) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);
        Util.copyReader(dotTerminatedMessageReader, stringWriter);
        ((Reader)dotTerminatedMessageReader).close();
        stringWriter.close();
        return stringWriter.toString();
    }

    public boolean selectArticle(String string, ArticlePointer articlePointer) throws IOException {
        if (string != null ? !NNTPReply.isPositiveCompletion(this.stat(string)) : !NNTPReply.isPositiveCompletion(this.stat())) {
            return false;
        }
        if (articlePointer != null) {
            this.__parseArticlePointer(this.getReplyString(), articlePointer);
        }
        return true;
    }

    public boolean selectArticle(String string) throws IOException {
        return this.selectArticle(string, null);
    }

    public boolean selectArticle(ArticlePointer articlePointer) throws IOException {
        return this.selectArticle(null, articlePointer);
    }

    public boolean selectArticle(int n, ArticlePointer articlePointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.stat(n))) {
            return false;
        }
        if (articlePointer != null) {
            this.__parseArticlePointer(this.getReplyString(), articlePointer);
        }
        return true;
    }

    public boolean selectArticle(int n) throws IOException {
        return this.selectArticle(n, null);
    }

    public boolean selectPreviousArticle(ArticlePointer articlePointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.last())) {
            return false;
        }
        if (articlePointer != null) {
            this.__parseArticlePointer(this.getReplyString(), articlePointer);
        }
        return true;
    }

    public boolean selectPreviousArticle() throws IOException {
        return this.selectPreviousArticle(null);
    }

    public boolean selectNextArticle(ArticlePointer articlePointer) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.next())) {
            return false;
        }
        if (articlePointer != null) {
            this.__parseArticlePointer(this.getReplyString(), articlePointer);
        }
        return true;
    }

    public boolean selectNextArticle() throws IOException {
        return this.selectNextArticle(null);
    }

    public NewsgroupInfo[] listNewsgroups() throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.list())) {
            return null;
        }
        return this.__readNewsgroupListing();
    }

    public NewsgroupInfo[] listNewsgroups(String string) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.listActive(string))) {
            return null;
        }
        return this.__readNewsgroupListing();
    }

    public NewsgroupInfo[] listNewNewsgroups(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newgroups(newGroupsOrNewsQuery.getDate(), newGroupsOrNewsQuery.getTime(), newGroupsOrNewsQuery.isGMT(), newGroupsOrNewsQuery.getDistributions()))) {
            return null;
        }
        return this.__readNewsgroupListing();
    }

    public String[] listNewNews(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        String string;
        if (!NNTPReply.isPositiveCompletion(this.newnews(newGroupsOrNewsQuery.getNewsgroups(), newGroupsOrNewsQuery.getDate(), newGroupsOrNewsQuery.getTime(), newGroupsOrNewsQuery.isGMT(), newGroupsOrNewsQuery.getDistributions()))) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = new BufferedReader(new DotTerminatedMessageReader(this._reader_));
        while ((string = bufferedReader.readLine()) != null) {
            vector.addElement(string);
        }
        int n = vector.size();
        if (n < 1) {
            return new String[0];
        }
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean completePendingCommand() throws IOException {
        return NNTPReply.isPositiveCompletion(this.getReply());
    }

    public Writer postArticle() throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.post())) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    public Writer forwardArticle(String string) throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.ihave(string))) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    public boolean logout() throws IOException {
        return NNTPReply.isPositiveCompletion(this.quit());
    }

    public boolean authenticate(String string, String string2) throws IOException {
        int n = this.authinfoUser(string);
        if (n == 381 && (n = this.authinfoPass(string2)) == 281) {
            this._isAllowedToPost = true;
            return true;
        }
        return false;
    }

    private Reader __retrieveArticleInfo(String string) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xover(string))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public Reader retrieveArticleInfo(int n) throws IOException {
        return this.__retrieveArticleInfo(Integer.toString(n));
    }

    public Reader retrieveArticleInfo(int n, int n2) throws IOException {
        return this.__retrieveArticleInfo(new String(n + "-" + n2));
    }

    private Reader __retrieveHeader(String string, String string2) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xhdr(string, string2))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public Reader retrieveHeader(String string, int n) throws IOException {
        return this.__retrieveHeader(string, Integer.toString(n));
    }

    public Reader retrieveHeader(String string, int n, int n2) throws IOException {
        return this.__retrieveHeader(string, new String(n + "-" + n2));
    }
}

