/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import java.util.Date;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;

public class XMLFormatter
implements Formatter {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private boolean m_printTime = true;
    private boolean m_printRelativeTime = false;
    private boolean m_printPriority = true;
    private boolean m_printCategory = true;
    private boolean m_printContext = false;
    private boolean m_printMessage = true;
    private boolean m_printException = true;
    private boolean m_printNumericTime = true;

    public void setPrintTime(boolean bl) {
        this.m_printTime = bl;
    }

    public void setPrintRelativeTime(boolean bl) {
        this.m_printRelativeTime = bl;
    }

    public void setPrintPriority(boolean bl) {
        this.m_printPriority = bl;
    }

    public void setPrintCategory(boolean bl) {
        this.m_printCategory = bl;
    }

    public void setPrintContext(boolean bl) {
        this.m_printContext = bl;
    }

    public void setPrintMessage(boolean bl) {
        this.m_printMessage = bl;
    }

    public void setPrintException(boolean bl) {
        this.m_printException = bl;
    }

    public String format(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("<log-entry>");
        stringBuffer.append(EOL);
        if (this.m_printTime) {
            stringBuffer.append("  <time>");
            if (this.m_printNumericTime) {
                stringBuffer.append(logEvent.getTime());
            } else {
                stringBuffer.append(new Date(logEvent.getTime()));
            }
            stringBuffer.append("</time>");
            stringBuffer.append(EOL);
        }
        if (this.m_printRelativeTime) {
            stringBuffer.append("  <relative-time>");
            stringBuffer.append(logEvent.getRelativeTime());
            stringBuffer.append("</relative-time>");
            stringBuffer.append(EOL);
        }
        if (this.m_printPriority) {
            stringBuffer.append("  <priority>");
            stringBuffer.append(logEvent.getPriority().getName());
            stringBuffer.append("</priority>");
            stringBuffer.append(EOL);
        }
        if (this.m_printCategory) {
            stringBuffer.append("  <category>");
            stringBuffer.append(logEvent.getCategory());
            stringBuffer.append("</category>");
            stringBuffer.append(EOL);
        }
        if (this.m_printContext && null != logEvent.getContextMap()) {
            stringBuffer.append("  <context-map>");
            stringBuffer.append(logEvent.getContextMap());
            stringBuffer.append("</context-map>");
            stringBuffer.append(EOL);
        }
        if (this.m_printMessage && null != logEvent.getMessage()) {
            stringBuffer.append("  <message><![CDATA[");
            stringBuffer.append(logEvent.getMessage());
            stringBuffer.append("]]></message>");
            stringBuffer.append(EOL);
        }
        if (this.m_printException && null != logEvent.getThrowable()) {
            stringBuffer.append("  <exception><![CDATA[");
            stringBuffer.append("]]></exception>");
            stringBuffer.append(EOL);
        }
        stringBuffer.append("</log-entry>");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }
}

