/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.util.LinkedList;
import org.apache.log.ErrorAware;
import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.output.AbstractWrappingTarget;

public class AsyncLogTarget
extends AbstractWrappingTarget
implements Runnable {
    private final LinkedList m_list = new LinkedList();
    private final int m_queueSize;

    public AsyncLogTarget(LogTarget logTarget) {
        this(logTarget, 15);
    }

    public AsyncLogTarget(LogTarget logTarget, int n) {
        this(logTarget, n, false);
    }

    public AsyncLogTarget(LogTarget logTarget, boolean bl) {
        this(logTarget, 15, bl);
    }

    public AsyncLogTarget(LogTarget logTarget, int n, boolean bl) {
        super(logTarget, bl);
        this.m_queueSize = n;
        this.open();
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
        if (this.getLogTarget() instanceof ErrorAware) {
            ((ErrorAware)((Object)this.getLogTarget())).setErrorHandler(errorHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessEvent(LogEvent logEvent) {
        LinkedList linkedList = this.m_list;
        synchronized (linkedList) {
            int n = this.m_list.size();
            while (this.m_queueSize <= n) {
                try {
                    this.m_list.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = this.m_list.size();
            }
            this.m_list.addFirst(logEvent);
            if (n == 0) {
                this.m_list.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = false;
        while (true) {
            LogEvent logEvent = null;
            LinkedList linkedList = this.m_list;
            synchronized (linkedList) {
                while (null == logEvent) {
                    int n = this.m_list.size();
                    if (n > 0) {
                        logEvent = (LogEvent)this.m_list.removeLast();
                        if (n != this.m_queueSize) continue;
                        this.m_list.notify();
                        continue;
                    }
                    if (bl || Thread.interrupted()) {
                        return;
                    }
                    try {
                        this.m_list.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
            }
            try {
                this.getLogTarget().processEvent(logEvent);
                continue;
            }
            catch (Throwable throwable) {
                this.getErrorHandler().error("Unknown error writing event.", throwable, logEvent);
                continue;
            }
            break;
        }
    }
}

