/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.output.AbstractTarget;

public class MemoryTarget
extends AbstractTarget {
    private final LogEvent[] m_buffer;
    private Priority m_threshold;
    private LogTarget m_target;
    private int m_used;
    private int m_index;
    private boolean m_overwrite;

    public MemoryTarget(LogTarget logTarget, int n, Priority priority) {
        this.m_target = logTarget;
        this.m_buffer = new LogEvent[n];
        this.m_threshold = priority;
        this.open();
    }

    protected synchronized void setOverwrite(boolean bl) {
        this.m_overwrite = bl;
    }

    protected synchronized void doProcessEvent(LogEvent logEvent) {
        if (this.isFull()) {
            if (this.m_overwrite) {
                --this.m_used;
            } else {
                this.getErrorHandler().error("Memory buffer is full", null, logEvent);
                return;
            }
        }
        this.m_index = 0 == this.m_used ? 0 : (this.m_index + 1) % this.m_buffer.length;
        this.m_buffer[this.m_index] = logEvent;
        ++this.m_used;
        if (this.shouldPush(logEvent)) {
            this.push();
        }
    }

    public final synchronized boolean isFull() {
        return this.m_buffer.length == this.m_used;
    }

    protected synchronized boolean shouldPush(LogEvent logEvent) {
        return this.m_threshold.isLowerOrEqual(logEvent.getPriority()) || this.isFull();
    }

    public synchronized void push() {
        if (null == this.m_target) {
            this.getErrorHandler().error("Can not push events to a null target", null, null);
            return;
        }
        try {
            int n = this.m_used;
            int n2 = this.m_index - this.m_used + 1;
            if (n2 < 0) {
                n2 += this.m_buffer.length;
            }
            for (int i = 0; i < n; ++i) {
                int n3 = (n2 + i) % this.m_buffer.length;
                this.m_target.processEvent(this.m_buffer[n3]);
                this.m_buffer[n3] = null;
                --this.m_used;
            }
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unknown error pushing events.", throwable, null);
        }
    }
}

