/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.output.AbstractTarget;
import org.apache.log.util.Closeable;

public class PriorityFilteringTarget
extends AbstractTarget {
    private final Priority m_priority;
    private final boolean m_closeWrapped;
    private LogTarget[] m_targets;

    public PriorityFilteringTarget(Priority priority, boolean bl) {
        this.m_priority = priority;
        this.m_closeWrapped = bl;
        this.open();
    }

    public PriorityFilteringTarget(Priority priority) {
        this(priority, false);
    }

    public void addTarget(LogTarget logTarget) {
        if (null == this.m_targets) {
            this.m_targets = new LogTarget[]{logTarget};
        } else {
            LogTarget[] logTargetArray = this.m_targets;
            this.m_targets = new LogTarget[logTargetArray.length + 1];
            System.arraycopy(logTargetArray, 0, this.m_targets, 0, logTargetArray.length);
            this.m_targets[this.m_targets.length - 1] = logTarget;
        }
    }

    protected void doProcessEvent(LogEvent logEvent) throws Exception {
        if (logEvent != null && this.m_targets != null && !logEvent.getPriority().isLower(this.m_priority)) {
            for (int i = 0; i < this.m_targets.length; ++i) {
                this.m_targets[i].processEvent(logEvent);
            }
        }
    }

    public void close() {
        super.close();
        if (this.m_closeWrapped && this.m_targets != null) {
            for (int i = 0; i < this.m_targets.length; ++i) {
                if (!(this.m_targets[i] instanceof Closeable)) continue;
                ((Closeable)((Object)this.m_targets[i])).close();
            }
        }
    }
}

