/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.xalan.xsltc.compiler.ApplyTemplates;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Closure;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.ForEach;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.VariableRefBase;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.CompareGenerator;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordFactGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordGenerator;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Sort
extends Instruction
implements Closure {
    private Expression _select;
    private AttributeValue _order;
    private AttributeValue _caseOrder;
    private AttributeValue _dataType;
    private String _lang;
    private String _data = null;
    private String _className = null;
    private ArrayList _closureVars = null;
    private boolean _needsSortRecordFactory = false;

    Sort() {
    }

    public boolean inInnerClass() {
        return this._className != null;
    }

    public Closure getParentClosure() {
        return null;
    }

    public String getInnerClassName() {
        return this._className;
    }

    public void addVariable(VariableRefBase variableRefBase) {
        if (this._closureVars == null) {
            this._closureVars = new ArrayList();
        }
        if (!this._closureVars.contains(variableRefBase)) {
            this._closureVars.add(variableRefBase);
            this._needsSortRecordFactory = true;
        }
    }

    private void setInnerClassName(String string) {
        this._className = string;
    }

    public void parseContents(Parser parser2) {
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        if (!(syntaxTreeNode instanceof ApplyTemplates) && !(syntaxTreeNode instanceof ForEach)) {
            this.reportError(this, parser2, "STRAY_SORT_ERR", null);
            return;
        }
        this._select = parser2.parseExpression(this, "select", "string(.)");
        String string = this.getAttribute("order");
        if (string.length() == 0) {
            string = "ascending";
        }
        this._order = AttributeValue.create(this, string, parser2);
        string = this.getAttribute("data-type");
        if (string.length() == 0) {
            try {
                Type type = this._select.typeCheck(parser2.getSymbolTable());
                string = type instanceof IntType ? "number" : "text";
            }
            catch (TypeCheckError typeCheckError) {
                string = "text";
            }
        }
        this._dataType = AttributeValue.create(this, string, parser2);
        this._lang = this.getAttribute("lang");
        string = this.getAttribute("case-order");
        this._caseOrder = AttributeValue.create(this, string, parser2);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        Type type = this._select.typeCheck(symbolTable);
        if (!(type instanceof StringType)) {
            this._select = new CastExpr(this._select, Type.String);
        }
        this._order.typeCheck(symbolTable);
        this._caseOrder.typeCheck(symbolTable);
        this._dataType.typeCheck(symbolTable);
        return Type.Void;
    }

    public void translateSortType(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._dataType.translate(classGenerator, methodGenerator);
    }

    public void translateSortOrder(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._order.translate(classGenerator, methodGenerator);
    }

    public void translateCaseOrder(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._caseOrder.translate(classGenerator, methodGenerator);
    }

    public void translateLang(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(new PUSH(constantPoolGen, this._lang));
    }

    public void translateSelect(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this._select.translate(classGenerator, methodGenerator);
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
    }

    public static void translateSortIterator(ClassGenerator classGenerator, MethodGenerator methodGenerator, Expression expression, Vector vector) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.SortingIterator", "<init>", "(Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xalan/xsltc/dom/NodeSortRecordFactory;)V");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("sort_tmp1", Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), instructionList.getEnd(), null);
        LocalVariableGen localVariableGen2 = methodGenerator.addLocalVariable("sort_tmp2", Util.getJCRefType("Lorg/apache/xalan/xsltc/dom/NodeSortRecordFactory;"), instructionList.getEnd(), null);
        if (expression == null) {
            int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getAxisIterator", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(new PUSH(constantPoolGen, 3));
            instructionList.append(new INVOKEINTERFACE(n2, 2));
        } else {
            expression.translate(classGenerator, methodGenerator);
        }
        instructionList.append(new ASTORE(localVariableGen.getIndex()));
        Sort.compileSortRecordFactory(vector, classGenerator, methodGenerator);
        instructionList.append(new ASTORE(localVariableGen2.getIndex()));
        instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.SortingIterator")));
        instructionList.append(DUP);
        instructionList.append(new ALOAD(localVariableGen.getIndex()));
        instructionList.append(new ALOAD(localVariableGen2.getIndex()));
        instructionList.append(new INVOKESPECIAL(n));
    }

    public static void compileSortRecordFactory(Vector vector, ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        String string = Sort.compileSortRecord(vector, classGenerator, methodGenerator);
        boolean bl = false;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            object = (Sort)vector.elementAt(i);
            bl |= ((Sort)object)._needsSortRecordFactory;
        }
        String string2 = "org/apache/xalan/xsltc/dom/NodeSortRecordFactory";
        if (bl) {
            string2 = Sort.compileSortRecordFactory(vector, classGenerator, methodGenerator, string);
        }
        object = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("sort_order_tmp", Util.getJCRefType("[Ljava/lang/String;"), instructionList.getEnd(), null);
        instructionList.append(new PUSH((ConstantPoolGen)object, n));
        instructionList.append(new ANEWARRAY(((ConstantPoolGen)object).addClass("java.lang.String")));
        for (int i = 0; i < n; ++i) {
            Sort sort = (Sort)vector.elementAt(i);
            instructionList.append(DUP);
            instructionList.append(new PUSH((ConstantPoolGen)object, i));
            sort.translateSortOrder(classGenerator, methodGenerator);
            instructionList.append(AASTORE);
        }
        instructionList.append(new ASTORE(localVariableGen.getIndex()));
        LocalVariableGen localVariableGen2 = methodGenerator.addLocalVariable("sort_type_tmp", Util.getJCRefType("[Ljava/lang/String;"), instructionList.getEnd(), null);
        instructionList.append(new PUSH((ConstantPoolGen)object, n));
        instructionList.append(new ANEWARRAY(((ConstantPoolGen)object).addClass("java.lang.String")));
        for (int i = 0; i < n; ++i) {
            Sort sort = (Sort)vector.elementAt(i);
            instructionList.append(DUP);
            instructionList.append(new PUSH((ConstantPoolGen)object, i));
            sort.translateSortType(classGenerator, methodGenerator);
            instructionList.append(AASTORE);
        }
        instructionList.append(new ASTORE(localVariableGen2.getIndex()));
        LocalVariableGen localVariableGen3 = methodGenerator.addLocalVariable("sort_lang_tmp", Util.getJCRefType("[Ljava/lang/String;"), instructionList.getEnd(), null);
        instructionList.append(new PUSH((ConstantPoolGen)object, n));
        instructionList.append(new ANEWARRAY(((ConstantPoolGen)object).addClass("java.lang.String")));
        for (int i = 0; i < n; ++i) {
            Sort sort = (Sort)vector.elementAt(i);
            instructionList.append(DUP);
            instructionList.append(new PUSH((ConstantPoolGen)object, i));
            sort.translateLang(classGenerator, methodGenerator);
            instructionList.append(AASTORE);
        }
        instructionList.append(new ASTORE(localVariableGen3.getIndex()));
        LocalVariableGen localVariableGen4 = methodGenerator.addLocalVariable("sort_case_order_tmp", Util.getJCRefType("[Ljava/lang/String;"), instructionList.getEnd(), null);
        instructionList.append(new PUSH((ConstantPoolGen)object, n));
        instructionList.append(new ANEWARRAY(((ConstantPoolGen)object).addClass("java.lang.String")));
        for (int i = 0; i < n; ++i) {
            Sort sort = (Sort)vector.elementAt(i);
            instructionList.append(DUP);
            instructionList.append(new PUSH((ConstantPoolGen)object, i));
            sort.translateCaseOrder(classGenerator, methodGenerator);
            instructionList.append(AASTORE);
        }
        instructionList.append(new ASTORE(localVariableGen4.getIndex()));
        instructionList.append(new NEW(((ConstantPoolGen)object).addClass(string2)));
        instructionList.append(DUP);
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new PUSH((ConstantPoolGen)object, string));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new ALOAD(localVariableGen.getIndex()));
        instructionList.append(new ALOAD(localVariableGen2.getIndex()));
        instructionList.append(new ALOAD(localVariableGen3.getIndex()));
        instructionList.append(new ALOAD(localVariableGen4.getIndex()));
        instructionList.append(new INVOKESPECIAL(((ConstantPoolGen)object).addMethodref(string2, "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V")));
        ArrayList<VariableRefBase> arrayList = new ArrayList<VariableRefBase>();
        for (int i = 0; i < n; ++i) {
            Sort sort = (Sort)vector.get(i);
            int n2 = sort._closureVars == null ? 0 : sort._closureVars.size();
            for (int j = 0; j < n2; ++j) {
                VariableRefBase variableRefBase = (VariableRefBase)sort._closureVars.get(j);
                if (arrayList.contains(variableRefBase)) continue;
                VariableBase variableBase = variableRefBase.getVariable();
                instructionList.append(DUP);
                instructionList.append(variableBase.loadInstruction());
                instructionList.append(new PUTFIELD(((ConstantPoolGen)object).addFieldref(string2, variableBase.getEscapedName(), variableBase.getType().toSignature())));
                arrayList.add(variableRefBase);
            }
        }
    }

    public static String compileSortRecordFactory(Vector vector, ClassGenerator classGenerator, MethodGenerator methodGenerator, String string) {
        Constants constants;
        String[] stringArray;
        XSLTC xSLTC = ((Sort)vector.firstElement()).getXSLTC();
        String string2 = xSLTC.getHelperClassName();
        NodeSortRecordFactGenerator nodeSortRecordFactGenerator = new NodeSortRecordFactGenerator(string2, "org/apache/xalan/xsltc/dom/NodeSortRecordFactory", string2 + ".java", 49, new String[0], classGenerator.getStylesheet());
        ConstantPoolGen constantPoolGen = nodeSortRecordFactGenerator.getConstantPool();
        int n = vector.size();
        ArrayList<VariableRefBase> arrayList = new ArrayList<VariableRefBase>();
        for (int i = 0; i < n; ++i) {
            stringArray = (String[])vector.get(i);
            int n2 = stringArray._closureVars == null ? 0 : stringArray._closureVars.size();
            for (int j = 0; j < n2; ++j) {
                constants = (VariableRefBase)stringArray._closureVars.get(j);
                if (arrayList.contains(constants)) continue;
                VariableBase variableBase = ((VariableRefBase)constants).getVariable();
                nodeSortRecordFactGenerator.addField(new Field(1, constantPoolGen.addUtf8(variableBase.getEscapedName()), constantPoolGen.addUtf8(variableBase.getType().toSignature()), null, constantPoolGen.getConstantPool()));
                arrayList.add((VariableRefBase)constants);
            }
        }
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Ljava/lang/String;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/Translet;"), Util.getJCRefType("[Ljava/lang/String;"), Util.getJCRefType("[Ljava/lang/String;"), Util.getJCRefType("[Ljava/lang/String;"), Util.getJCRefType("[Ljava/lang/String;")};
        stringArray = new String[]{"document", "className", "translet", "order", "type", "lang", "case_order"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator2 = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "<init>", string2, instructionList, constantPoolGen);
        instructionList.append(ALOAD_0);
        instructionList.append(ALOAD_1);
        instructionList.append(ALOAD_2);
        instructionList.append(new ALOAD(3));
        instructionList.append(new ALOAD(4));
        instructionList.append(new ALOAD(5));
        instructionList.append(new ALOAD(6));
        instructionList.append(new ALOAD(7));
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V")));
        instructionList.append(RETURN);
        instructionList = new InstructionList();
        constants = new MethodGenerator(1, Util.getJCRefType("Lorg/apache/xalan/xsltc/dom/NodeSortRecord;"), new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT}, new String[]{"node", "last"}, "makeNodeSortRecord", string2, instructionList, constantPoolGen);
        instructionList.append(ALOAD_0);
        instructionList.append(ILOAD_1);
        instructionList.append(ILOAD_2);
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "makeNodeSortRecord", "(II)Lorg/apache/xalan/xsltc/dom/NodeSortRecord;")));
        instructionList.append(DUP);
        instructionList.append(new CHECKCAST(constantPoolGen.addClass(string)));
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            VariableRefBase variableRefBase = (VariableRefBase)arrayList.get(i);
            VariableBase variableBase = variableRefBase.getVariable();
            Type type = variableBase.getType();
            instructionList.append(DUP);
            instructionList.append(ALOAD_0);
            instructionList.append(new GETFIELD(constantPoolGen.addFieldref(string2, variableBase.getEscapedName(), type.toSignature())));
            instructionList.append(new PUTFIELD(constantPoolGen.addFieldref(string, variableBase.getEscapedName(), type.toSignature())));
        }
        instructionList.append(POP);
        instructionList.append(ARETURN);
        methodGenerator2.setMaxLocals();
        methodGenerator2.setMaxStack();
        nodeSortRecordFactGenerator.addMethod(methodGenerator2.getMethod());
        ((MethodGenerator)constants).setMaxLocals();
        ((MethodGen)((Object)constants)).setMaxStack();
        nodeSortRecordFactGenerator.addMethod(((MethodGen)((Object)constants)).getMethod());
        xSLTC.dumpClass(nodeSortRecordFactGenerator.getJavaClass());
        return string2;
    }

    private static String compileSortRecord(Vector vector, ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        XSLTC xSLTC = ((Sort)vector.firstElement()).getXSLTC();
        String string = xSLTC.getHelperClassName();
        NodeSortRecordGenerator nodeSortRecordGenerator = new NodeSortRecordGenerator(string, "org.apache.xalan.xsltc.dom.NodeSortRecord", "sort$0.java", 49, new String[0], classGenerator.getStylesheet());
        ConstantPoolGen constantPoolGen = nodeSortRecordGenerator.getConstantPool();
        int n = vector.size();
        ArrayList<VariableRefBase> arrayList = new ArrayList<VariableRefBase>();
        for (int i = 0; i < n; ++i) {
            object = (Sort)vector.get(i);
            ((Sort)object).setInnerClassName(string);
            int n2 = ((Sort)object)._closureVars == null ? 0 : ((Sort)object)._closureVars.size();
            for (int j = 0; j < n2; ++j) {
                VariableRefBase variableRefBase = (VariableRefBase)((Sort)object)._closureVars.get(j);
                if (arrayList.contains(variableRefBase)) continue;
                VariableBase variableBase = variableRefBase.getVariable();
                nodeSortRecordGenerator.addField(new Field(1, constantPoolGen.addUtf8(variableBase.getEscapedName()), constantPoolGen.addUtf8(variableBase.getType().toSignature()), null, constantPoolGen.getConstantPool()));
                arrayList.add(variableRefBase);
            }
        }
        Method method = Sort.compileInit(vector, nodeSortRecordGenerator, constantPoolGen, string);
        object = Sort.compileExtract(vector, nodeSortRecordGenerator, constantPoolGen, string);
        nodeSortRecordGenerator.addMethod(method);
        nodeSortRecordGenerator.addMethod((Method)object);
        xSLTC.dumpClass(nodeSortRecordGenerator.getJavaClass());
        return string;
    }

    private static Method compileInit(Vector vector, NodeSortRecordGenerator nodeSortRecordGenerator, ConstantPoolGen constantPoolGen, String string) {
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, null, null, "<init>", string, instructionList, constantPoolGen);
        instructionList.append(ALOAD_0);
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.NodeSortRecord", "<init>", "()V")));
        instructionList.append(RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        return methodGenerator.getMethod();
    }

    private static Method compileExtract(Vector vector, NodeSortRecordGenerator nodeSortRecordGenerator, ConstantPoolGen constantPoolGen, String string) {
        InstructionList instructionList = new InstructionList();
        CompareGenerator compareGenerator = new CompareGenerator(17, org.apache.bcel.generic.Type.STRING, new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, Util.getJCRefType("Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;"), org.apache.bcel.generic.Type.INT}, new String[]{"dom", "current", "level", "translet", "last"}, "extractValueFromDOM", string, instructionList, constantPoolGen);
        int n = vector.size();
        int[] nArray = new int[n];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n];
        InstructionHandle instructionHandle = null;
        if (n > 1) {
            instructionList.append(new ILOAD(compareGenerator.getLocalIndex("level")));
            instructionHandle = instructionList.append(new NOP());
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            Sort sort = (Sort)vector.elementAt(i);
            instructionHandleArray[i] = instructionList.append(NOP);
            sort.translateSelect(nodeSortRecordGenerator, compareGenerator);
            instructionList.append(ARETURN);
        }
        if (n > 1) {
            InstructionHandle instructionHandle2 = instructionList.append(new PUSH(constantPoolGen, ""));
            instructionList.insert(instructionHandle, new TABLESWITCH(nArray, instructionHandleArray, instructionHandle2));
            instructionList.append(ARETURN);
        }
        compareGenerator.stripAttributes(true);
        compareGenerator.setMaxLocals();
        compareGenerator.setMaxStack();
        compareGenerator.removeNOPs();
        return compareGenerator.getMethod();
    }
}

