/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Whitespace
extends TopLevelElement {
    public static final int USE_PREDICATE = 0;
    public static final int STRIP_SPACE = 1;
    public static final int PRESERVE_SPACE = 2;
    public static final int RULE_NONE = 0;
    public static final int RULE_ELEMENT = 1;
    public static final int RULE_NAMESPACE = 2;
    public static final int RULE_ALL = 3;
    private String _elementList;
    private int _action;
    private int _importPrecedence;

    Whitespace() {
    }

    public void parseContents(Parser parser2) {
        this._action = this._qname.getLocalPart().endsWith("strip-space") ? 1 : 2;
        this._importPrecedence = parser2.getCurrentImportPrecedence();
        this._elementList = this.getAttribute("elements");
        if (this._elementList == null || this._elementList.length() == 0) {
            this.reportError(this, parser2, "REQUIRED_ATTR_ERR", "elements");
            return;
        }
        SymbolTable symbolTable = parser2.getSymbolTable();
        StringTokenizer stringTokenizer = new StringTokenizer(this._elementList);
        StringBuffer stringBuffer = new StringBuffer("");
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf(58);
            String string2 = n != -1 ? string.substring(0, n) : "";
            String string3 = this.lookupNamespace(string2);
            if (string3 != null) {
                stringBuffer.append(string3 + ":" + string.substring(n + 1, string.length()));
            } else {
                stringBuffer.append(string);
            }
            if (!stringTokenizer.hasMoreElements()) continue;
            stringBuffer.append(" ");
        }
        this._elementList = stringBuffer.toString();
    }

    public Vector getRules() {
        Vector<WhitespaceRule> vector = new Vector<WhitespaceRule>();
        StringTokenizer stringTokenizer = new StringTokenizer(this._elementList);
        while (stringTokenizer.hasMoreElements()) {
            vector.add(new WhitespaceRule(this._action, stringTokenizer.nextToken(), this._importPrecedence));
        }
        return vector;
    }

    private static WhitespaceRule findContradictingRule(Vector vector, WhitespaceRule whitespaceRule) {
        block5: for (int i = 0; i < vector.size(); ++i) {
            WhitespaceRule whitespaceRule2 = (WhitespaceRule)vector.elementAt(i);
            if (whitespaceRule2 == whitespaceRule) {
                return null;
            }
            switch (whitespaceRule2.getStrength()) {
                case 3: {
                    return whitespaceRule2;
                }
                case 1: {
                    if (!whitespaceRule.getElement().equals(whitespaceRule2.getElement())) continue block5;
                }
                case 2: {
                    if (!whitespaceRule.getNamespace().equals(whitespaceRule2.getNamespace())) continue block5;
                    return whitespaceRule2;
                }
            }
        }
        return null;
    }

    private static int prioritizeRules(Vector vector) {
        WhitespaceRule whitespaceRule;
        int n;
        int n2 = 2;
        Whitespace.quicksort(vector, 0, vector.size() - 1);
        boolean bl = false;
        for (n = 0; n < vector.size(); ++n) {
            whitespaceRule = (WhitespaceRule)vector.elementAt(n);
            if (whitespaceRule.getAction() != 1) continue;
            bl = true;
        }
        if (!bl) {
            vector.removeAllElements();
            return 2;
        }
        n = 0;
        while (n < vector.size()) {
            whitespaceRule = (WhitespaceRule)vector.elementAt(n);
            if (Whitespace.findContradictingRule(vector, whitespaceRule) != null) {
                vector.remove(n);
                continue;
            }
            if (whitespaceRule.getStrength() == 3) {
                n2 = whitespaceRule.getAction();
                for (int i = n; i < vector.size(); ++i) {
                    vector.removeElementAt(i);
                }
            }
            ++n;
        }
        if (vector.size() == 0) {
            return n2;
        }
        while ((whitespaceRule = (WhitespaceRule)vector.lastElement()).getAction() == n2) {
            vector.removeElementAt(vector.size() - 1);
            if (vector.size() > 0) continue;
        }
        return n2;
    }

    public static void compileStripSpace(BranchHandle[] branchHandleArray, int n, InstructionList instructionList) {
        InstructionHandle instructionHandle = instructionList.append(ICONST_1);
        instructionList.append(IRETURN);
        for (int i = 0; i < n; ++i) {
            branchHandleArray[i].setTarget(instructionHandle);
        }
    }

    public static void compilePreserveSpace(BranchHandle[] branchHandleArray, int n, InstructionList instructionList) {
        InstructionHandle instructionHandle = instructionList.append(ICONST_0);
        instructionList.append(IRETURN);
        for (int i = 0; i < n; ++i) {
            branchHandleArray[i].setTarget(instructionHandle);
        }
    }

    private static void compilePredicate(Vector vector, int n, ClassGenerator classGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        XSLTC xSLTC = classGenerator.getParser().getXSLTC();
        MethodGenerator methodGenerator = new MethodGenerator(17, org.apache.bcel.generic.Type.BOOLEAN, new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT}, new String[]{"dom", "node", "type"}, "stripSpace", classGenerator.getClassName(), instructionList, constantPoolGen);
        classGenerator.addInterface("org/apache/xalan/xsltc/StripFilter");
        int n2 = methodGenerator.getLocalIndex("dom");
        int n3 = methodGenerator.getLocalIndex("node");
        int n4 = methodGenerator.getLocalIndex("type");
        BranchHandle[] branchHandleArray = new BranchHandle[vector.size()];
        BranchHandle[] branchHandleArray2 = new BranchHandle[vector.size()];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            WhitespaceRule whitespaceRule = (WhitespaceRule)vector.elementAt(i);
            int n7 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getNamespaceName", "(I)Ljava/lang/String;");
            int n8 = constantPoolGen.addMethodref("java/lang/String", "compareTo", "(Ljava/lang/String;)I");
            if (whitespaceRule.getStrength() == 2) {
                instructionList.append(new ALOAD(n2));
                instructionList.append(new ILOAD(n3));
                instructionList.append(new INVOKEINTERFACE(n7, 2));
                instructionList.append(new PUSH(constantPoolGen, whitespaceRule.getNamespace()));
                instructionList.append(new INVOKEVIRTUAL(n8));
                instructionList.append(ICONST_0);
                if (whitespaceRule.getAction() == 1) {
                    branchHandleArray[n5++] = instructionList.append(new IF_ICMPEQ(null));
                    continue;
                }
                branchHandleArray2[n6++] = instructionList.append(new IF_ICMPEQ(null));
                continue;
            }
            if (whitespaceRule.getStrength() != 1) continue;
            Parser parser2 = classGenerator.getParser();
            QName qName = whitespaceRule.getNamespace() != "" ? parser2.getQName(whitespaceRule.getNamespace(), null, whitespaceRule.getElement()) : parser2.getQName(whitespaceRule.getElement());
            int n9 = xSLTC.registerElement(qName);
            instructionList.append(new ILOAD(n4));
            instructionList.append(new PUSH(constantPoolGen, n9));
            if (whitespaceRule.getAction() == 1) {
                branchHandleArray[n5++] = instructionList.append(new IF_ICMPEQ(null));
                continue;
            }
            branchHandleArray2[n6++] = instructionList.append(new IF_ICMPEQ(null));
        }
        if (n == 1) {
            Whitespace.compileStripSpace(branchHandleArray, n5, instructionList);
            Whitespace.compilePreserveSpace(branchHandleArray2, n6, instructionList);
        } else {
            Whitespace.compilePreserveSpace(branchHandleArray2, n6, instructionList);
            Whitespace.compileStripSpace(branchHandleArray, n5, instructionList);
        }
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    private static void compileDefault(int n, ClassGenerator classGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        XSLTC xSLTC = classGenerator.getParser().getXSLTC();
        MethodGenerator methodGenerator = new MethodGenerator(17, org.apache.bcel.generic.Type.BOOLEAN, new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT}, new String[]{"dom", "node", "type"}, "stripSpace", classGenerator.getClassName(), instructionList, constantPoolGen);
        classGenerator.addInterface("org/apache/xalan/xsltc/StripFilter");
        if (n == 1) {
            instructionList.append(ICONST_1);
        } else {
            instructionList.append(ICONST_0);
        }
        instructionList.append(IRETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    public static int translateRules(Vector vector, ClassGenerator classGenerator) {
        int n = Whitespace.prioritizeRules(vector);
        if (vector.size() == 0) {
            Whitespace.compileDefault(n, classGenerator);
            return n;
        }
        Whitespace.compilePredicate(vector, n, classGenerator);
        return 0;
    }

    private static void quicksort(Vector vector, int n, int n2) {
        while (n < n2) {
            int n3 = Whitespace.partition(vector, n, n2);
            Whitespace.quicksort(vector, n, n3);
            n = n3 + 1;
        }
    }

    private static int partition(Vector vector, int n, int n2) {
        WhitespaceRule whitespaceRule = (WhitespaceRule)vector.elementAt(n + n2 >>> 1);
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (whitespaceRule.compareTo((WhitespaceRule)vector.elementAt(--n4)) < 0) {
                continue;
            }
            while (whitespaceRule.compareTo((WhitespaceRule)vector.elementAt(++n3)) > 0) {
            }
            if (n3 >= n4) break;
            WhitespaceRule whitespaceRule2 = (WhitespaceRule)vector.elementAt(n3);
            vector.setElementAt(vector.elementAt(n4), n3);
            vector.setElementAt(whitespaceRule2, n4);
        }
        return n4;
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        return Type.Void;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
    }

    private static final class WhitespaceRule {
        private final int _action;
        private String _namespace;
        private String _element;
        private int _type;
        private int _priority;

        public WhitespaceRule(int n, String string, int n2) {
            this._action = n;
            int n3 = string.indexOf(58);
            if (n3 >= 0) {
                this._namespace = string.substring(0, n3);
                this._element = string.substring(n3 + 1, string.length());
            } else {
                this._namespace = "";
                this._element = string;
            }
            this._priority = n2 << 2;
            if (this._element.equals("*")) {
                if (this._namespace == "") {
                    this._type = 3;
                    this._priority += 2;
                } else {
                    this._type = 2;
                    ++this._priority;
                }
            } else {
                this._type = 1;
            }
        }

        public int compareTo(WhitespaceRule whitespaceRule) {
            return this._priority < whitespaceRule._priority ? -1 : (this._priority > whitespaceRule._priority ? 1 : 0);
        }

        public int getAction() {
            return this._action;
        }

        public int getStrength() {
            return this._type;
        }

        public int getPriority() {
            return this._priority;
        }

        public String getElement() {
            return this._element;
        }

        public String getNamespace() {
            return this._namespace;
        }
    }
}

