/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Type;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;

final class SlotAllocator {
    private int _firstAvailableSlot;
    private int _size = 8;
    private int _free = 0;
    private int[] _slotsTaken = new int[this._size];

    SlotAllocator() {
    }

    public void initialize(LocalVariableGen[] localVariableGenArray) {
        int n = localVariableGenArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = localVariableGenArray[i].getType().getSize();
            int n4 = localVariableGenArray[i].getIndex();
            n2 = Math.max(n2, n4 + n3);
        }
        this._firstAvailableSlot = n2;
    }

    public int allocateSlot(Type type) {
        int n = type.getSize();
        int n2 = this._free;
        int n3 = this._firstAvailableSlot;
        int n4 = 0;
        if (this._free + n > this._size) {
            int[] nArray = new int[this._size *= 2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this._slotsTaken[i];
            }
            this._slotsTaken = nArray;
        }
        while (n4 < n2) {
            if (n3 + n <= this._slotsTaken[n4]) {
                for (int i = n2 - 1; i >= n4; --i) {
                    this._slotsTaken[i + n] = this._slotsTaken[i];
                }
                break;
            }
            n3 = this._slotsTaken[n4++] + 1;
        }
        for (int i = 0; i < n; ++i) {
            this._slotsTaken[n4 + i] = n3 + i;
        }
        this._free += n;
        return n3;
    }

    public void releaseSlot(LocalVariableGen localVariableGen) {
        int n = localVariableGen.getType().getSize();
        int n2 = localVariableGen.getIndex();
        int n3 = this._free;
        for (int i = 0; i < n3; ++i) {
            if (this._slotsTaken[i] != n2) continue;
            int n4 = i + n;
            while (n4 < n3) {
                this._slotsTaken[i++] = this._slotsTaken[n4++];
            }
            this._free -= n;
            return;
        }
        String string = "Variable slot allocation error(size=" + n + ", slot=" + n2 + ", limit=" + n3 + ")";
        ErrorMsg errorMsg = new ErrorMsg("INTERNAL_ERR", string);
        throw new Error(errorMsg.toString());
    }
}

