/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.dom.NodeCounter;
import org.apache.xml.dtm.DTMAxisIterator;

public abstract class AnyNodeCounter
extends NodeCounter {
    public AnyNodeCounter(Translet translet, DOM dOM, DTMAxisIterator dTMAxisIterator) {
        super(translet, dOM, dTMAxisIterator);
    }

    public NodeCounter setStartNode(int n) {
        this._node = n;
        this._nodeType = this._document.getExpandedTypeID(n);
        return this;
    }

    public String getCounter() {
        if (this._value != -2.147483648E9) {
            if (this._value == 0.0) {
                return "0";
            }
            if (Double.isNaN(this._value)) {
                return "NaN";
            }
            if (this._value < 0.0 && Double.isInfinite(this._value)) {
                return "-Infinity";
            }
            if (Double.isInfinite(this._value)) {
                return "Infinity";
            }
            return this.formatNumbers((int)this._value);
        }
        int n = this._document.getDocument();
        int n2 = 0;
        for (int i = this._node; i >= n && !this.matchesFrom(i); --i) {
            if (!this.matchesCount(i)) continue;
            ++n2;
        }
        return this.formatNumbers(n2);
    }

    public static NodeCounter getDefaultNodeCounter(Translet translet, DOM dOM, DTMAxisIterator dTMAxisIterator) {
        return new DefaultAnyNodeCounter(translet, dOM, dTMAxisIterator);
    }

    static class DefaultAnyNodeCounter
    extends AnyNodeCounter {
        public DefaultAnyNodeCounter(Translet translet, DOM dOM, DTMAxisIterator dTMAxisIterator) {
            super(translet, dOM, dTMAxisIterator);
        }

        public String getCounter() {
            int n;
            if (this._value != -2.147483648E9) {
                if (this._value == 0.0) {
                    return "0";
                }
                if (Double.isNaN(this._value)) {
                    return "NaN";
                }
                if (this._value < 0.0 && Double.isInfinite(this._value)) {
                    return "-Infinity";
                }
                if (Double.isInfinite(this._value)) {
                    return "Infinity";
                }
                n = (int)this._value;
            } else {
                n = 0;
                int n2 = this._document.getExpandedTypeID(this._node);
                int n3 = this._document.getDocument();
                for (int i = this._node; i >= 0; --i) {
                    if (n2 == this._document.getExpandedTypeID(i)) {
                        ++n;
                    }
                    if (i == n3) break;
                }
            }
            return this.formatNumbers(n);
        }
    }
}

