/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.util;

import java.io.PrintStream;

public final class IntegerArray {
    private static final int InitialSize = 32;
    private int[] _array;
    private int _size;
    private int _free = 0;

    public IntegerArray() {
        this(32);
    }

    public IntegerArray(int n) {
        this._size = n;
        this._array = new int[this._size];
    }

    public IntegerArray(int[] nArray) {
        this(nArray.length);
        this._free = this._size;
        System.arraycopy(nArray, 0, this._array, 0, this._free);
    }

    public void clear() {
        this._free = 0;
    }

    public Object clone() {
        IntegerArray integerArray = new IntegerArray(this._free > 0 ? this._free : 1);
        System.arraycopy(this._array, 0, integerArray._array, 0, this._free);
        integerArray._free = this._free;
        return integerArray;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.cardinality()];
        System.arraycopy(this._array, 0, nArray, 0, this.cardinality());
        return nArray;
    }

    public final int at(int n) {
        return this._array[n];
    }

    public final void set(int n, int n2) {
        this._array[n] = n2;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this._free; ++i) {
            if (n != this._array[i]) continue;
            return i;
        }
        return -1;
    }

    public final void add(int n) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = n;
    }

    public void addNew(int n) {
        for (int i = 0; i < this._free; ++i) {
            if (this._array[i] != n) continue;
            return;
        }
        this.add(n);
    }

    public void reverse() {
        int n = 0;
        int n2 = this._free - 1;
        while (n < n2) {
            int n3 = this._array[n];
            this._array[n++] = this._array[n2];
            this._array[n2--] = n3;
        }
    }

    public void merge(IntegerArray integerArray) {
        int n = this._free + integerArray._free;
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < this._free && n3 < integerArray._free) {
            int n5 = this._array[n2];
            int n6 = integerArray._array[n3];
            if (n5 < n6) {
                nArray[n4] = n5;
                ++n2;
            } else if (n5 > n6) {
                nArray[n4] = n6;
                ++n3;
            } else {
                nArray[n4] = n5;
                ++n2;
                ++n3;
            }
            ++n4;
        }
        if (n2 >= this._free) {
            while (n3 < integerArray._free) {
                nArray[n4++] = integerArray._array[n3++];
            }
        } else {
            while (n2 < this._free) {
                nArray[n4++] = this._array[n2++];
            }
        }
        this._array = nArray;
        this._free = this._size = n;
    }

    public void sort() {
        IntegerArray.quicksort(this._array, 0, this._free - 1);
    }

    private static void quicksort(int[] nArray, int n, int n2) {
        if (n < n2) {
            int n3 = IntegerArray.partition(nArray, n, n2);
            IntegerArray.quicksort(nArray, n, n3);
            IntegerArray.quicksort(nArray, n3 + 1, n2);
        }
    }

    private static int partition(int[] nArray, int n, int n2) {
        int n3 = nArray[n + n2 >>> 1];
        int n4 = n - 1;
        int n5 = n2 + 1;
        while (true) {
            if (n3 < nArray[--n5]) {
                continue;
            }
            while (n3 > nArray[++n4]) {
            }
            if (n4 >= n5) break;
            int n6 = nArray[n4];
            nArray[n4] = nArray[n5];
            nArray[n5] = n6;
        }
        return n5;
    }

    private void growArray(int n) {
        this._size = n;
        int[] nArray = new int[this._size];
        System.arraycopy(this._array, 0, nArray, 0, this._free);
        this._array = nArray;
    }

    public int popLast() {
        return this._array[--this._free];
    }

    public int last() {
        return this._array[this._free - 1];
    }

    public void setLast(int n) {
        this._array[this._free - 1] = n;
    }

    public void pop() {
        --this._free;
    }

    public void pop(int n) {
        this._free -= n;
    }

    public final int cardinality() {
        return this._free;
    }

    public void print(PrintStream printStream) {
        if (this._free > 0) {
            for (int i = 0; i < this._free - 1; ++i) {
                printStream.print(this._array[i]);
                printStream.print(' ');
            }
            printStream.println(this._array[this._free - 1]);
        } else {
            printStream.println("IntegerArray: empty");
        }
    }
}

