/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;

public class BlockGraphViewer
extends GraphViewer {
    public int maxRows;
    public int maxColumns;
    public JPanel buttonPanel;
    public JButton button;
    public JButton allButton;
    public JButton noneButton;
    private boolean[] visibles;
    private Color[] colors = new Color[]{Color.black, Color.blue, Color.red, Color.yellow, Color.orange, Color.magenta, Color.cyan, Color.pink, Color.green, Color.gray, Color.lightGray, Color.darkGray};

    public BlockGraphViewer(JFrame jFrame, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, double d3, double d4, int n7, int n8, int n9, int n10, String string, String string2, String string3) {
        super(jFrame, n3, n4, n5, n6, d, d2, d3, d4, n7, n8, n9, n10, string, string2, string3);
        int n11;
        this.maxRows = n;
        this.maxColumns = n2;
        this.generatePalette();
        this.visibles = new boolean[n * n2];
        for (n11 = 0; n11 < this.visibles.length; ++n11) {
            this.visibles[n11] = true;
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.allButton = new JButton("All");
        this.allButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < BlockGraphViewer.this.visibles.length; ++i) {
                    ((BlockGraphViewer)BlockGraphViewer.this).visibles[i] = true;
                }
                BlockGraphViewer.this.repaint();
            }
        });
        this.gba.add(this.buttonPanel, this.allButton, 0, 0, 1, 1, 1, 1, 1, 10);
        this.noneButton = new JButton("None");
        this.noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < BlockGraphViewer.this.visibles.length; ++i) {
                    ((BlockGraphViewer)BlockGraphViewer.this).visibles[i] = false;
                }
                BlockGraphViewer.this.repaint();
            }
        });
        this.gba.add(this.buttonPanel, this.noneButton, 1, 0, 1, 1, 1, 1, 1, 10);
        for (n11 = 0; n11 < n; ++n11) {
            for (int i = 0; i < n2; ++i) {
                this.button = new JButton(i + 1 + ", " + (n11 + 1));
                final int n12 = n2 * n11 + i;
                if (n11 == 0 && i == 0) {
                    this.button.setForeground(Color.white);
                }
                this.button.setBackground(this.colors[n12]);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((BlockGraphViewer)BlockGraphViewer.this).visibles[n12] = !BlockGraphViewer.this.visibles[n12];
                        BlockGraphViewer.this.repaint();
                    }
                });
                this.gba.add(this.buttonPanel, this.button, i, n11 + 1, 1, 1, 1, 1, 1, 10);
            }
        }
        jFrame.getContentPane().add(this.buttonPanel);
    }

    public void generatePalette() {
        int n = this.maxColumns * this.maxRows;
        if (n != 12) {
            int n2 = 0;
            while (n2 * n2 * n2 < n) {
                ++n2;
            }
            this.colors = new Color[n2 * n2 * n2];
            for (int i = n2 - 1; i >= 0; --i) {
                for (int j = n2 - 1; j >= 0; --j) {
                    for (int k = n2 - 1; k >= 0; --k) {
                        this.colors[i * n2 * n2 + j * n2 + k] = new Color((int)((double)i * 255.0 / (double)(n2 - 1)), (int)((double)j * 255.0 / (double)(n2 - 1)), (int)((double)k * 255.0 / (double)(n2 - 1)));
                    }
                }
            }
        }
    }

    public Color[] getColors() {
        return this.colors;
    }

    public boolean[] getVisibles() {
        return this.visibles;
    }

    public void drawGraph(Graphics2D graphics2D) {
        int n;
        int n2;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawSystem(graphics2D, 1100);
        for (n2 = 0; n2 < this.graphElements.size(); ++n2) {
            GraphElement graphElement = (GraphElement)this.graphElements.elementAt(n2);
            if (graphElement instanceof GraphPoint) {
                for (n = 0; n < this.visibles.length; ++n) {
                    if (!this.visibles[n] || ((GraphPoint)graphElement).getColor() != this.colors[n]) continue;
                    this.drawPoint(graphics2D, (GraphPoint)graphElement);
                }
                continue;
            }
            if (graphElement instanceof GraphBar) {
                this.drawBar(graphics2D, (GraphBar)graphElement);
                continue;
            }
            if (graphElement instanceof GraphTick) {
                this.drawTick(graphics2D, (GraphTick)graphElement);
                continue;
            }
            if (!(graphElement instanceof GraphLine)) continue;
            this.drawLine(graphics2D, (GraphLine)graphElement);
        }
        if (this.referenceLinesOn) {
            n2 = this.getXOldEvent();
            n = this.getYOldEvent();
            if (n2 <= this.convertX(this.graphstopx) && n2 >= this.convertX(this.graphstartx)) {
                graphics2D.setColor(Color.magenta);
                graphics2D.drawLine(n2, this.convertY(this.graphstarty), n2, this.convertY(this.graphstopy));
            }
            if (n >= this.convertY(this.graphstopy) && n <= this.convertY(this.graphstarty)) {
                graphics2D.setColor(Color.magenta);
                graphics2D.drawLine(this.convertX(this.graphstartx), n, this.convertX(this.graphstopx), n);
            }
        }
        this.drawXLabel(graphics2D, this.xLabel, Color.black);
        this.drawYLabel(graphics2D, this.yLabel, Color.black);
        this.drawTitle(graphics2D, this.title, Color.black);
    }
}

