/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.MultipleArrayHeader;
import org.tigr.microarray.mev.Thumbnail;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.FloatMatrix;

public class MultipleArrayCanvas
extends JPanel
implements IViewer {
    private static final int TRACE_SPACE = 50;
    private MultipleArrayHeader header;
    private Thumbnail thumbnail;
    private boolean isShowThumbnail = false;
    private IFramework framework;
    protected IData data;
    private Insets insets;
    private int maxLabelWidth = 0;
    protected int paletteStyle;
    private boolean isGRScale;
    private boolean isDrawBorders;
    private boolean isTracing;
    private boolean isAntiAliasing = true;
    private Dimension elementSize = new Dimension();
    private int labelIndex = -1;
    private boolean drawChain = false;
    private int[] chain;
    private int features;
    private int probes;
    private float maxCY3;
    private float maxCY5;
    private float maxRatio;
    private float minRatio;
    public static Color missingColor = Color.gray;
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    private int xOffset = 10;

    public MultipleArrayCanvas(IFramework iFramework, Insets insets) {
        this.framework = iFramework;
        this.setBackground(Color.white);
        this.insets = insets;
        this.header = new MultipleArrayHeader(insets, 50);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addKeyListener(listener);
        this.thumbnail = new Thumbnail(iFramework, listener);
        this.negColorImage = iFramework.getDisplayMenu().getNegativeGradientImage();
        this.posColorImage = iFramework.getDisplayMenu().getPositiveGradientImage();
        this.header.setNegativeAndPositiveColorImages(this.negColorImage, this.posColorImage);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.maxCY3 = iDisplayMenu.getMaxCY3Scale();
        this.maxCY5 = iDisplayMenu.getMaxCY5Scale();
        this.maxRatio = iDisplayMenu.getMaxRatioScale();
        this.minRatio = iDisplayMenu.getMinRatioScale();
        this.header.setMinAndMaxRatios(this.minRatio, this.maxRatio);
        this.header.setData(this.data);
        this.onMenuChanged(iDisplayMenu);
        this.onDataChanged(this.data);
        if (this.isShowThumbnail) {
            this.thumbnail.show();
        }
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.features = iData.getFeaturesCount();
        this.probes = iData.getFeaturesSize();
        this.setDrawChain(false);
        this.updateSize();
        this.header.setData(iData);
        this.thumbnail.onDataChanged(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.paletteStyle = iDisplayMenu.getPaletteStyle();
        this.isGRScale = iDisplayMenu.isGRScale();
        this.isDrawBorders = iDisplayMenu.isDrawingBorder();
        this.isTracing = iDisplayMenu.isTracing();
        Dimension dimension = iDisplayMenu.getElementSize();
        this.elementSize = new Dimension(dimension);
        this.maxCY3 = iDisplayMenu.getMaxCY3Scale();
        this.maxCY5 = iDisplayMenu.getMaxCY5Scale();
        this.maxRatio = iDisplayMenu.getMaxRatioScale();
        this.minRatio = iDisplayMenu.getMinRatioScale();
        this.header.setMinAndMaxRatios(this.minRatio, this.maxRatio);
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.header.setNegativeAndPositiveColorImages(this.negColorImage, this.posColorImage);
        this.updateSize();
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.setFont(new Font("monospaced", 1, this.elementSize.height));
        this.updateSize();
        this.header.setTracing(this.isTracing);
        this.header.setElementWidth(this.elementSize.width);
        this.thumbnail.onMenuChanged(iDisplayMenu);
    }

    public void onDeselected() {
        this.thumbnail.hide();
    }

    public void onClosed() {
        this.thumbnail.dispose();
    }

    public void onShowThumbnail() {
        this.isShowThumbnail = true;
        this.thumbnail.show();
    }

    public boolean isThumbnailEnabled() {
        return this.data.getFeaturesCount() > 0;
    }

    public BufferedImage getImage() {
        return null;
    }

    private void updateSize() {
        this.updateMaxLabelWidth();
        int n = this.insets.left + this.getXSize() + this.insets.right + this.getMaxLabelWidth() + 20;
        int n2 = this.insets.top + this.getYSize() + this.insets.bottom;
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
        this.header.setContentWidth(this.getSize().width);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        super.paint(graphics);
        graphics.setColor(Color.black);
        if (this.features == 0 || this.framework == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawColumns(graphics2D);
    }

    private void drawColumns(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = this.getTopIndex(rectangle.y);
        int n2 = this.getBottomIndex(rectangle.y + rectangle.height, this.probes);
        int n3 = this.getLeftIndex(rectangle.x);
        int n4 = this.getRightIndex(rectangle.x + rectangle.width, this.features);
        for (int i = n3; i < n4; ++i) {
            this.drawColumn(graphics2D, i, n, n2);
        }
        if (this.isDrawChain()) {
            this.drawChain(graphics2D, Color.magenta, this.getChain(), n3, n4);
        }
        if (n4 >= this.features && this.labelIndex >= 0) {
            this.drawLabels(graphics2D, n, n2);
        }
    }

    private void drawColumn(Graphics2D graphics2D, int n, int n2, int n3) {
        int[] nArray = this.data.getSortedIndices(n);
        for (int i = n2; i < n3; ++i) {
            this.drawSlideDataElement(graphics2D, i, n, nArray);
        }
    }

    private boolean isMissingValue(int n, int n2) {
        boolean bl = false;
        FloatMatrix floatMatrix = this.data.getExperiment().getMatrix();
        if (Float.isNaN(floatMatrix.get(n, n2))) {
            bl = true;
        }
        return bl;
    }

    private void drawSlideDataElement(Graphics graphics, int n, int n2, int[] nArray) {
        float f = this.data.getCY3(n2, nArray[n]);
        float f2 = this.data.getCY5(n2, nArray[n]);
        switch (this.paletteStyle) {
            case 3: {
                int n3 = this.insets.left + n2 * (this.elementSize.width + this.getSpacing());
                int n4 = this.insets.top + n * this.elementSize.height;
                Color color = this.getOverlayColor(f, f2);
                graphics.setColor(color);
                graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
                break;
            }
            case 4: {
                float f3 = this.data.getRatio(n2, nArray[n], 1);
                graphics.setColor(this.getColor(f3));
                graphics.fillRect(this.insets.left + n2 * (this.elementSize.width + this.getSpacing()), this.insets.top + n * this.elementSize.height, this.elementSize.width, this.elementSize.height);
                break;
            }
            case 2: {
                if (f <= 0.0f && f2 <= 0.0f) {
                    graphics.setColor(missingColor);
                    graphics.fillRect(this.insets.left + n2 * (this.elementSize.width + this.getSpacing()), this.insets.top + n * this.elementSize.height, this.elementSize.width, this.elementSize.height);
                    break;
                }
                int n5 = (int)((float)this.elementSize.width * f / (f + f2));
                graphics.setColor(this.getNegativeColor(f));
                graphics.fillRect(this.insets.left + n2 * (this.elementSize.width + this.getSpacing()), this.insets.top + n * this.elementSize.height, n5, this.elementSize.height);
                graphics.setColor(this.getPositiveColor(f2));
                graphics.fillRect(this.insets.left + n2 * (this.elementSize.width + this.getSpacing()) + n5, this.insets.top + n * this.elementSize.height, this.elementSize.width - n5, this.elementSize.height);
            }
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(this.getXPos(n2), this.getYPos(n) + this.insets.top, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    protected Color getColor(float f) {
        if (Float.isNaN(f)) {
            return missingColor;
        }
        float f2 = f < 0.0f ? this.minRatio : this.maxRatio;
        int n = (int)(255.0f * f / f2);
        n = n > 255 ? 255 : n;
        int n2 = f < 0.0f ? this.negColorImage.getRGB(255 - n, 0) : this.posColorImage.getRGB(n, 0);
        return new Color(n2);
    }

    protected Color getNegativeColor(float f) {
        float f2 = f / this.maxCY3;
        int n = 0;
        int n2 = (int)(255.0f * f / this.maxCY3);
        n2 = Math.min(n2, 255);
        n = this.isGRScale ? this.negColorImage.getRGB(255 - n2, 0) : this.negColorImage.getRGB(0, 0);
        return new Color(n);
    }

    protected Color getPositiveColor(float f) {
        float f2 = f / this.maxCY3;
        int n = 0;
        int n2 = (int)(255.0f * f / this.maxCY5);
        n2 = Math.min(n2, 255);
        n = this.isGRScale ? this.posColorImage.getRGB(n2, 0) : this.posColorImage.getRGB(255, 0);
        return new Color(n);
    }

    protected Color getOverlayColor(float f, float f2) {
        Color color = this.getNegativeColor(f);
        Color color2 = this.getPositiveColor(f2);
        double d = f / (f + f2);
        double d2 = f2 / (f + f2);
        int n = color.getRed() + color2.getRed();
        n = n < 256 ? n : 255;
        int n2 = color.getGreen() + color2.getGreen();
        n2 = n2 < 256 ? n2 : 255;
        int n3 = color.getBlue() + color2.getBlue();
        n3 = n3 < 256 ? n3 : 255;
        return new Color(n, n2, n3);
    }

    private BufferedImage getOverlayImage(float f, float f2) {
        Color color = this.getNegativeColor(f);
        Color color2 = this.getPositiveColor(f2);
        BufferedImage bufferedImage = new BufferedImage(this.elementSize.width, this.elementSize.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.elementSize.width, this.elementSize.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, this.elementSize.width, this.elementSize.height);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, this.elementSize.width, this.elementSize.height);
        return bufferedImage;
    }

    private void setDrawChain(boolean bl) {
        this.drawChain = bl;
        this.repaint();
    }

    private boolean isDrawChain() {
        return this.drawChain;
    }

    private void setChain(int[] nArray) {
        this.chain = nArray;
    }

    private void doChain(int n, int n2) {
        this.setChain(this.createChain(n, n2));
    }

    private int[] getChain() {
        return this.chain;
    }

    private int[] createChain(int n, int n2) {
        int[] nArray = this.data.getSortedIndices(n2);
        int n3 = this.data.getProbeColumn(n2, nArray[n]);
        int n4 = this.data.getProbeRow(n2, nArray[n]);
        int[] nArray2 = new int[this.data.getFeaturesCount()];
        int n5 = this.data.getFeaturesSize();
        block0: for (int i = 0; i < nArray2.length; ++i) {
            if (i == n2) {
                nArray2[n2] = n;
                continue;
            }
            nArray = this.data.getSortedIndices(i);
            for (int j = 0; j < n5; ++j) {
                if (this.data.getProbeColumn(i, nArray[j]) != n3 || this.data.getProbeRow(i, nArray[j]) != n4) continue;
                nArray2[i] = j;
                continue block0;
            }
        }
        return nArray2;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return 50;
        }
        return 0;
    }

    private int getXSize() {
        return this.features * this.elementSize.width + (this.features - 1) * this.getSpacing();
    }

    private int getYSize() {
        return this.probes * this.elementSize.height;
    }

    private void updateMaxLabelWidth() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (this.labelIndex < 0) {
            this.maxLabelWidth = fontMetrics.stringWidth("");
            return;
        }
        double d = 0.0;
        int n = this.data.getFeaturesSize();
        for (int i = 0; i < n; ++i) {
            String string = this.data.getElementAttribute(i, this.labelIndex);
            d = Math.max(d, (double)fontMetrics.stringWidth(string));
        }
        this.maxLabelWidth = (int)d;
    }

    private int getMaxLabelWidth() {
        return this.maxLabelWidth;
    }

    private void drawLabels(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(Color.black);
        int[] nArray = this.data.getSortedIndices(0);
        for (int i = n; i < n2; ++i) {
            String string = this.data.getElementAttribute(nArray[i], this.labelIndex);
            if (string == null) continue;
            graphics2D.drawString(string, this.insets.left + this.getXSize() + this.insets.right, this.insets.top + (i + 1) * this.elementSize.height - 1);
        }
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < this.insets.left) {
            return 0;
        }
        return (n - this.insets.left) / (this.elementSize.width + this.getSpacing());
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / (this.elementSize.width + this.getSpacing()) + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    private void drawLink(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        double d = (double)n + 0.5;
        double d2 = (double)n3 + 0.5;
        graphics2D.setColor(color);
        graphics2D.drawLine(this.insets.left + this.elementSize.width + n2 * (this.elementSize.width + this.getSpacing()), this.insets.top + (int)(d * (double)this.elementSize.height), this.insets.left + n4 * (this.elementSize.width + this.getSpacing()) - 1, this.insets.top + (int)(d2 * (double)this.elementSize.height));
    }

    private float getGreenValue(float f) {
        if (this.isGRScale) {
            float f2 = Math.abs(f / this.maxCY3);
            return f2 > 1.0f ? 1.0f : f2;
        }
        if (f == 0.0f) {
            return 0.0f;
        }
        return 1.0f;
    }

    private float getRedValue(float f) {
        if (this.isGRScale) {
            float f2 = Math.abs(f / this.maxCY5);
            return f2 > 1.0f ? 1.0f : f2;
        }
        if (f == 0.0f) {
            return 0.0f;
        }
        return 1.0f;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.features - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.probes - 1;
    }

    private int findColumn(int n) {
        int n2 = this.elementSize.width + this.getSpacing();
        if (n >= this.features * n2 - this.getSpacing() + this.insets.left || n < this.insets.left) {
            return -1;
        }
        return (n - this.insets.left) / n2;
    }

    private int findRow(int n) {
        int n2 = this.probes * this.elementSize.height;
        if ((n -= this.insets.top) >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.height;
    }

    private int getXPos(int n) {
        return n * (this.elementSize.width + this.getSpacing()) + this.insets.left;
    }

    private int getYPos(int n) {
        return n * this.elementSize.height;
    }

    private void drawColoredBoxAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        graphics.drawRect(this.insets.left + n2 * (this.elementSize.width + this.getSpacing()), this.insets.top + n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void drawChain(Graphics2D graphics2D, Color color, int[] nArray, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2; ++n3) {
            this.drawColoredBoxAt(graphics2D, nArray[n3], n3, color);
        }
        n3 = n2 == nArray.length ? n2 - 1 : n2;
        for (int i = n; i < n3; ++i) {
            this.drawLink(graphics2D, nArray[i], i, nArray[i + 1], i + 1, color);
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener,
    WindowListener {
        private int oldRow = -1;
        private int oldColumn = -1;

        private Listener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MultipleArrayCanvas.this.requestFocus();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = MultipleArrayCanvas.this.findColumn(mouseEvent.getX());
            int n2 = MultipleArrayCanvas.this.findRow(mouseEvent.getY());
            if (!MultipleArrayCanvas.this.isLegalPosition(n2, n)) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                MultipleArrayCanvas.this.framework.displaySingleArrayViewer(n);
                return;
            }
            if (!mouseEvent.isShiftDown()) {
                int[] nArray = MultipleArrayCanvas.this.data.getSortedIndices(n);
                MultipleArrayCanvas.this.framework.displaySlideElementInfo(n, nArray[n2]);
                return;
            }
            MultipleArrayCanvas.this.doChain(n2, n);
            MultipleArrayCanvas.this.setDrawChain(true);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (MultipleArrayCanvas.this.features == 0 || mouseEvent.isShiftDown()) {
                return;
            }
            int n = MultipleArrayCanvas.this.findColumn(mouseEvent.getX());
            int n2 = MultipleArrayCanvas.this.findRow(mouseEvent.getY());
            if (this.isCurrentPosition(n2, n)) {
                return;
            }
            Graphics graphics = null;
            if (MultipleArrayCanvas.this.isLegalPosition(n2, n)) {
                graphics = MultipleArrayCanvas.this.getGraphics();
                MultipleArrayCanvas.this.drawColoredBoxAt(graphics, n2, n, Color.white);
            }
            if (MultipleArrayCanvas.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                graphics = graphics != null ? graphics : MultipleArrayCanvas.this.getGraphics();
                MultipleArrayCanvas.this.drawSlideDataElement(graphics, this.oldRow, this.oldColumn, MultipleArrayCanvas.this.data.getSortedIndices(this.oldColumn));
            }
            this.setOldPosition(n2, n);
            if (graphics != null) {
                graphics.dispose();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (MultipleArrayCanvas.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics graphics = MultipleArrayCanvas.this.getGraphics();
                MultipleArrayCanvas.this.drawSlideDataElement(graphics, this.oldRow, this.oldColumn, MultipleArrayCanvas.this.data.getSortedIndices(this.oldColumn));
                graphics.dispose();
            }
            this.setOldPosition(-1, -1);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16 && MultipleArrayCanvas.this.isDrawChain()) {
                MultipleArrayCanvas.this.setDrawChain(false);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void setOldPosition(int n, int n2) {
            this.oldColumn = n2;
            this.oldRow = n;
        }

        private boolean isCurrentPosition(int n, int n2) {
            return n == this.oldRow && n2 == this.oldColumn;
        }

        public void windowClosing(WindowEvent windowEvent) {
            MultipleArrayCanvas.this.isShowThumbnail = false;
            MultipleArrayCanvas.this.thumbnail.hide();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

