/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.awt.GBA;

public class SetDatabaseDialog
extends JDialog {
    private int result;
    private JComboBox dbChoice;

    public SetDatabaseDialog(Frame frame) {
        super(frame, "Select a Database", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JLabel jLabel = new JLabel("Select a Database: ");
        this.dbChoice = new JComboBox();
        String[] stringArray = TMEV.getDatabases();
        for (int i = 0; i < stringArray.length; ++i) {
            this.dbChoice.addItem(stringArray[i]);
        }
        this.dbChoice.addKeyListener(listener);
        JButton jButton = new JButton("OK");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(listener);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(listener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GBA gBA = new GBA();
        gBA.add(container, jLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(container, this.dbChoice, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(container, jButton2, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(container, jButton, 1, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setResizable(false);
        this.dbChoice.grabFocus();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getDatabase() {
        return (String)this.dbChoice.getSelectedItem();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                this.onOk();
            } else if (string.equals("cancel-command")) {
                SetDatabaseDialog.this.result = 2;
                SetDatabaseDialog.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetDatabaseDialog.this.result = -1;
            SetDatabaseDialog.this.dispose();
        }

        private void onOk() {
            SetDatabaseDialog.this.result = 0;
            SetDatabaseDialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

