/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetRatioScaleDialog
extends JDialog {
    private int result;
    private JTextField upperTextField;
    private JTextField lowerTextField;

    public SetRatioScaleDialog(JFrame jFrame, float f, float f2) {
        super(jFrame, "Set Ratio Scale", true);
        EventListener eventListener = new EventListener();
        JLabel jLabel = new JLabel("Upper value (" + f + "): ");
        jLabel.addKeyListener(eventListener);
        this.upperTextField = new JTextField(10);
        this.upperTextField.addKeyListener(eventListener);
        this.upperTextField.setText("" + f);
        JLabel jLabel2 = new JLabel("Lower value (" + f2 + "): ");
        jLabel2.addKeyListener(eventListener);
        this.lowerTextField = new JTextField(10);
        this.lowerTextField.addKeyListener(eventListener);
        this.lowerTextField.setText("" + f2);
        JButton jButton = new JButton("Ok");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(eventListener);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(eventListener);
        this.getContentPane().setLayout(new GridBagLayout());
        GBA gBA = new GBA();
        gBA.add(this.getContentPane(), jLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), this.upperTextField, 1, 0, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), jLabel2, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), this.lowerTextField, 1, 1, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), jButton2, 0, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), jButton, 1, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.addWindowListener(eventListener);
        this.setResizable(false);
        this.upperTextField.grabFocus();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getUpperRatio() {
        return Float.parseFloat(this.upperTextField.getText());
    }

    public float getLowerRatio() {
        return Float.parseFloat(this.lowerTextField.getText());
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(SetRatioScaleDialog.this.lowerTextField.getText());
                    Float.parseFloat(SetRatioScaleDialog.this.upperTextField.getText());
                    SetRatioScaleDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetRatioScaleDialog.this.result = 2;
                }
                SetRatioScaleDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                SetRatioScaleDialog.this.result = 2;
                SetRatioScaleDialog.this.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetRatioScaleDialog.this.result = -1;
            SetRatioScaleDialog.this.dispose();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    Float.parseFloat(SetRatioScaleDialog.this.lowerTextField.getText());
                    Float.parseFloat(SetRatioScaleDialog.this.upperTextField.getText());
                    SetRatioScaleDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetRatioScaleDialog.this.result = 2;
                }
                SetRatioScaleDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

