/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.CastClust;
import org.tigr.microarray.mev.cluster.algorithm.impl.KMC;
import org.tigr.util.FloatMatrix;

public class FOM
extends AbstractAlgorithm {
    private boolean stop = false;
    private boolean clusterGenes;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        Object object;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n = algorithmParameters.getInt("distance-function", 4);
        float f = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", false);
        this.clusterGenes = algorithmParameters.getBoolean("cluster-genes", true);
        int n2 = algorithmParameters.getInt("method", 2);
        float f2 = algorithmParameters.getFloat("interval", 0.1f);
        int n3 = algorithmParameters.getInt("iterations", 50);
        int n4 = algorithmParameters.getInt("number_of_clusters", 20);
        boolean bl2 = algorithmParameters.getBoolean("average", true);
        boolean bl3 = algorithmParameters.getBoolean("calculate-means", true);
        FloatMatrix floatMatrix = algorithmData.getMatrix("experiment");
        int n5 = floatMatrix.getRowDimension();
        int n6 = floatMatrix.getColumnDimension();
        AbstractAlgorithm abstractAlgorithm = null;
        abstractAlgorithm = n2 == 2 ? new KMC() : new CastClust(true);
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-factor", String.valueOf(f));
        algorithmData2.addParam("distance-absolute", String.valueOf(bl));
        algorithmData2.addParam("distance-function", String.valueOf(n));
        algorithmData2.addParam("number_of_iterations", String.valueOf(n3));
        algorithmData2.addParam("calculate-means", String.valueOf(bl3));
        AlgorithmData algorithmData3 = null;
        Cluster cluster = new Cluster();
        float[] fArray = null;
        int n7 = 0;
        int[] nArray = new int[1];
        if (n2 == 2) {
            object = new AlgorithmEvent(this, 1, n4);
            this.fireValueChanged((AlgorithmEvent)object);
            ((AlgorithmEvent)object).setId(2);
            algorithmData2.addParam("kmc-cluster-genes", String.valueOf(this.clusterGenes));
            fArray = new float[n4];
            for (int i = 0; i < n4; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                ((AlgorithmEvent)object).setIntValue(i);
                ((AlgorithmEvent)object).setDescription("calculating for " + String.valueOf(i + 1) + " clusters");
                this.fireValueChanged((AlgorithmEvent)object);
                algorithmData2.addParam("number_of_clusters", String.valueOf(i + 1));
                algorithmData3 = abstractAlgorithm.execute(algorithmData2);
                cluster = algorithmData3.getCluster("cluster");
                fArray[i] = (float)this.getFOM(floatMatrix, cluster, n5, n6);
            }
        } else {
            n7 = (int)(1.0f / f2);
            object = new AlgorithmEvent(this, 1, n7);
            this.fireValueChanged((AlgorithmEvent)object);
            ((AlgorithmEvent)object).setId(2);
            algorithmData2.addParam("cast-cluster-genes", String.valueOf(this.clusterGenes));
            nArray = new int[n7];
            float f3 = 0.0f;
            fArray = new float[n7];
            for (int i = 0; i < n7; ++i) {
                if ((f3 += f2) > 1.0f) {
                    f3 = 1.0f;
                }
                if (this.stop) {
                    throw new AbortException();
                }
                ((AlgorithmEvent)object).setIntValue(i);
                ((AlgorithmEvent)object).setDescription("calculating for threshold of " + String.valueOf(f3));
                this.fireValueChanged((AlgorithmEvent)object);
                algorithmData2.addParam("threshold", String.valueOf(f3));
                algorithmData3 = abstractAlgorithm.execute(algorithmData2);
                cluster = algorithmData3.getCluster("cluster");
                fArray[i] = (float)this.getFOM(floatMatrix, cluster, n5, n6);
                nArray[i] = cluster.getNodeList().getSize();
            }
        }
        object = new AlgorithmData();
        ((AlgorithmData)object).addMatrix("fom-values", new FloatMatrix(fArray, 1));
        ((AlgorithmData)object).addIntArray("numOfCastClusters", nArray);
        return object;
    }

    public double getFOM(FloatMatrix floatMatrix, Cluster cluster, int n, int n2) {
        int n3;
        float f;
        int[] nArray;
        int n4 = 0;
        NodeList nodeList = cluster.getNodeList();
        int n5 = nodeList.getSize();
        double[][] dArray = new double[n2][n5];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n5; ++j) {
                dArray[i][j] = 0.0;
                nArray = nodeList.getNode(j).getFeaturesIndexes();
                n4 = 0;
                for (int k = 0; k < nArray.length; ++k) {
                    f = floatMatrix.get(nArray[k], i);
                    if (Float.isNaN(f)) continue;
                    double[] dArray2 = dArray[i];
                    int n6 = j;
                    dArray2[n6] = dArray2[n6] + (double)f;
                    ++n4;
                }
                if (n4 > 0) {
                    double[] dArray3 = dArray[i];
                    int n7 = j;
                    dArray3[n7] = dArray3[n7] / (double)n4;
                    continue;
                }
                dArray[i][j] = 0.0;
            }
        }
        double[] dArray4 = new double[n2];
        double d = 1.0;
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = 0.0;
            for (int j = 0; j < n5; ++j) {
                nArray = nodeList.getNode(j).getFeaturesIndexes();
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    f = floatMatrix.get(nArray[n3], i);
                    if (Float.isNaN(f)) continue;
                    int n8 = i;
                    dArray4[n8] = dArray4[n8] + Math.pow((double)f - dArray[i][j], 2.0);
                }
                dArray4[i] = Math.sqrt(dArray4[i] / (double)n);
                int n9 = i;
                dArray4[n9] = dArray4[n9] / d;
            }
        }
        double d2 = 0.0;
        for (n3 = 0; n3 < n2; ++n3) {
            d2 += dArray4[n3];
        }
        return d2;
    }

    public void abort() {
        this.stop = true;
    }
}

