/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGUI;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGraph;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMState;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class SAM
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private FloatMatrix imputedMatrix;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int[] groupAssignments;
    private int[] pairedGroupAExpts;
    private int[] pairedGroupBExpts;
    private boolean[] inSurvivalAnalysis;
    private boolean[] isCensored;
    private int studyDesign;
    private int numMultiClassGroups = 0;
    private int numCombs;
    private boolean useKNearest;
    private int numNeighbors;
    private double sNought = 0.0;
    private double s0Percentile;
    private double[] dArray;
    private double[] rArray;
    private double[] sortedDArray;
    private double[] dBarValues;
    private double[] survivalTimes;
    private double[] zkArray;
    private int[] dkArray;
    private int[][] rkArray;
    private long[] randomSeeds;
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        Object object;
        Cloneable cloneable;
        int n3;
        Object object2;
        int n4;
        Object object3;
        Object object4;
        Object object5;
        Serializable serializable;
        Object object6;
        Object object7;
        FloatMatrix floatMatrix;
        FloatMatrix floatMatrix2;
        this.groupAssignments = algorithmData.getIntArray("group-assignments");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n5 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        boolean bl4 = algorithmParameters.getBoolean("saveImputedMatrix", false);
        boolean bl5 = algorithmParameters.getBoolean("use-previous-graph", false);
        double d = algorithmParameters.getFloat("userPercentile", 0.0f);
        boolean bl6 = algorithmParameters.getBoolean("useTusherEtAlS0", false);
        boolean bl7 = algorithmParameters.getBoolean("calculateQLowestFDR", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.inSurvivalAnalysis = new boolean[this.numExps];
        this.isCensored = new boolean[this.numExps];
        this.survivalTimes = new double[this.numExps];
        this.studyDesign = algorithmParameters.getInt("study-design", 4);
        if (this.studyDesign == 5) {
            floatMatrix2 = algorithmData.getMatrix("pairedAExptsMatrix");
            floatMatrix = algorithmData.getMatrix("pairedBExptsMatrix");
            this.pairedGroupAExpts = new int[floatMatrix2.getRowDimension()];
            this.pairedGroupBExpts = new int[floatMatrix.getRowDimension()];
            for (int i = 0; i < floatMatrix2.getRowDimension(); ++i) {
                this.pairedGroupAExpts[i] = (int)floatMatrix2.A[i][0];
                this.pairedGroupBExpts[i] = (int)floatMatrix.A[i][0];
            }
        }
        if (this.studyDesign == 6) {
            this.numMultiClassGroups = algorithmParameters.getInt("numMultiClassGroups", 0);
        }
        if (this.studyDesign == 7) {
            floatMatrix2 = algorithmData.getMatrix("inAnalysisMatrix");
            floatMatrix = algorithmData.getMatrix("isCensoredMatrix");
            FloatMatrix floatMatrix3 = algorithmData.getMatrix("survivalTimesMatrix");
            for (int i = 0; i < floatMatrix2.getRowDimension(); ++i) {
                this.inSurvivalAnalysis[i] = floatMatrix2.A[i][0] != 0.0f;
                this.isCensored[i] = floatMatrix.A[i][0] != 0.0f;
                this.survivalTimes[i] = floatMatrix3.A[i][0];
            }
        }
        this.numCombs = algorithmParameters.getInt("num-combs", 100);
        this.useKNearest = algorithmParameters.getBoolean("use-k-nearest", true);
        this.numNeighbors = algorithmParameters.getInt("num-neighbors", 10);
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[101];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        if (!bl5) {
            int n6;
            int n7;
            Object object8;
            Object[] objectArray;
            int n8;
            this.imputedMatrix = new FloatMatrix(this.numGenes, this.numExps);
            this.imputedMatrix = this.useKNearest ? this.imputeKNearestMatrix(this.expMatrix, this.numNeighbors) : this.imputeRowAverageMatrix(this.expMatrix);
            SAMState.imputedMatrix = this.imputedMatrix;
            this.zkArray = new double[1];
            this.rkArray = new int[1][];
            this.dkArray = new int[1];
            if (this.studyDesign == 7) {
                this.zkArray = this.getZkArray();
                this.rkArray = this.getRkArray();
                this.dkArray = this.getDkArray();
            }
            if (bl6) {
                SAMState.sNought = this.sNought = this.getSNought();
                SAMState.s0Percentile = this.s0Percentile;
            } else {
                SAMState.sNought = this.sNought = this.getSAlpha(d);
                this.s0Percentile = d;
                SAMState.s0Percentile = d;
            }
            this.dArray = new double[this.numGenes];
            this.rArray = new double[this.numGenes];
            for (int i = 0; i < this.dArray.length; ++i) {
                this.dArray[i] = this.getD(i, this.imputedMatrix);
                this.rArray[i] = this.getR(i, this.imputedMatrix);
            }
            SAMState.dArray = this.dArray;
            SAMState.rArray = this.rArray;
            object7 = new QSort(this.dArray);
            this.sortedDArray = ((QSort)object7).getSortedDouble();
            SAMState.sortedDArray = this.sortedDArray;
            nArray2 = ((QSort)object7).getOrigIndx();
            SAMState.sortedDArrayIndices = nArray2;
            object6 = new double[this.numCombs][this.numGenes];
            AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numCombs);
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setId(2);
            serializable = new Random();
            this.randomSeeds = new long[this.numCombs];
            for (n8 = 0; n8 < this.numCombs; ++n8) {
                this.randomSeeds[n8] = ((Random)serializable).nextLong();
            }
            for (n8 = 0; n8 < this.numCombs; ++n8) {
                int n9;
                Object[] objectArray2;
                Cloneable cloneable2;
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(n8);
                algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n8 + 1));
                this.fireValueChanged(algorithmEvent);
                objectArray = new int[1];
                if (this.studyDesign == 4 || this.studyDesign == 6 || this.studyDesign == 7) {
                    cloneable2 = new Vector();
                    if (this.studyDesign == 4) {
                        for (int i = 0; i < this.groupAssignments.length; ++i) {
                            if (this.groupAssignments[i] == 3) continue;
                            ((Vector)cloneable2).add(new Integer(i));
                        }
                    } else if (this.studyDesign == 6) {
                        for (int i = 0; i < this.groupAssignments.length; ++i) {
                            if (this.groupAssignments[i] == 0) continue;
                            ((Vector)cloneable2).add(new Integer(i));
                        }
                    } else if (this.studyDesign == 7) {
                        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
                            if (!this.inSurvivalAnalysis[i]) continue;
                            ((Vector)cloneable2).add(new Integer(i));
                        }
                    }
                    objectArray2 = new int[((Vector)cloneable2).size()];
                    for (n9 = 0; n9 < objectArray2.length; ++n9) {
                        objectArray2[n9] = (Integer)((Vector)cloneable2).get(n9);
                    }
                    objectArray = this.getPermutedValues(this.numExps, (int[])objectArray2);
                } else if (this.studyDesign == 5) {
                    objectArray = this.permuteWithinPairs(this.randomSeeds[n8]);
                }
                cloneable2 = this.getPermutedMatrix(this.imputedMatrix, (int[])objectArray);
                objectArray2 = new double[((FloatMatrix)cloneable2).getRowDimension()];
                for (n9 = 0; n9 < ((FloatMatrix)cloneable2).getRowDimension(); ++n9) {
                    objectArray2[n9] = (int)this.getD(n9, (FloatMatrix)cloneable2);
                }
                object8 = new QSort((double[])objectArray2);
                double[] dArray7 = ((QSort)object8).getSortedDouble();
                for (n7 = 0; n7 < dArray7.length; ++n7) {
                    object6[n8][n7] = dArray7[n7];
                }
            }
            this.dBarValues = new double[this.numGenes];
            for (n8 = 0; n8 < this.numGenes; ++n8) {
                objectArray = new double[this.numCombs];
                for (int i = 0; i < this.numCombs; ++i) {
                    objectArray[i] = (double)object6[i][n8];
                }
                this.dBarValues[n8] = this.getMean((double[])objectArray);
            }
            SAMState.dBarValues = this.dBarValues;
            object5 = new double[this.numCombs * this.numGenes];
            int n10 = 0;
            for (int i = 0; i < this.numCombs; ++i) {
                for (int j = 0; j < this.numGenes; ++j) {
                    object5[n10] = object6[i][j];
                    ++n10;
                }
            }
            object4 = new QSort((double[])object5);
            object3 = ((QSort)object4).getSortedDouble();
            object8 = ((QSort)object4).getOrigIndx();
            n4 = (int)Math.round((double)((Object)object3).length * 0.25 - 1.0);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 >= ((Object)object3).length) {
                n4 = ((Object)object3).length - 1;
            }
            n7 = (int)Math.round((double)((Object)object3).length * 0.75 - 1.0);
            if (n7 < 0) {
                n7 = 0;
            } else if (n7 >= ((Object)object3).length) {
                n7 = ((Object)object3).length - 1;
            }
            Object object9 = object3[n4];
            Object object10 = object3[n7];
            int n11 = 0;
            for (int i = 0; i < this.dArray.length; ++i) {
                if (!(this.dArray[i] > object9) || !(this.dArray[i] < object10)) continue;
                ++n11;
            }
            d2 = (double)n11 / (0.5 * (double)this.numGenes);
            SAMState.pi0Hat = d2 = Math.min(d2, 1.0);
            double d4 = this.getMax(this.dArray);
            double d5 = this.getMin(this.dArray);
            d3 = Math.abs(d4) > Math.abs(d5) ? (double)((float)(0.25 * Math.abs(d4))) : (double)((float)(0.25 * Math.abs(d5)));
            object2 = new double[this.sortedDArray.length];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = Math.abs(this.sortedDArray[i] - this.dBarValues[i]);
            }
            double d6 = this.getMax((double[])object2);
            double d7 = this.getMin((double[])object2);
            double d8 = (d6 - d7) / 100.0;
            double d9 = d7;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = d9;
                d9 += d8;
            }
            SAMState.deltaGrid = dArray;
            double[] dArray8 = new double[dArray.length];
            double[] dArray9 = new double[dArray.length];
            for (n6 = 0; n6 < dArray8.length; ++n6) {
                dArray8[n6] = this.getCutUp(dArray[n6]);
                dArray9[n6] = this.getCutLow(dArray[n6]);
            }
            nArray = new int[dArray.length];
            for (n6 = 0; n6 < dArray.length; ++n6) {
                nArray[n6] = this.getNumSigGenesByDelta(dArray8[n6], dArray9[n6]);
            }
            SAMState.numSigGenesByDelta = nArray;
            dArray2 = new double[dArray.length];
            dArray3 = new double[dArray.length];
            for (n6 = 0; n6 < dArray.length; ++n6) {
                dArray2[n6] = this.getMedNumFalselyCalledGenesByDelta((double[][])object6, dArray8[n6], dArray9[n6]);
                dArray3[n6] = this.getNinetiethPercentileFalselyCalledGenesByDelta((double[][])object6, dArray8[n6], dArray9[n6]);
            }
            for (n6 = 0; n6 < dArray.length; ++n6) {
                dArray2[n6] = d2 * dArray2[n6];
                dArray3[n6] = d2 * dArray3[n6];
            }
            SAMState.medNumFalselyCalledGenesByDelta = dArray2;
            SAMState.ninetiethPercentileFalselyCalledGenesByDelta = dArray3;
            dArray4 = new double[dArray.length];
            dArray5 = new double[dArray.length];
            for (n6 = 0; n6 < dArray.length; ++n6) {
                dArray4[n6] = dArray2[n6] * 100.0 / (double)nArray[n6];
                dArray5[n6] = dArray3[n6] * 100.0 / (double)nArray[n6];
            }
            SAMState.FDRmedian = dArray4;
            SAMState.FDR90thPercentile = dArray5;
            if (bl7) {
                dArray6 = new double[this.numGenes];
                AlgorithmEvent algorithmEvent2 = new AlgorithmEvent(this, 1, dArray6.length);
                this.fireValueChanged(algorithmEvent2);
                algorithmEvent2.setId(2);
                for (n3 = 0; n3 < this.numGenes; ++n3) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent2.setIntValue(n3);
                    algorithmEvent2.setDescription("Calculating q values: Current gene = " + (n3 + 1));
                    this.fireValueChanged(algorithmEvent2);
                    cloneable = new Vector();
                    for (int i = 0; i < dArray.length; ++i) {
                        if (!this.isSignificant(n3, dArray8[i], dArray9[i])) continue;
                        ((Vector)cloneable).add(new Integer(i));
                    }
                    object = new double[((Vector)cloneable).size()];
                    for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                        int n12 = (Integer)((Vector)cloneable).get(i);
                        double d10 = dArray[n12];
                        object[i] = this.getMedNumFalselyCalledGenesByDelta((double[][])object6, this.getCutUp(d10), this.getCutLow(d10));
                        object[i] = object[i] * d2 * 100.0 / (double)nArray[n12];
                    }
                    dArray6[n3] = ((Object)object).length > 0 ? this.getMin((double[])object) : Double.NaN;
                }
            } else {
                dArray6 = new double[this.numGenes];
            }
            SAMState.qLowestFDR = dArray6;
            FloatMatrix floatMatrix4 = new FloatMatrix(dArray6.length, 1);
            for (n3 = 0; n3 < dArray6.length; ++n3) {
                floatMatrix4.A[n3][0] = (float)dArray6[n3];
            }
        } else {
            this.imputedMatrix = SAMState.imputedMatrix;
            this.dBarValues = SAMState.dBarValues;
            this.sortedDArray = SAMState.sortedDArray;
            nArray2 = SAMState.sortedDArrayIndices;
            d3 = SAMState.delta;
            dArray = SAMState.deltaGrid;
            nArray = SAMState.numSigGenesByDelta;
            dArray2 = SAMState.medNumFalselyCalledGenesByDelta;
            this.sNought = SAMState.sNought;
            this.s0Percentile = SAMState.s0Percentile;
            d2 = SAMState.pi0Hat;
            dArray3 = SAMState.ninetiethPercentileFalselyCalledGenesByDelta;
            dArray4 = SAMState.FDRmedian;
            dArray5 = SAMState.FDR90thPercentile;
            dArray6 = SAMState.qLowestFDR;
            this.dArray = SAMState.dArray;
            this.rArray = SAMState.rArray;
        }
        object7 = new FloatMatrix(this.dArray.length, 1);
        object6 = new FloatMatrix(this.rArray.length, 1);
        for (int i = 0; i < this.dArray.length; ++i) {
            ((FloatMatrix)object7).A[i][0] = (float)this.dArray[i];
            ((FloatMatrix)object6).A[i][0] = (float)this.rArray[i];
        }
        FloatMatrix floatMatrix5 = new FloatMatrix(dArray.length, 1);
        serializable = new FloatMatrix(dArray2.length, 1);
        object5 = new FloatMatrix(dArray3.length, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(nArray.length, 1);
        object4 = new FloatMatrix(dArray4.length, 1);
        object3 = new FloatMatrix(dArray5.length, 1);
        for (int i = 0; i < dArray.length; ++i) {
            floatMatrix5.A[i][0] = (float)dArray[i];
            ((FloatMatrix)serializable).A[i][0] = (float)dArray2[i];
            ((FloatMatrix)object5).A[i][0] = (float)dArray3[i];
            floatMatrix6.A[i][0] = nArray[i];
            ((FloatMatrix)object4).A[i][0] = (float)dArray4[i];
            ((FloatMatrix)object3).A[i][0] = (float)dArray5[i];
        }
        FloatMatrix floatMatrix7 = new FloatMatrix(dArray6.length, 1);
        for (n4 = 0; n4 < dArray6.length; ++n4) {
            floatMatrix7.A[n4][0] = (float)dArray6[n4];
        }
        SAMGraph sAMGraph = new SAMGraph(SAMGUI.SAMFrame, this.studyDesign, this.dBarValues, this.sortedDArray, d3, dArray, nArray, dArray2, dArray3, dArray4, dArray5, true);
        sAMGraph.setVisible(true);
        SAMState.delta = d3 = sAMGraph.getDelta();
        String string = sAMGraph.getNumSig();
        String string2 = sAMGraph.getNumFalseSigMed();
        String string3 = sAMGraph.getNumFalseSig90th();
        String string4 = sAMGraph.getFDRMedian();
        String string5 = sAMGraph.getFDR90th();
        double d11 = this.getCutUp(d3);
        double d12 = this.getCutLow(d3);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.dBarValues.length, 1);
        object2 = new FloatMatrix(this.sortedDArray.length, 1);
        for (n2 = 0; n2 < this.dBarValues.length; ++n2) {
            floatMatrix8.A[n2][0] = (float)this.dBarValues[n2];
        }
        for (n2 = 0; n2 < this.sortedDArray.length; ++n2) {
            ((FloatMatrix)object2).A[n2][0] = (float)this.sortedDArray[n2];
        }
        FloatMatrix floatMatrix9 = new FloatMatrix(this.numGenes, 1);
        if (this.studyDesign == 4 || this.studyDesign == 5) {
            for (int i = 0; i < this.numGenes; ++i) {
                floatMatrix9.A[i][0] = (float)this.getFoldChange(i);
            }
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        boolean bl8 = false;
        boolean bl9 = false;
        int n13 = 0;
        int n14 = 0;
        for (n = 0; n < this.dBarValues.length; ++n) {
            if (!(this.dBarValues[n] > 0.0) || !(this.sortedDArray[n] - this.dBarValues[n] > d3)) continue;
            n13 = n;
            bl8 = true;
            break;
        }
        for (n = 0; n < this.dBarValues.length; ++n) {
            if (!(this.dBarValues[n] < 0.0) || !(this.dBarValues[n] - this.sortedDArray[n] > d3)) continue;
            n14 = n;
            bl9 = true;
        }
        n = sAMGraph.useFoldChange() ? 1 : 0;
        double d13 = 0.0;
        if (n != 0 && (this.studyDesign == 4 || this.studyDesign == 5)) {
            d13 = sAMGraph.getFoldChangeValue();
            if (bl8 && bl9) {
                for (n3 = 0; n3 < n14 + 1; ++n3) {
                    if (this.satisfiesNegFoldChangeCriterion(d13, nArray2[n3])) {
                        vector2.add(new Integer(nArray2[n3]));
                        continue;
                    }
                    vector3.add(new Integer(nArray2[n3]));
                }
                for (n3 = n14 + 1; n3 < n13; ++n3) {
                    vector3.add(new Integer(nArray2[n3]));
                }
                for (n3 = n13; n3 < this.dBarValues.length; ++n3) {
                    if (this.satisfiesPosFoldChangeCriterion(d13, nArray2[n3])) {
                        vector.add(new Integer(nArray2[n3]));
                        continue;
                    }
                    vector3.add(new Integer(nArray2[n3]));
                }
            } else if (bl8 && !bl9) {
                for (n3 = 0; n3 < n13; ++n3) {
                    vector3.add(new Integer(nArray2[n3]));
                }
                for (n3 = n13; n3 < this.dBarValues.length; ++n3) {
                    if (this.satisfiesPosFoldChangeCriterion(d13, nArray2[n3])) {
                        vector.add(new Integer(nArray2[n3]));
                        continue;
                    }
                    vector3.add(new Integer(nArray2[n3]));
                }
            } else if (!bl8 && bl9) {
                for (n3 = 0; n3 < n14 + 1; ++n3) {
                    if (this.satisfiesNegFoldChangeCriterion(d13, nArray2[n3])) {
                        vector2.add(new Integer(nArray2[n3]));
                        continue;
                    }
                    vector3.add(new Integer(nArray2[n3]));
                }
                for (n3 = n14 + 1; n3 < this.dBarValues.length; ++n3) {
                    vector3.add(new Integer(nArray2[n3]));
                }
            } else if (!bl8 && !bl9) {
                for (n3 = 0; n3 < this.dBarValues.length; ++n3) {
                    vector3.add(new Integer(nArray2[n3]));
                }
            }
        } else if (bl8 && bl9) {
            for (n3 = 0; n3 < n14 + 1; ++n3) {
                vector2.add(new Integer(nArray2[n3]));
            }
            for (n3 = n14 + 1; n3 < n13; ++n3) {
                vector3.add(new Integer(nArray2[n3]));
            }
            for (n3 = n13; n3 < this.dBarValues.length; ++n3) {
                vector.add(new Integer(nArray2[n3]));
            }
        } else if (bl8 && !bl9) {
            for (n3 = 0; n3 < n13; ++n3) {
                vector3.add(new Integer(nArray2[n3]));
            }
            for (n3 = n13; n3 < this.dBarValues.length; ++n3) {
                vector.add(new Integer(nArray2[n3]));
            }
        } else if (!bl8 && bl9) {
            for (n3 = 0; n3 < n14 + 1; ++n3) {
                vector2.add(new Integer(nArray2[n3]));
            }
            for (n3 = n14 + 1; n3 < this.dBarValues.length; ++n3) {
                vector3.add(new Integer(nArray2[n3]));
            }
        } else if (!bl8 && !bl9) {
            for (n3 = 0; n3 < this.dBarValues.length; ++n3) {
                vector3.add(new Integer(nArray2[n3]));
            }
        }
        Vector<Integer> vector4 = new Vector<Integer>();
        vector4.addAll(vector);
        vector4.addAll(vector2);
        this.k = this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 ? 4 : 2;
        this.clusters = new Vector[this.k];
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7) {
            this.clusters[0] = vector;
            this.clusters[1] = vector2;
            this.clusters[2] = vector4;
            this.clusters[3] = vector3;
        } else {
            this.clusters[0] = vector;
            this.clusters[1] = vector3;
        }
        cloneable = this.getMeans(this.clusters);
        object = this.getVariances(this.clusters, (FloatMatrix)cloneable);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray3 = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray3);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray3, n5, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addParam("numSigGenes", String.valueOf(string));
        algorithmData2.addParam("numFalseSigMed", String.valueOf(string2));
        algorithmData2.addParam("numFalseSig90th", string3);
        algorithmData2.addParam("FDRMedian", string4);
        algorithmData2.addParam("FDR90th", string5);
        algorithmData2.addParam("useFoldChange", String.valueOf(n != 0));
        algorithmData2.addParam("foldChangeValue", String.valueOf((float)d13));
        algorithmData2.addMatrix("clusters_means", (FloatMatrix)cloneable);
        algorithmData2.addMatrix("clusters_variances", (FloatMatrix)object);
        algorithmData2.addParam("delta", String.valueOf((float)d3));
        if (Double.isInfinite(d11)) {
            algorithmData2.addParam("upperCutoff", String.valueOf(Float.POSITIVE_INFINITY));
        } else {
            algorithmData2.addParam("upperCutoff", String.valueOf((float)d11));
        }
        if (Double.isInfinite(d12)) {
            algorithmData2.addParam("lowerCutoff", String.valueOf(Float.NEGATIVE_INFINITY));
        } else {
            algorithmData2.addParam("lowerCutoff", String.valueOf((float)d12));
        }
        algorithmData2.addParam("sNought", String.valueOf((float)this.sNought));
        algorithmData2.addParam("s0Percentile", String.valueOf((float)this.s0Percentile));
        algorithmData2.addParam("pi0Hat", String.valueOf((float)d2));
        algorithmData2.addMatrix("dValuesMatrix", (FloatMatrix)object7);
        algorithmData2.addMatrix("rValuesMatrix", (FloatMatrix)object6);
        algorithmData2.addMatrix("foldChangeMatrix", floatMatrix9);
        algorithmData2.addMatrix("dBarMatrixX", floatMatrix8);
        algorithmData2.addMatrix("sortedDMatrixY", (FloatMatrix)object2);
        algorithmData2.addMatrix("qLowestFDRMatrix", floatMatrix7);
        algorithmData2.addMatrix("deltaGridMatrix", floatMatrix5);
        algorithmData2.addMatrix("medNumFalseMatrix", (FloatMatrix)serializable);
        algorithmData2.addMatrix("false90thMatrix", (FloatMatrix)object5);
        algorithmData2.addMatrix("numSigMatrix", floatMatrix6);
        algorithmData2.addMatrix("FDRMedianMatrix", (FloatMatrix)object4);
        algorithmData2.addMatrix("FDR90thMatrix", (FloatMatrix)object3);
        algorithmData2.addMatrix("imputedMatrix", this.imputedMatrix);
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private double getFoldChange(int n) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.imputedMatrix.A[n][i];
        }
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.pow(2.0, fArray[i]);
        }
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        if (this.studyDesign == 4) {
            int n3;
            n2 = 0;
            int n4 = 0;
            for (n3 = 0; n3 < this.groupAssignments.length; ++n3) {
                if (this.groupAssignments[n3] == 1) {
                    ++n2;
                    continue;
                }
                if (this.groupAssignments[n3] != 2) continue;
                ++n4;
            }
            dArray2 = new double[n2];
            dArray3 = new double[n4];
            n3 = 0;
            int n5 = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    dArray2[n3] = dArray[i];
                    ++n3;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                dArray3[n5] = dArray[i];
                ++n5;
            }
        } else if (this.studyDesign == 5) {
            dArray2 = new double[this.pairedGroupAExpts.length];
            dArray3 = new double[this.pairedGroupBExpts.length];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArray2[n2] = dArray[this.pairedGroupAExpts[n2]];
                dArray3[n2] = dArray[this.pairedGroupBExpts[n2]];
            }
        }
        double d = this.getMean(dArray2);
        double d2 = this.getMean(dArray3);
        return d2 / d;
    }

    private boolean satisfiesPosFoldChangeCriterion(double d, int n) {
        int n2;
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.imputedMatrix.A[n][i];
        }
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.pow(2.0, fArray[i]);
        }
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        if (this.studyDesign == 4) {
            int n3;
            n2 = 0;
            int n4 = 0;
            for (n3 = 0; n3 < this.groupAssignments.length; ++n3) {
                if (this.groupAssignments[n3] == 1) {
                    ++n2;
                    continue;
                }
                if (this.groupAssignments[n3] != 2) continue;
                ++n4;
            }
            dArray2 = new double[n2];
            dArray3 = new double[n4];
            n3 = 0;
            int n5 = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    dArray2[n3] = dArray[i];
                    ++n3;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                dArray3[n5] = dArray[i];
                ++n5;
            }
        } else if (this.studyDesign == 5) {
            dArray2 = new double[this.pairedGroupAExpts.length];
            dArray3 = new double[this.pairedGroupBExpts.length];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArray2[n2] = dArray[this.pairedGroupAExpts[n2]];
                dArray3[n2] = dArray[this.pairedGroupBExpts[n2]];
            }
        }
        double d2 = this.getMean(dArray2);
        double d3 = this.getMean(dArray3);
        if (d2 <= 0.0 || d3 <= 0.0) {
            return false;
        }
        return Math.abs(d3 / d2) >= d;
    }

    private boolean satisfiesNegFoldChangeCriterion(double d, int n) {
        int n2;
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.imputedMatrix.A[n][i];
        }
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.pow(2.0, fArray[i]);
        }
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        if (this.studyDesign == 4) {
            int n3;
            n2 = 0;
            int n4 = 0;
            for (n3 = 0; n3 < this.groupAssignments.length; ++n3) {
                if (this.groupAssignments[n3] == 1) {
                    ++n2;
                    continue;
                }
                if (this.groupAssignments[n3] != 2) continue;
                ++n4;
            }
            dArray2 = new double[n2];
            dArray3 = new double[n4];
            n3 = 0;
            int n5 = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    dArray2[n3] = dArray[i];
                    ++n3;
                    continue;
                }
                if (this.groupAssignments[i] != 2) continue;
                dArray3[n5] = dArray[i];
                ++n5;
            }
        } else if (this.studyDesign == 5) {
            dArray2 = new double[this.pairedGroupAExpts.length];
            dArray3 = new double[this.pairedGroupBExpts.length];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArray2[n2] = dArray[this.pairedGroupAExpts[n2]];
                dArray3[n2] = dArray[this.pairedGroupBExpts[n2]];
            }
        }
        double d2 = this.getMean(dArray2);
        double d3 = this.getMean(dArray3);
        if (d2 <= 0.0 || d3 <= 0.0) {
            return false;
        }
        return Math.abs(d3 / d2) <= 1.0 / d;
    }

    private void printIntArray(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print("" + nArray[i]);
        }
        System.out.println();
    }

    private boolean isSignificant(int n, double d, double d2) {
        boolean bl = false;
        if (this.dArray[n] >= d || this.dArray[n] <= d2) {
            bl = true;
        }
        return bl;
    }

    private double getMedNumFalselyCalledGenesByDelta(double[][] dArray, double d, double d2) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            int n;
            double[] dArray3 = new double[dArray[i].length];
            for (n = 0; n < dArray3.length; ++n) {
                dArray3[n] = dArray[i][n];
            }
            n = 0;
            for (int j = 0; j < dArray3.length; ++j) {
                if (!(dArray3[j] >= d) && !(dArray3[j] <= d2)) continue;
                ++n;
            }
            dArray2[i] = n;
        }
        return this.getMedian(dArray2);
    }

    private double getNinetiethPercentileFalselyCalledGenesByDelta(double[][] dArray, double d, double d2) {
        int n;
        double[] dArray2;
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2 = new double[dArray[i].length];
            for (n = 0; n < dArray2.length; ++n) {
                dArray2[n] = dArray[i][n];
            }
            n = 0;
            for (int j = 0; j < dArray2.length; ++j) {
                if (!(dArray2[j] >= d) && !(dArray2[j] <= d2)) continue;
                ++n;
            }
            dArray3[i] = n;
        }
        QSort qSort = new QSort(dArray3);
        dArray2 = qSort.getSortedDouble();
        n = (int)Math.round((double)dArray2.length * 0.9 - 1.0);
        return dArray2[n];
    }

    private double getCutUp(double d) {
        boolean bl = false;
        double d2 = Double.POSITIVE_INFINITY;
        int n = 0;
        boolean bl2 = false;
        for (int i = 0; i < this.dBarValues.length; ++i) {
            if (!(this.dBarValues[i] > 0.0) || !(this.sortedDArray[i] - this.dBarValues[i] > d)) continue;
            n = i;
            bl = true;
            break;
        }
        d2 = bl ? this.sortedDArray[n] : Double.POSITIVE_INFINITY;
        return d2;
    }

    private double getCutLow(double d) {
        int n = 0;
        boolean bl = false;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.dBarValues.length; ++i) {
            if (!(this.dBarValues[i] < 0.0) || !(this.dBarValues[i] - this.sortedDArray[i] > d)) continue;
            n = i;
            bl = true;
        }
        d2 = bl ? this.sortedDArray[n] : Double.NEGATIVE_INFINITY;
        return d2;
    }

    private int getNumSigGenesByDelta(double d, double d2) {
        int n = 0;
        for (int i = 0; i < this.sortedDArray.length; ++i) {
            if (!(this.sortedDArray[i] >= d) && !(this.sortedDArray[i] <= d2)) continue;
            ++n;
        }
        return n;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][nArray[j]];
            }
        }
        return floatMatrix2;
    }

    private int[] permuteWithinPairs(long l) {
        int n;
        int[] nArray = new int[this.numExps];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        Random random = new Random(l);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean bl = random.nextBoolean();
            if (!bl) continue;
            n = nArray[this.pairedGroupBExpts[i]];
            nArray[this.pairedGroupBExpts[i]] = nArray[this.pairedGroupAExpts[i]];
            nArray[this.pairedGroupAExpts[i]] = n;
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    private int[] getPermutedValues(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[n];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        for (n2 = nArray3.length; n2 > 1; --n2) {
            Random random = new Random();
            int n3 = random.nextInt(n2 - 1);
            int n4 = nArray3[n3];
            nArray3[n3] = nArray3[n2 - 1];
            nArray3[n2 - 1] = n4;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[nArray[n2]] = nArray3[n2];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray2;
    }

    private float getMax(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f < fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private float getMin(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f > fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private double getMax(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private double getMin(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private double rTwoClassUnpaired(int n, FloatMatrix floatMatrix) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            if (this.groupAssignments[n2] == 1) {
                ++n3;
                continue;
            }
            if (this.groupAssignments[n2] != 2) continue;
            ++n4;
        }
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n4];
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            if (this.groupAssignments[n2] == 1) {
                fArray[n3] = floatMatrix.A[n][n2];
                ++n3;
                continue;
            }
            if (this.groupAssignments[n2] != 2) continue;
            fArray2[n4] = floatMatrix.A[n][n2];
            ++n4;
        }
        double d = this.getMean(fArray2) - this.getMean(fArray);
        return d;
    }

    private double rTwoClassPaired(int n, FloatMatrix floatMatrix) {
        double d = 0.0;
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            d += (double)(floatMatrix.A[n][this.pairedGroupBExpts[i]] - floatMatrix.A[n][this.pairedGroupAExpts[i]]);
        }
        return d / (double)this.pairedGroupAExpts.length;
    }

    private double rMultiClass(int n, FloatMatrix floatMatrix) {
        float[] fArray = new float[floatMatrix.getColumnDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = floatMatrix.A[n][i];
        }
        int[] nArray = this.getGroupCounts();
        double[] dArray = this.getXBarIk(fArray);
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
            d2 *= (double)nArray[i];
        }
        double d3 = this.getMean(fArray);
        double d4 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d4 += (double)nArray[i] * Math.pow(dArray[i] - d3, 2.0);
        }
        double d5 = Math.pow(d / d2 * d4, 0.5);
        return d5;
    }

    private double sTwoClassPaired(int n, FloatMatrix floatMatrix) {
        int n2;
        double d = this.rTwoClassPaired(n, floatMatrix);
        double d2 = 0.0;
        for (n2 = 0; n2 < this.pairedGroupAExpts.length; ++n2) {
            d2 += Math.pow((double)floatMatrix.A[n][this.pairedGroupBExpts[n2]] - (double)floatMatrix.A[n][this.pairedGroupAExpts[n2]] - d, 2.0);
        }
        n2 = this.pairedGroupAExpts.length;
        return Math.sqrt(d2 / (double)(n2 * (n2 - 1)));
    }

    private double sMultiClass(int n, FloatMatrix floatMatrix) {
        float[] fArray = new float[floatMatrix.getColumnDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = floatMatrix.A[n][i];
        }
        double[][] dArray = this.getGeneValuesByGroups(fArray);
        int[] nArray = this.getGroupCounts();
        double[] dArray2 = this.getXBarIk(fArray);
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i] - 1;
        }
        double d = 1.0 / (double)n2;
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d2 += 1.0 / (double)nArray[i];
        }
        double d3 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d4 = 0.0;
            for (int j = 0; j < nArray[i]; ++j) {
                d4 += Math.pow(dArray[i][j] - dArray2[i], 2.0);
            }
            d3 += d4;
        }
        return Math.pow(d * (d2 * d3), 0.5);
    }

    private double rCensoredSurvival(int n, FloatMatrix floatMatrix) {
        double d = 0.0;
        for (int i = 0; i < this.zkArray.length; ++i) {
            d += this.getXStarIK(n, floatMatrix, i) - (double)this.dkArray[i] * this.getXBarIK(n, floatMatrix, i);
        }
        return d;
    }

    private double sCensoredSurvival(int n, FloatMatrix floatMatrix) {
        double d = 0.0;
        for (int i = 0; i < this.zkArray.length; ++i) {
            double d2 = (double)this.dkArray[i] / (double)this.rkArray[i].length;
            double d3 = 0.0;
            double d4 = this.getXBarIK(n, floatMatrix, i);
            for (int j = 0; j < this.rkArray[i].length; ++j) {
                int n2 = this.rkArray[i][j];
                d3 += Math.pow((double)floatMatrix.A[n][n2] - d4, 2.0);
            }
            d += d2 * d3;
        }
        return Math.pow(d, 0.5);
    }

    private int[][] getRkArray() {
        int[][] nArrayArray = new int[this.zkArray.length][];
        for (int i = 0; i < this.zkArray.length; ++i) {
            int n;
            Vector<Integer> vector = new Vector<Integer>();
            double d = this.zkArray[i];
            for (n = 0; n < this.numExps; ++n) {
                if (!this.inSurvivalAnalysis[n] || !(this.survivalTimes[n] >= d)) continue;
                vector.add(new Integer(n));
            }
            nArrayArray[i] = new int[vector.size()];
            for (n = 0; n < nArrayArray[i].length; ++n) {
                nArrayArray[i][n] = (Integer)vector.get(n);
            }
        }
        return nArrayArray;
    }

    private double[] getZkArray() {
        Vector<Double> vector = new Vector<Double>();
        for (int i = 0; i < this.survivalTimes.length; ++i) {
            if (!this.inSurvivalAnalysis[i] || this.isCensored[i]) continue;
            vector.add(new Double(this.survivalTimes[i]));
        }
        HashSet hashSet = new HashSet(vector);
        Vector vector2 = new Vector(hashSet);
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)vector2.get(i);
        }
        return dArray;
    }

    private int[] getDkArray() {
        int[] nArray = new int[this.zkArray.length];
        for (int i = 0; i < this.zkArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < this.numExps; ++j) {
                if (!this.inSurvivalAnalysis[j] || this.survivalTimes[j] != this.zkArray[i] || this.isCensored[j]) continue;
                ++n;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private double getXStarIK(int n, FloatMatrix floatMatrix, int n2) {
        double d = 0.0;
        double d2 = this.zkArray[n2];
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            if (!this.inSurvivalAnalysis[i] || this.survivalTimes[i] != d2 || this.isCensored[i]) continue;
            d += (double)floatMatrix.A[n][i];
        }
        return d;
    }

    private double getXBarIK(int n, FloatMatrix floatMatrix, int n2) {
        double d = 0.0;
        double d2 = this.zkArray[n2];
        int n3 = this.rkArray[n2].length;
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            if (!this.inSurvivalAnalysis[i] || !(this.survivalTimes[i] >= d2)) continue;
            d += (double)floatMatrix.A[n][i];
        }
        return d / (double)n3;
    }

    private double[][] getGeneValuesByGroups(float[] fArray) {
        int n;
        int[] nArray = this.getGroupCounts();
        double[][] dArrayArray = new double[nArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[nArray[i]];
        }
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < this.groupAssignments.length; ++n) {
            int n2 = this.groupAssignments[n];
            if (n2 == 0) continue;
            dArrayArray[n2 - 1][nArray2[n2 - 1]] = fArray[n];
            int n3 = n2 - 1;
            nArray2[n3] = nArray2[n3] + 1;
        }
        return dArrayArray;
    }

    private double[] getXBarIk(float[] fArray) {
        int n;
        int n2;
        int[] nArray = this.getGroupCounts();
        float[][] fArrayArray = new float[nArray.length][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = new float[nArray[i]];
        }
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = 0;
        }
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            n = this.groupAssignments[n2];
            if (n == 0) continue;
            fArrayArray[n - 1][nArray2[n - 1]] = fArray[n2];
            int n3 = n - 1;
            nArray2[n3] = nArray2[n3] + 1;
        }
        float[] fArray2 = new float[nArray.length];
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = this.getMean(fArrayArray[n]);
        }
        double[] dArray = new double[fArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = fArray2[i];
        }
        return dArray;
    }

    private int[] getGroupCounts() {
        int n;
        int[] nArray = new int[this.numMultiClassGroups];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < this.groupAssignments.length; ++n) {
            int n2 = this.groupAssignments[n];
            if (n2 == 0) continue;
            int n3 = n2 - 1;
            nArray[n3] = nArray[n3] + 1;
        }
        return nArray;
    }

    private double sTwoClassUnpaired(int n, FloatMatrix floatMatrix) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            if (this.groupAssignments[n2] == 1) {
                ++n3;
                continue;
            }
            if (this.groupAssignments[n2] != 2) continue;
            ++n4;
        }
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n4];
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            if (this.groupAssignments[n2] == 1) {
                fArray[n3] = floatMatrix.A[n][n2];
                ++n3;
                continue;
            }
            if (this.groupAssignments[n2] != 2) continue;
            fArray2[n4] = floatMatrix.A[n][n2];
            ++n4;
        }
        n2 = fArray.length;
        int n5 = fArray2.length;
        float f = this.getMean(fArray);
        float f2 = this.getMean(fArray2);
        float f3 = this.getVar(fArray);
        float f4 = this.getVar(fArray2);
        double d = Math.sqrt((1.0f / (float)n2 + 1.0f / (float)n5) * (f3 + f4) / (float)(n2 + n5 - 2));
        return d;
    }

    private float getVar(float[] fArray) {
        float f = this.getMean(fArray);
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            float f3 = (fArray[i] - f) * (fArray[i] - f);
            f2 += f3;
        }
        return f2;
    }

    private double getVar(double[] dArray) {
        double d = this.getMean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            double d3 = (dArray[i] - d) * (dArray[i] - d);
            d2 += d3;
        }
        return d2;
    }

    private float getVariance(float[] fArray) {
        float f = this.getMean(fArray);
        float f2 = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            float f3 = (fArray[i] - f) * (fArray[i] - f);
            f2 += f3;
            ++n;
        }
        if (n == 1) {
            return 0.0f;
        }
        if (n < 1) {
            return Float.NaN;
        }
        return f2 / (float)n;
    }

    private double getVariance(double[] dArray) {
        double d = this.getMean(dArray);
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            double d3 = (dArray[i] - d) * (dArray[i] - d);
            d2 += d3;
            ++n;
        }
        if (n == 1) {
            return 0.0;
        }
        if (n < 1) {
            return Double.NaN;
        }
        return d2 / (double)n;
    }

    private double[] getQValues() {
        double[] dArray = new double[101];
        dArray[0] = Double.NEGATIVE_INFINITY;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = this.getSAlpha(i);
        }
        return dArray;
    }

    private double getSNought() throws AlgorithmException {
        double d = 0.0;
        double[] dArray = new double[101];
        dArray[0] = Double.NEGATIVE_INFINITY;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = this.getSAlpha(i);
        }
        double[] dArray2 = new double[21];
        double d2 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = d2;
            if (!((d2 += 5.0) > 100.0)) continue;
            d2 = 100.0;
        }
        double[] dArray3 = new double[dArray2.length];
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, dArray2.length);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < dArray2.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            algorithmEvent.setIntValue(i);
            algorithmEvent.setDescription("Calculating S0: Current alpha = " + dArray2[i]);
            this.fireValueChanged(algorithmEvent);
            dArray3[i] = this.getCvAlpha(dArray2[i], dArray);
        }
        QSort qSort = new QSort(dArray3);
        double[] dArray4 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        int n = nArray[0];
        double d3 = dArray2[n];
        d = this.getSAlpha(d3);
        this.s0Percentile = d3;
        return d;
    }

    private double getCvAlpha(double d, double[] dArray) {
        Vector<Double> vector = new Vector<Double>();
        for (int i = 1; i < 101; ++i) {
            double d2 = this.getMAD(i, d);
            vector.add(new Double(d2));
        }
        double[] dArray2 = new double[vector.size()];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = (Double)vector.get(i);
        }
        double d3 = this.getVar(dArray2);
        double d4 = this.getMean(dArray2);
        double d5 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            if (Double.isNaN(dArray2[i])) continue;
            d5 += 1.0;
        }
        if (d5 == 1.0) {
            return 0.0;
        }
        if (d5 == 0.0) {
            return Double.NaN;
        }
        double d6 = Math.sqrt(d3 / (d5 - 1.0));
        return d6 / d4;
    }

    private double getMAD(int n, double d) {
        double[] dArray = this.getAllSValues();
        double[] dArray2 = this.getQValues();
        Vector vector = this.getValidSValuesAndGenes(dArray, dArray2, n);
        Vector vector2 = (Vector)vector.get(0);
        Vector vector3 = (Vector)vector.get(1);
        double[] dArray3 = new double[vector2.size()];
        for (int i = 0; i < dArray3.length; ++i) {
            double d2;
            int n2 = (Integer)vector3.get(i);
            dArray3[i] = d2 = this.getDAlpha(n2, d);
        }
        double d3 = this.getMedian(dArray3);
        double[] dArray4 = new double[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray4[i] = Math.abs(dArray3[i] - d3);
        }
        double d4 = this.getMedian(dArray4) / 0.64;
        return d4;
    }

    private double getMedian(double[] dArray) {
        QSort qSort = new QSort(dArray);
        double d = 0.0;
        double[] dArray2 = qSort.getSortedDouble();
        if (dArray2.length % 2 == 0) {
            double d2 = dArray2.length / 2;
            int n = (int)Math.round(d2);
            int n2 = n - 1;
            d = (dArray2[n] + dArray2[n2]) / 2.0;
        } else {
            double d3 = (double)(dArray2.length / 2) - 0.5;
            int n = (int)Math.round(d3);
            d = dArray2[n];
        }
        return d;
    }

    private Vector getValidSValuesAndGenes(double[] dArray, double[] dArray2, int n) {
        Vector vector = new Vector();
        Vector<Double> vector2 = new Vector<Double>();
        Vector<Integer> vector3 = new Vector<Integer>();
        if (n == 100) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] >= dArray2[n])) continue;
                vector2.add(new Double(dArray[i]));
                vector3.add(new Integer(i));
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] >= dArray2[n] && dArray[i] < dArray2[n + 1]) {
                    vector2.add(new Double(dArray[i]));
                    vector3.add(new Integer(i));
                    continue;
                }
                if (dArray[i] != dArray2[n] || dArray[i] != dArray2[n + 1]) continue;
                vector2.add(new Double(dArray[i]));
                vector3.add(new Integer(i));
            }
        }
        vector.add(vector2);
        vector.add(vector3);
        return vector;
    }

    private double getD(int n, FloatMatrix floatMatrix) {
        return this.getR(n, floatMatrix) / (this.getS(n, floatMatrix) + this.sNought);
    }

    private double getDAlpha(int n, double d) {
        return this.getR(n, this.imputedMatrix) / (this.getS(n, this.imputedMatrix) + this.getSAlpha(d));
    }

    private double getSAlpha(double d) {
        double d2 = 0.0;
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = this.getS(i, this.imputedMatrix);
        }
        QSort qSort = new QSort(dArray);
        double[] dArray2 = qSort.getSortedDouble();
        int n = (int)Math.floor((double)dArray2.length * d / 100.0) - 1;
        if (n < 0) {
            n = 0;
        } else if (n >= dArray2.length) {
            n = dArray2.length - 1;
        }
        d2 = dArray2[n];
        return d2;
    }

    private double[] getAllSValues() {
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = this.getS(i, this.imputedMatrix);
        }
        return dArray;
    }

    private double getS(int n, FloatMatrix floatMatrix) {
        double d = 0.0;
        if (this.studyDesign == 4) {
            return this.sTwoClassUnpaired(n, floatMatrix);
        }
        if (this.studyDesign == 5) {
            return this.sTwoClassPaired(n, floatMatrix);
        }
        if (this.studyDesign == 6) {
            return this.sMultiClass(n, floatMatrix);
        }
        if (this.studyDesign == 7) {
            return this.sCensoredSurvival(n, floatMatrix);
        }
        return d;
    }

    private double getR(int n, FloatMatrix floatMatrix) {
        double d = 0.0;
        if (this.studyDesign == 4) {
            return this.rTwoClassUnpaired(n, floatMatrix);
        }
        if (this.studyDesign == 5) {
            return this.rTwoClassPaired(n, floatMatrix);
        }
        if (this.studyDesign == 6) {
            return this.rMultiClass(n, floatMatrix);
        }
        if (this.studyDesign == 7) {
            return this.rCensoredSurvival(n, floatMatrix);
        }
        return d;
    }

    private void printMatrix(FloatMatrix floatMatrix, String string) throws Exception {
        File file = new File(string);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                printWriter.print(floatMatrix.A[i][j]);
                if (j >= floatMatrix.getColumnDimension() - 1) continue;
                printWriter.print("\t");
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            int n3;
            float[] fArray = new float[n2];
            float[] fArray2 = new float[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                fArray[n3] = floatMatrix.A[i][n3];
                fArray2[n3] = floatMatrix.A[i][n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!Float.isNaN(floatMatrix.A[i][n3])) continue;
                fArray[n3] = this.getMean(fArray2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                floatMatrix2.A[i][n3] = fArray[n3];
            }
        }
        return floatMatrix2;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        return f /= (float)n;
    }

    private double getMean(double[] dArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d += dArray[i];
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        double d2 = d / (double)n;
        return d2;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix floatMatrix, int n) {
        int n2 = floatMatrix.getRowDimension();
        int n3 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n2, n3);
        for (int i = 0; i < n2; ++i) {
            if (this.isMissingValues(floatMatrix, i)) {
                Vector<Integer> vector = new Vector<Integer>();
                for (int j = 0; j < n3; ++j) {
                    if (Float.isNaN(floatMatrix.A[i][j])) continue;
                    vector.add(new Integer(j));
                }
                Vector vector2 = this.getValidGenes(i, floatMatrix, vector);
                Vector vector3 = this.getKNearestGenes(i, n, floatMatrix, vector2, vector);
                for (int j = 0; j < n3; ++j) {
                    floatMatrix2.A[i][j] = !Float.isNaN(floatMatrix.A[i][j]) ? floatMatrix.A[i][j] : this.getExptWeightedMean(i, j, vector3, floatMatrix);
                }
                continue;
            }
            for (int j = 0; j < n3; ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][j];
            }
        }
        return this.imputeRowAverageMatrix(floatMatrix2);
    }

    private void printSubMatrix(Vector vector, FloatMatrix floatMatrix) {
        for (int i = 0; i < vector.size(); ++i) {
            int n = (Integer)vector.get(i);
            System.out.print("Gene " + (Integer)vector.get(i) + " :\t");
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                System.out.print("" + floatMatrix.A[n][j] + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    private float getExptMean(int n, Vector vector, FloatMatrix floatMatrix) {
        float f = 0.0f;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n3 = (Integer)vector.get(i);
            if (Float.isNaN(floatMatrix.A[n3][n])) continue;
            f += floatMatrix.A[n3][n];
            ++n2;
        }
        f = n2 > 0 ? (f /= (float)n2) : Float.NaN;
        return f;
    }

    private float getExptWeightedMean(int n, int n2, Vector vector, FloatMatrix floatMatrix) {
        int n3;
        float f = 0.0f;
        int n4 = 0;
        float f2 = 0.0f;
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            n3 = (Integer)vector.get(i);
            if (!Float.isNaN(floatMatrix.A[n3][n2])) {
                float f3 = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, n, n3, this.factor);
                if (f3 == 0.0f) {
                    f3 = Float.MIN_VALUE;
                }
                fArray[i] = 1.0f / f3;
                f2 += fArray[i] * floatMatrix.A[n3][n2];
                ++n4;
                continue;
            }
            fArray[i] = 0.0f;
        }
        float f4 = 0.0f;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            f4 += fArray[n3];
        }
        f = f2 / f4;
        return f;
    }

    Vector getKNearestGenes(int n, int n2, FloatMatrix floatMatrix, Vector vector, Vector vector2) {
        float f;
        int n3;
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<Float> vector5 = new Vector<Float>();
        for (int i = 0; i < vector.size(); ++i) {
            n3 = (Integer)vector.get(i);
            if (n == n3) continue;
            f = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, n, n3, this.factor);
            vector5.add(new Float(f));
            vector3.add(new Integer(n3));
        }
        float[] fArray = new float[vector5.size()];
        for (n3 = 0; n3 < vector5.size(); ++n3) {
            fArray[n3] = f = ((Float)vector5.get(n3)).floatValue();
        }
        QSort qSort = new QSort(fArray);
        float[] fArray2 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i];
            int n5 = (Integer)vector3.get(n4);
            vector4.add(new Integer(n5));
        }
        return vector4;
    }

    private boolean isMissingValues(FloatMatrix floatMatrix, int n) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            if (!Float.isNaN(floatMatrix.A[n][i])) continue;
            return true;
        }
        return false;
    }

    private Vector getValidGenes(int n, FloatMatrix floatMatrix, Vector vector) {
        int n2;
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < floatMatrix.getRowDimension(); ++n2) {
            if (!this.hasAllExpts(n2, floatMatrix, vector)) continue;
            vector2.add(new Integer(n2));
        }
        if (vector2.size() < this.numNeighbors) {
            n2 = this.numNeighbors - vector2.size();
            Vector vector3 = this.getAdditionalGenes(n, n2, vector2, floatMatrix);
            for (int i = 0; i < vector3.size(); ++i) {
                vector2.add((Integer)vector3.get(i));
            }
        }
        return vector2;
    }

    private Vector getAdditionalGenes(int n, int n2, Vector vector, FloatMatrix floatMatrix) {
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Float> vector4 = new Vector<Float>();
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (i == n) continue;
            float f = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, i, n, this.factor);
            vector4.add(new Float(f));
            vector3.add(new Integer(i));
        }
        float[] fArray = new float[vector4.size()];
        for (int i = 0; i < vector4.size(); ++i) {
            float f;
            fArray[i] = f = ((Float)vector4.get(i)).floatValue();
        }
        QSort qSort = new QSort(fArray);
        float[] fArray2 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            int n5 = (Integer)vector3.get(n4);
            if (this.belongsIn(vector, n5)) continue;
            vector2.add(new Integer(n5));
            if (++n3 >= n2) break;
        }
        return vector2;
    }

    private boolean belongsIn(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    private boolean hasAllExpts(int n, FloatMatrix floatMatrix, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (!Float.isNaN(floatMatrix.A[n][n2])) continue;
            return false;
        }
        return true;
    }
}

