/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.util.FloatMatrix;

public class CentroidExperimentHeader
extends JPanel {
    private String vectorString;
    private CentroidVectorPanel centroidVectorPanel;
    private int[][] clusters;
    private int clusterIndex = 0;
    private int currHeight;
    private int currWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private ExperimentHeader expHeader;

    public CentroidExperimentHeader(JComponent jComponent, FloatMatrix floatMatrix, int[][] nArray, String string) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.clusters = nArray;
        this.expHeader = (ExperimentHeader)jComponent;
        this.centroidVectorPanel = new CentroidVectorPanel(floatMatrix);
        this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centroidVectorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.vectorString = string;
        this.currHeight = 0;
        this.currWidth = 0;
    }

    public int getCurrWidth() {
        return this.currWidth;
    }

    public int getCurrHeight() {
        return this.currHeight + this.expHeader.getHeight();
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    private int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public void updateSize(Dimension dimension) {
        this.centroidVectorPanel.updateSize(dimension);
    }

    public void setCurrentCluster(int n) {
        this.centroidVectorPanel.setCurrentCluster(n);
    }

    public void setDrawBorders(boolean bl) {
        this.centroidVectorPanel.setDrawBorders(bl);
    }

    public void setValues(float f, float f2) {
        this.centroidVectorPanel.setValues(f, f2);
    }

    public void setNegAndPosColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.centroidVectorPanel.negColorImage = bufferedImage;
        this.centroidVectorPanel.posColorImage = bufferedImage2;
    }

    public void setMissingColor(Color color) {
        this.centroidVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean bl) {
        this.centroidVectorPanel.setAntiAliasing(bl);
    }

    private class CentroidVectorPanel
    extends JPanel {
        private FloatMatrix codes;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private Dimension elementSize;
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private BufferedImage negColorImage;

        public CentroidVectorPanel(FloatMatrix floatMatrix) {
            this.setBackground(Color.white);
            this.codes = floatMatrix;
        }

        public void setColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            this.posColorImage = bufferedImage;
            this.negColorImage = bufferedImage2;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int n) {
            this.cluster = n;
            CentroidExperimentHeader.this.clusterIndex = n;
        }

        public void setDrawBorders(boolean bl) {
            this.drawBorders = bl;
        }

        public void setAntiAliasing(boolean bl) {
            this.isAntiAliasing = bl;
        }

        public void setValues(float f, float f2) {
            this.maxValue = f;
            this.minValue = f2;
        }

        public int getCurrWidth() {
            return CentroidExperimentHeader.this.currWidth;
        }

        public void setLeftInset(int n) {
            ((CentroidExperimentHeader)CentroidExperimentHeader.this).insets.left = n;
        }

        public int getCurrHeight() {
            return CentroidExperimentHeader.this.currHeight;
        }

        public void updateSize(Dimension dimension) {
            this.elementSize = new Dimension(dimension);
            this.setFont(new Font("monospaced", 0, dimension.height));
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            int n = 0;
            if (graphics2D != null) {
                if (this.isAntiAliasing) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                n = fontMetrics.stringWidth(CentroidExperimentHeader.this.vectorString) + 10;
            }
            int n2 = dimension.width * this.codes.getColumnDimension() + n + ((CentroidExperimentHeader)CentroidExperimentHeader.this).insets.left + 10;
            int n3 = dimension.height + 10;
            CentroidExperimentHeader.this.currWidth = n2;
            CentroidExperimentHeader.this.currHeight = n3;
            this.setMinimumSize(new Dimension(n2, n3));
            this.setPreferredSize(new Dimension(n2, n3));
            this.setSize(n2, n3);
            this.validate();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (CentroidExperimentHeader.this.getCluster().length < 1) {
                return;
            }
            if (this.isAntiAliasing) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int n = this.codes.getColumnDimension();
            for (int i = 0; i < n; ++i) {
                this.fillRectAt(graphics, i, this.getColor(this.codes.get(this.cluster, i)));
                if (!this.drawBorders) continue;
                this.drawRectAt(graphics, i, Color.black);
            }
            graphics.setColor(Color.black);
            graphics.drawString(CentroidExperimentHeader.this.vectorString, this.elementSize.width * n + 10 + ((CentroidExperimentHeader)CentroidExperimentHeader.this).insets.left, this.elementSize.height);
        }

        private void fillRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.fillRect(n * this.elementSize.width + ((CentroidExperimentHeader)CentroidExperimentHeader.this).insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.drawRect(n * this.elementSize.width + ((CentroidExperimentHeader)CentroidExperimentHeader.this).insets.left, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float f) {
            if (Float.isNaN(f) || this.posColorImage == null || this.negColorImage == null) {
                return this.missingColor;
            }
            float f2 = f < 0.0f ? this.minValue : this.maxValue;
            int n = (int)(255.0f * f / f2);
            n = n > 255 ? 255 : n;
            int n2 = f < 0.0f ? this.negColorImage.getRGB(255 - n, 0) : this.posColorImage.getRGB(n, 0);
            return new Color(n2);
        }
    }
}

